/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Overshadowable;

public class SegmentLoadInfo
implements Overshadowable<SegmentLoadInfo> {
    private final DataSegment segment;
    private final Set<DruidServerMetadata> servers;

    public SegmentLoadInfo(DataSegment segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        this.segment = segment;
        this.servers = Sets.newConcurrentHashSet();
    }

    public boolean addServer(DruidServerMetadata server) {
        return this.servers.add(server);
    }

    public boolean removeServer(DruidServerMetadata server) {
        return this.servers.remove(server);
    }

    public boolean isEmpty() {
        return this.servers.isEmpty();
    }

    public ImmutableSegmentLoadInfo toImmutableSegmentLoadInfo() {
        return new ImmutableSegmentLoadInfo(this.segment, this.servers);
    }

    public DruidServerMetadata pickOne() {
        int randomPosition = ThreadLocalRandom.current().nextInt(this.servers.size());
        Iterator<DruidServerMetadata> serversIterator = this.servers.iterator();
        int index = 0;
        DruidServerMetadata randomServer = null;
        while (serversIterator.hasNext()) {
            randomServer = serversIterator.next();
            if (index == randomPosition) break;
            ++index;
        }
        return randomServer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentLoadInfo that = (SegmentLoadInfo)o;
        if (!this.segment.equals((Object)that.segment)) {
            return false;
        }
        return this.servers.equals(that.servers);
    }

    public int hashCode() {
        int result = this.segment.hashCode();
        result = 31 * result + this.servers.hashCode();
        return result;
    }

    public String toString() {
        return "SegmentLoadInfo{segment=" + this.segment + ", servers=" + this.servers + '}';
    }

    public boolean overshadows(SegmentLoadInfo other) {
        return this.segment.overshadows(other.segment);
    }

    public int getStartRootPartitionId() {
        return this.segment.getStartRootPartitionId();
    }

    public int getEndRootPartitionId() {
        return this.segment.getEndRootPartitionId();
    }

    public String getVersion() {
        return this.segment.getVersion();
    }

    public short getMinorVersion() {
        return this.segment.getMinorVersion();
    }

    public short getAtomicUpdateGroupSize() {
        return this.segment.getAtomicUpdateGroupSize();
    }
}

