/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.io.AppendableByteArrayInputStream;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.query.Query;
import org.apache.druid.query.context.ResponseContext;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class DataServerResponseHandler
implements HttpResponseHandler<AppendableByteArrayInputStream, InputStream> {
    private static final Logger log = new Logger(DataServerResponseHandler.class);
    private final String queryId;
    private final ResponseContext responseContext;
    private final ObjectMapper objectMapper;

    public <T> DataServerResponseHandler(Query<T> query, ResponseContext responseContext, ObjectMapper objectMapper) {
        this.queryId = query.getId();
        this.responseContext = responseContext;
        this.objectMapper = objectMapper;
    }

    public ClientResponse<AppendableByteArrayInputStream> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
        log.debug("Received response status[%s] for queryId[%s]", new Object[]{response.getStatus(), this.queryId});
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream();
        in.add(this.getContentBytes(response.getContent()));
        try {
            String queryResponseHeaders = response.headers().get("X-Druid-Response-Context");
            if (queryResponseHeaders != null) {
                this.responseContext.merge(ResponseContext.deserialize((String)queryResponseHeaders, (ObjectMapper)this.objectMapper));
            }
            return ClientResponse.finished((Object)in);
        }
        catch (IOException e) {
            return ClientResponse.finished((Object)new AppendableByteArrayInputStream(){

                public int read() throws IOException {
                    throw e;
                }
            });
        }
    }

    public ClientResponse<AppendableByteArrayInputStream> handleChunk(ClientResponse<AppendableByteArrayInputStream> clientResponse, HttpChunk chunk, long chunkNum) {
        ((AppendableByteArrayInputStream)clientResponse.getObj()).add(this.getContentBytes(chunk.getContent()));
        return clientResponse;
    }

    public ClientResponse<InputStream> done(ClientResponse<AppendableByteArrayInputStream> clientResponse) {
        AppendableByteArrayInputStream obj = (AppendableByteArrayInputStream)clientResponse.getObj();
        obj.done();
        return ClientResponse.finished((Object)obj);
    }

    public void exceptionCaught(ClientResponse<AppendableByteArrayInputStream> clientResponse, Throwable e) {
        AppendableByteArrayInputStream obj = (AppendableByteArrayInputStream)clientResponse.getObj();
        obj.exceptionCaught(e);
    }

    private byte[] getContentBytes(ChannelBuffer content) {
        byte[] contentBytes = new byte[content.readableBytes()];
        content.readBytes(contentBytes);
        return contentBytes;
    }
}

