/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.druid.metadata.SQLMetadataStorageActionHandler;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.exceptions.ResultSetException;

public class SqlEntity
implements InputEntity {
    private static final Logger LOG = new Logger(SqlEntity.class);
    private final String sql;
    private final ObjectMapper objectMapper;
    private final SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector;
    private final boolean foldCase;

    public SqlEntity(String sql, SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector, boolean foldCase, ObjectMapper objectMapper) {
        this.sql = sql;
        this.sqlFirehoseDatabaseConnector = (SQLFirehoseDatabaseConnector)Preconditions.checkNotNull((Object)sqlFirehoseDatabaseConnector, (Object)"SQL Metadata Connector not configured!");
        this.foldCase = foldCase;
        this.objectMapper = objectMapper;
    }

    public String getSql() {
        return this.sql;
    }

    @Nullable
    public URI getUri() {
        return null;
    }

    public InputStream open() {
        throw new UnsupportedOperationException("Please use fetch() instead");
    }

    public InputEntity.CleanableFile fetch(File temporaryDirectory, byte[] fetchBuffer) throws IOException {
        File tempFile = File.createTempFile("druid-sql-entity", ".tmp", temporaryDirectory);
        return SqlEntity.openCleanableFile(this.sql, this.sqlFirehoseDatabaseConnector, this.objectMapper, this.foldCase, tempFile);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InputEntity.CleanableFile openCleanableFile(String sql, SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector, ObjectMapper objectMapper, boolean foldCase, final File tempFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            InputEntity.CleanableFile cleanableFile;
            block14: {
                JsonGenerator jg = objectMapper.getFactory().createGenerator((OutputStream)fos);
                try {
                    SerializerProvider serializers = objectMapper.getSerializerProviderInstance();
                    sqlFirehoseDatabaseConnector.retryWithHandle(handle -> {
                        ResultIterator resultIterator = handle.createQuery(sql).map((index, r, ctx) -> {
                            ResultSetMetaData resultMetadata;
                            HashMap resultRow = foldCase ? new CaseFoldedMap() : new HashMap();
                            try {
                                resultMetadata = r.getMetaData();
                            }
                            catch (SQLException e) {
                                throw new ResultSetException("Unable to obtain metadata from result set", (Exception)e, ctx);
                            }
                            try {
                                for (int i = 1; i <= resultMetadata.getColumnCount(); ++i) {
                                    String key = resultMetadata.getColumnName(i);
                                    String alias = resultMetadata.getColumnLabel(i);
                                    Object value = r.getObject(i);
                                    resultRow.put(alias != null ? alias : key, value);
                                }
                            }
                            catch (SQLException e) {
                                throw new ResultSetException("Unable to access specific metadata from result set metadata", (Exception)e, ctx);
                            }
                            return resultRow;
                        }).iterator();
                        jg.writeStartArray();
                        while (resultIterator.hasNext()) {
                            JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)resultIterator.next());
                        }
                        jg.writeEndArray();
                        jg.close();
                        return null;
                    }, (Predicate<Throwable>)((Predicate)exception -> sqlFirehoseDatabaseConnector.isTransientException((Throwable)exception) && !SQLMetadataStorageActionHandler.isStatementException(exception)));
                    cleanableFile = new InputEntity.CleanableFile(){

                        public File file() {
                            return tempFile;
                        }

                        public void close() {
                            if (!tempFile.delete()) {
                                LOG.warn("Failed to remove file[%s]", new Object[]{tempFile.getAbsolutePath()});
                            }
                        }
                    };
                    if (jg == null) break block14;
                }
                catch (Throwable throwable) {
                    if (jg != null) {
                        try {
                            jg.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jg.close();
            }
            return cleanableFile;
        }
        catch (Exception e) {
            if (!tempFile.delete()) {
                LOG.warn("Failed to remove file[%s]", new Object[]{tempFile.getAbsolutePath()});
            }
            throw new IOException(e);
        }
    }

    private static class CaseFoldedMap
    extends HashMap<String, Object> {
        public static final long serialVersionUID = 1L;

        private CaseFoldedMap() {
        }

        @Override
        public Object get(Object obj) {
            return super.get(obj == null ? null : StringUtils.toLowerCase((String)((String)obj)));
        }

        @Override
        public Object put(String key, Object value) {
            return super.put(key == null ? null : StringUtils.toLowerCase((String)key), value);
        }

        @Override
        public boolean containsKey(Object obj) {
            return super.containsKey(obj == null ? null : StringUtils.toLowerCase((String)((String)obj)));
        }
    }
}

