/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.druid.common.utils.ServletResourceUtils;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupReferencesManager;
import org.apache.druid.query.lookup.LookupUtils;
import org.apache.druid.query.lookup.LookupsState;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.listener.resource.AbstractListenerHandler;
import org.apache.druid.server.listener.resource.ListenerResource;

@Path(value="/druid/listen/v1/lookups")
@ResourceFilters(value={ConfigResourceFilter.class})
class LookupListeningResource
extends ListenerResource {
    private static final Logger LOG = new Logger(LookupListeningResource.class);
    private static final TypeReference<LookupsState<Object>> LOOKUPS_STATE_GENERIC_REFERENCE = new TypeReference<LookupsState<Object>>(){};

    @Inject
    public LookupListeningResource(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, final LookupReferencesManager manager) {
        super(jsonMapper, smileMapper, new AbstractListenerHandler<LookupExtractorFactory>((TypeReference)new TypeReference<LookupExtractorFactory>(){}){

            @Override
            public Response handleUpdates(InputStream inputStream, ObjectMapper mapper) {
                LookupsState state;
                try {
                    LookupsState stateGeneric = (LookupsState)mapper.readValue(inputStream, LOOKUPS_STATE_GENERIC_REFERENCE);
                    Map<String, LookupExtractorFactoryContainer> current = LookupUtils.tryConvertObjectMapToLookupConfigMap(stateGeneric.getCurrent(), mapper);
                    Map<String, LookupExtractorFactoryContainer> toLoad = LookupUtils.tryConvertObjectMapToLookupConfigMap(stateGeneric.getToLoad(), mapper);
                    state = new LookupsState(current, toLoad, stateGeneric.getToDrop());
                }
                catch (IOException ex) {
                    LOG.debug((Throwable)ex, "Bad request", new Object[0]);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)ex)).build();
                }
                try {
                    state.getToLoad().forEach(manager::add);
                    state.getToDrop().forEach(lookName -> manager.remove((String)lookName, state.getToLoad().getOrDefault(lookName, null)));
                    return Response.status((Response.Status)Response.Status.ACCEPTED).entity(manager.getAllLookupsState()).build();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Error handling request", new Object[0]);
                    return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
                }
            }

            @Override
            public Object post(Map<String, LookupExtractorFactory> lookups) {
                HashMap failedUpdates = new HashMap();
                for (Map.Entry<String, LookupExtractorFactory> lookup : lookups.entrySet()) {
                    LookupExtractorFactoryContainer factoryContainer = new LookupExtractorFactoryContainer(null, lookup.getValue());
                    manager.add(lookup.getKey(), factoryContainer);
                }
                return ImmutableMap.of((Object)"status", (Object)"accepted", (Object)"failedUpdates", failedUpdates);
            }

            @Override
            public Object get(String id) {
                return manager.get(id).orElse(null);
            }

            public LookupsState<LookupExtractorFactoryContainer> getAll() {
                return manager.getAllLookupsState();
            }

            @Override
            public Object delete(String id) {
                manager.remove(id, null);
                return id;
            }
        });
    }
}

