/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.jboss.netty.util.internal.ThreadLocalRandom;

public class FixedSetServiceLocator
implements ServiceLocator {
    private ServiceLocations serviceLocations;

    private FixedSetServiceLocator(ServiceLocations serviceLocations) {
        this.serviceLocations = serviceLocations;
    }

    public static FixedSetServiceLocator forServiceLocation(@NotNull ServiceLocation serviceLocation) {
        return new FixedSetServiceLocator(ServiceLocations.forLocation(serviceLocation));
    }

    public static FixedSetServiceLocator forDruidServerMetadata(Set<DruidServerMetadata> serverMetadataSet) {
        if (serverMetadataSet == null || serverMetadataSet.isEmpty()) {
            return new FixedSetServiceLocator(ServiceLocations.closed());
        }
        Set<ServiceLocation> serviceLocationSet = serverMetadataSet.stream().map(ServiceLocation::fromDruidServerMetadata).collect(Collectors.toSet());
        return new FixedSetServiceLocator(ServiceLocations.forLocations(serviceLocationSet));
    }

    @Override
    public ListenableFuture<ServiceLocations> locate() {
        if (this.serviceLocations.isClosed() || this.serviceLocations.getLocations().isEmpty()) {
            return Futures.immediateFuture((Object)ServiceLocations.closed());
        }
        Set<ServiceLocation> locationSet = this.serviceLocations.getLocations();
        return Futures.immediateFuture((Object)ServiceLocations.forLocation(locationSet.stream().skip(ThreadLocalRandom.current().nextInt(locationSet.size())).findFirst().orElse(null)));
    }

    @Override
    public void close() {
        this.serviceLocations = ServiceLocations.closed();
    }
}

