/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import java.io.IOException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class StandardRetryPolicy
implements ServiceRetryPolicy {
    private static final long DEFAULT_MIN_WAIT_MS = 100L;
    private static final long DEFAULT_MAX_WAIT_MS = 30000L;
    private static final int MAX_ATTEMPTS_ABOUT_AN_HOUR = 125;
    private static final StandardRetryPolicy DEFAULT_UNLIMITED_POLICY = new Builder().maxAttempts(-1L).build();
    private static final StandardRetryPolicy DEFAULT_UNLIMITED_POLICY_NO_RETRY_LOG = new Builder().maxAttempts(-1L).retryLoggable(false).build();
    private static final StandardRetryPolicy DEFAULT_ABOUT_AN_HOUR_POLICY = new Builder().maxAttempts(125L).build();
    private static final StandardRetryPolicy DEFAULT_NO_RETRIES_POLICY = new Builder().maxAttempts(1L).build();
    private final long maxAttempts;
    private final long minWaitMillis;
    private final long maxWaitMillis;
    private final boolean retryNotAvailable;
    private final boolean retryLoggable;

    private StandardRetryPolicy(long maxAttempts, long minWaitMillis, long maxWaitMillis, boolean retryNotAvailable, boolean retryLoggable) {
        this.maxAttempts = maxAttempts;
        this.minWaitMillis = minWaitMillis;
        this.maxWaitMillis = maxWaitMillis;
        this.retryNotAvailable = retryNotAvailable;
        this.retryLoggable = retryLoggable;
        if (maxAttempts == 0L) {
            throw new IAE("maxAttempts must be positive (limited) or negative (unlimited); cannot be zero.", new Object[0]);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StandardRetryPolicy unlimited() {
        return DEFAULT_UNLIMITED_POLICY;
    }

    public static StandardRetryPolicy unlimitedWithoutRetryLogging() {
        return DEFAULT_UNLIMITED_POLICY_NO_RETRY_LOG;
    }

    public static StandardRetryPolicy aboutAnHour() {
        return DEFAULT_ABOUT_AN_HOUR_POLICY;
    }

    public static StandardRetryPolicy noRetries() {
        return DEFAULT_NO_RETRIES_POLICY;
    }

    @Override
    public long maxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public long minWaitMillis() {
        return this.minWaitMillis;
    }

    @Override
    public long maxWaitMillis() {
        return this.maxWaitMillis;
    }

    @Override
    public boolean retryHttpResponse(HttpResponse response) {
        int code = response.getStatus().getCode();
        return code == HttpResponseStatus.BAD_GATEWAY.getCode() || code == HttpResponseStatus.SERVICE_UNAVAILABLE.getCode() || code == HttpResponseStatus.GATEWAY_TIMEOUT.getCode() || code == HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode();
    }

    @Override
    public boolean retryThrowable(Throwable t) {
        return t instanceof IOException || t instanceof ChannelException || t.getCause() != null && this.retryThrowable(t.getCause());
    }

    @Override
    public boolean retryLoggable() {
        return this.retryLoggable;
    }

    @Override
    public boolean retryNotAvailable() {
        return this.retryNotAvailable;
    }

    public static class Builder {
        private long maxAttempts = 0L;
        private long minWaitMillis = 100L;
        private long maxWaitMillis = 30000L;
        private boolean retryNotAvailable = true;
        private boolean retryLoggable = true;

        public Builder maxAttempts(long maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder minWaitMillis(long minWaitMillis) {
            this.minWaitMillis = minWaitMillis;
            return this;
        }

        public Builder maxWaitMillis(long maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
            return this;
        }

        public Builder retryNotAvailable(boolean retryNotAvailable) {
            this.retryNotAvailable = retryNotAvailable;
            return this;
        }

        public Builder retryLoggable(boolean retryLoggable) {
            this.retryLoggable = retryLoggable;
            return this;
        }

        public StandardRetryPolicy build() {
            return new StandardRetryPolicy(this.maxAttempts, this.minWaitMillis, this.maxWaitMillis, this.retryNotAvailable, this.retryLoggable);
        }
    }
}

