/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.indexing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.IndexingWorkerInfo;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Interval;

public class OverlordClientImpl
implements OverlordClient {
    private final ServiceClient client;
    private final ObjectMapper jsonMapper;

    public OverlordClientImpl(ServiceClient client, ObjectMapper jsonMapper) {
        this.client = (ServiceClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
    }

    @Override
    public ListenableFuture<URI> findCurrentLeader() {
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/leader"), new StringFullResponseHandler(StandardCharsets.UTF_8)), holder -> {
            try {
                return new URI(holder.getContent());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public ListenableFuture<Void> runTask(String taskId, Object taskObject) {
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/task").jsonContent(this.jsonMapper, taskObject), new BytesFullResponseHandler()), holder -> {
            Map map = (Map)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String returnedTaskId = (String)map.get("task");
            Preconditions.checkState((boolean)taskId.equals(returnedTaskId), (String)"Got a different taskId[%s]. Expected taskId[%s]", (Object)returnedTaskId, (Object)taskId);
            return null;
        });
    }

    @Override
    public ListenableFuture<Void> cancelTask(String taskId) {
        String path = StringUtils.format((String)"/druid/indexer/v1/task/%s/shutdown", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)});
        return this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, path), IgnoreHttpResponseHandler.INSTANCE);
    }

    @Override
    public ListenableFuture<CloseableIterator<TaskStatusPlus>> taskStatuses(@Nullable String state, @Nullable String dataSource, @Nullable Integer maxCompletedTasks) {
        StringBuilder pathBuilder = new StringBuilder("/druid/indexer/v1/tasks");
        int params = 0;
        if (state != null) {
            pathBuilder.append('?').append("state=").append(StringUtils.urlEncode((String)state));
            ++params;
        }
        if (dataSource != null) {
            pathBuilder.append(params == 0 ? (char)'?' : '&').append("datasource=").append(StringUtils.urlEncode((String)dataSource));
            ++params;
        }
        if (maxCompletedTasks != null) {
            pathBuilder.append(params == 0 ? (char)'?' : '&').append("max=").append(maxCompletedTasks);
        }
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, pathBuilder.toString()), new InputStreamResponseHandler()), in -> this.asJsonParserIterator((InputStream)in, (Class)TaskStatusPlus.class));
    }

    @Override
    public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/taskStatus").jsonContent(this.jsonMapper, taskIds), new BytesFullResponseHandler()), holder -> (Map)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<Map<String, TaskStatus>>(){}));
    }

    @Override
    public ListenableFuture<TaskStatusResponse> taskStatus(String taskId) {
        String path = StringUtils.format((String)"/druid/indexer/v1/task/%s/status", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler()), holder -> (TaskStatusResponse)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), TaskStatusResponse.class));
    }

    @Override
    public ListenableFuture<Map<String, List<Interval>>> findLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
        String path = "/druid/indexer/v1/lockedIntervals/v2";
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/lockedIntervals/v2").jsonContent(this.jsonMapper, lockFilterPolicies), new BytesFullResponseHandler()), holder -> {
            Map response = (Map)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<Map<String, List<Interval>>>(){});
            return response == null ? Collections.emptyMap() : response;
        });
    }

    @Override
    public ListenableFuture<Map<String, Object>> taskReportAsMap(String taskId) {
        String path = StringUtils.format((String)"/druid/indexer/v1/task/%s/reports", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler()), holder -> (Map)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
    }

    @Override
    public ListenableFuture<CloseableIterator<SupervisorStatus>> supervisorStatuses() {
        String path = "/druid/indexer/v1/supervisor?system";
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/supervisor?system"), new InputStreamResponseHandler()), in -> this.asJsonParserIterator((InputStream)in, (Class)SupervisorStatus.class));
    }

    @Override
    public ListenableFuture<List<IndexingWorkerInfo>> getWorkers() {
        String path = "/druid/indexer/v1/workers";
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/workers"), new BytesFullResponseHandler()), holder -> (List)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<List<IndexingWorkerInfo>>(){}));
    }

    @Override
    public ListenableFuture<IndexingTotalWorkerCapacityInfo> getTotalWorkerCapacity() {
        String path = "/druid/indexer/v1/totalWorkerCapacity";
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, "/druid/indexer/v1/totalWorkerCapacity"), new BytesFullResponseHandler()), holder -> (IndexingTotalWorkerCapacityInfo)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), IndexingTotalWorkerCapacityInfo.class));
    }

    @Override
    public ListenableFuture<Integer> killPendingSegments(String dataSource, Interval interval) {
        String path = StringUtils.format((String)"/druid/indexer/v1/pendingSegments/%s?interval=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), StringUtils.urlEncode((String)interval.toString())});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.DELETE, path), new BytesFullResponseHandler()), holder -> {
            Map resultMap = (Map)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            Object numDeletedObject = resultMap.get("numDeleted");
            return (Integer)Preconditions.checkNotNull(numDeletedObject, (Object)"numDeletedObject");
        });
    }

    @Override
    public ListenableFuture<TaskPayloadResponse> taskPayload(String taskId) {
        String path = StringUtils.format((String)"/druid/indexer/v1/task/%s", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler()), holder -> (TaskPayloadResponse)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), TaskPayloadResponse.class));
    }

    @Override
    public OverlordClientImpl withRetryPolicy(ServiceRetryPolicy retryPolicy) {
        return new OverlordClientImpl(this.client.withRetryPolicy(retryPolicy), this.jsonMapper);
    }

    private <T> JsonParserIterator<T> asJsonParserIterator(InputStream in, Class<T> clazz) {
        return new JsonParserIterator(this.jsonMapper.getTypeFactory().constructType(clazz), (Future<InputStream>)Futures.immediateFuture((Object)in), "", null, "", this.jsonMapper);
    }
}

