/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.transform.Transform;
import org.apache.druid.segment.transform.TransformSpec;

public class ReaderUtils {
    private static final Logger LOG = new Logger(ReaderUtils.class);
    private static final Pattern JSON_PATH_PATTERN = Pattern.compile("\\[(.*?)]");
    private static final Pattern BRACKET_NOTATED_CHILD_PATTERN = Pattern.compile("'(.*?)'");

    public static Set<String> getColumnsRequiredForIngestion(Set<String> fullInputSchema, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, AggregatorFactory[] aggregators, @Nullable JSONPathSpec flattenSpec) {
        HashSet<String> fieldsRequired = new HashSet<String>();
        fieldsRequired.add(timestampSpec.getTimestampColumn());
        if (flattenSpec != null) {
            if (dimensionsSpec.getDimensions().isEmpty() && flattenSpec.isUseFieldDiscovery()) {
                return fullInputSchema;
            }
            for (JSONPathFieldSpec fields : flattenSpec.getFields()) {
                if (fields.getType() == JSONPathFieldType.ROOT) {
                    fieldsRequired.add(fields.getExpr());
                    continue;
                }
                if (fields.getType() == JSONPathFieldType.PATH) {
                    String parsedPath;
                    try {
                        parsedPath = JSONPathFieldSpec.getCompilePath((String)fields.getExpr());
                    }
                    catch (Exception e) {
                        LOG.debug("Ignoring columns from JSON path [%s] as path expression is invalid", new Object[]{fields.getExpr()});
                        continue;
                    }
                    parsedPath = parsedPath.substring(1);
                    if (parsedPath.length() >= 2 && "..".equals(parsedPath.substring(0, 2))) {
                        return fullInputSchema;
                    }
                    Matcher jsonPathMatcher = JSON_PATH_PATTERN.matcher(parsedPath);
                    if (!jsonPathMatcher.find()) {
                        LOG.warn("Failed to parse JSON path for required column from path [%s]", new Object[]{fields.getExpr()});
                        return fullInputSchema;
                    }
                    String matchedGroup = jsonPathMatcher.group();
                    Matcher childMatcher = BRACKET_NOTATED_CHILD_PATTERN.matcher(matchedGroup);
                    if (childMatcher.find()) {
                        childMatcher.reset();
                        while (childMatcher.find()) {
                            String columnName = childMatcher.group();
                            fieldsRequired.add(columnName.substring(1, columnName.length() - 1));
                        }
                        continue;
                    }
                    if ("[*]".equals(matchedGroup)) {
                        return fullInputSchema;
                    }
                    return fullInputSchema;
                }
                LOG.warn("Got unexpected JSONPathFieldType [%s]", new Object[]{fields.getType()});
                return fullInputSchema;
            }
            if (!flattenSpec.isUseFieldDiscovery()) {
                fieldsRequired.retainAll(fullInputSchema);
                return fieldsRequired;
            }
        } else if (dimensionsSpec.getDimensions().isEmpty()) {
            return fullInputSchema;
        }
        List transforms = transformSpec.getTransforms();
        for (Transform transform : transforms) {
            fieldsRequired.addAll(transform.getRequiredColumns());
        }
        List dimensionSchema = dimensionsSpec.getDimensions();
        for (DimensionSchema dim : dimensionSchema) {
            fieldsRequired.add(dim.getName());
        }
        for (AggregatorFactory agg : aggregators) {
            fieldsRequired.addAll(agg.requiredFields());
        }
        fieldsRequired.retainAll(fullInputSchema);
        return fieldsRequired;
    }
}

