/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.function.UnaryOperator;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;

public class CoordinatorConfigManager {
    private final JacksonConfigManager jacksonConfigManager;
    private final MetadataStorageConnector metadataStorageConnector;
    private final MetadataStorageTablesConfig tablesConfig;

    @Inject
    public CoordinatorConfigManager(JacksonConfigManager jacksonConfigManager, MetadataStorageConnector metadataStorageConnector, MetadataStorageTablesConfig tablesConfig) {
        this.jacksonConfigManager = jacksonConfigManager;
        this.metadataStorageConnector = metadataStorageConnector;
        this.tablesConfig = tablesConfig;
    }

    public CoordinatorDynamicConfig getCurrentDynamicConfig() {
        CoordinatorDynamicConfig dynamicConfig = (CoordinatorDynamicConfig)this.jacksonConfigManager.watch("coordinator.config", CoordinatorDynamicConfig.class, (Object)CoordinatorDynamicConfig.builder().build()).get();
        return (CoordinatorDynamicConfig)Preconditions.checkNotNull((Object)dynamicConfig, (Object)"Got null config from watcher?!");
    }

    public ConfigManager.SetResult setDynamicConfig(CoordinatorDynamicConfig config, AuditInfo auditInfo) {
        return this.jacksonConfigManager.set("coordinator.config", (Object)config, auditInfo);
    }

    public CoordinatorCompactionConfig getCurrentCompactionConfig() {
        CoordinatorCompactionConfig config = (CoordinatorCompactionConfig)this.jacksonConfigManager.watch("coordinator.compaction.config", CoordinatorCompactionConfig.class, (Object)CoordinatorCompactionConfig.empty()).get();
        return (CoordinatorCompactionConfig)Preconditions.checkNotNull((Object)config, (Object)"Got null config from watcher?!");
    }

    public ConfigManager.SetResult getAndUpdateCompactionConfig(UnaryOperator<CoordinatorCompactionConfig> operator, AuditInfo auditInfo) {
        CoordinatorCompactionConfig updated;
        byte[] currentBytes = this.metadataStorageConnector.lookup(this.tablesConfig.getConfigTable(), "name", "payload", "coordinator.compaction.config");
        CoordinatorCompactionConfig current = this.convertBytesToCompactionConfig(currentBytes);
        if (current.equals(updated = (CoordinatorCompactionConfig)operator.apply(current))) {
            return ConfigManager.SetResult.ok();
        }
        return this.jacksonConfigManager.set("coordinator.compaction.config", currentBytes, (Object)updated, auditInfo);
    }

    public CoordinatorCompactionConfig convertBytesToCompactionConfig(byte[] bytes) {
        return (CoordinatorCompactionConfig)this.jacksonConfigManager.convertByteToConfig(bytes, CoordinatorCompactionConfig.class, (Object)CoordinatorCompactionConfig.empty());
    }
}

