/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.List;
import java.util.Stack;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.joda.time.DateTime;

public class DataSourceCompactionConfigHistory {
    private final Stack<DataSourceCompactionConfigAuditEntry> auditEntries = new Stack();
    private final String dataSource;

    public DataSourceCompactionConfigHistory(String dataSource) {
        this.dataSource = dataSource;
    }

    public void add(CoordinatorCompactionConfig coordinatorCompactionConfig, AuditInfo auditInfo, DateTime auditTime) {
        DataSourceCompactionConfigAuditEntry current = this.auditEntries.isEmpty() ? null : this.auditEntries.peek();
        DataSourceCompactionConfigAuditEntry newEntry = null;
        boolean hasDataSourceCompactionConfig = false;
        for (DataSourceCompactionConfig dataSourceCompactionConfig : coordinatorCompactionConfig.getCompactionConfigs()) {
            if (!this.dataSource.equals(dataSourceCompactionConfig.getDataSource())) continue;
            hasDataSourceCompactionConfig = true;
            if (current != null && dataSourceCompactionConfig.equals(current.getCompactionConfig()) && current.getGlobalConfig().hasSameConfig(coordinatorCompactionConfig)) break;
            newEntry = current = new DataSourceCompactionConfigAuditEntry(new DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig(coordinatorCompactionConfig.getCompactionTaskSlotRatio(), coordinatorCompactionConfig.getMaxCompactionTaskSlots(), coordinatorCompactionConfig.isUseAutoScaleSlots()), dataSourceCompactionConfig, auditInfo, auditTime);
            break;
        }
        if (newEntry != null) {
            this.auditEntries.push(newEntry);
        } else if (current != null && !hasDataSourceCompactionConfig) {
            newEntry = new DataSourceCompactionConfigAuditEntry(new DataSourceCompactionConfigAuditEntry.GlobalCompactionConfig(coordinatorCompactionConfig.getCompactionTaskSlotRatio(), coordinatorCompactionConfig.getMaxCompactionTaskSlots(), coordinatorCompactionConfig.isUseAutoScaleSlots()), null, auditInfo, auditTime);
            this.auditEntries.push(newEntry);
        }
    }

    public List<DataSourceCompactionConfigAuditEntry> getHistory() {
        return this.auditEntries;
    }
}

