/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.loading.SegmentLoadQueueManager;
import org.apache.druid.server.coordinator.loading.SegmentLoadingConfig;
import org.apache.druid.server.coordinator.loading.SegmentReplicationStatus;
import org.apache.druid.server.coordinator.loading.StrategicSegmentAssigner;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.DateTime;

public class DruidCoordinatorRuntimeParams {
    private final DateTime coordinatorStartTime;
    private final DruidCluster druidCluster;
    private final MetadataRuleManager databaseRuleManager;
    private final StrategicSegmentAssigner segmentAssigner;
    @Nullable
    private final TreeSet<DataSegment> usedSegments;
    @Nullable
    private final DataSourcesSnapshot dataSourcesSnapshot;
    private final CoordinatorDynamicConfig coordinatorDynamicConfig;
    private final CoordinatorCompactionConfig coordinatorCompactionConfig;
    private final SegmentLoadingConfig segmentLoadingConfig;
    private final CoordinatorRunStats stats;
    private final BalancerStrategy balancerStrategy;
    private final Set<String> broadcastDatasources;

    private static TreeSet<DataSegment> createUsedSegmentsSet(Iterable<DataSegment> usedSegments) {
        TreeSet<DataSegment> segmentsSet = new TreeSet<DataSegment>((Comparator<DataSegment>)DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);
        usedSegments.forEach(segmentsSet::add);
        return segmentsSet;
    }

    private DruidCoordinatorRuntimeParams(DateTime coordinatorStartTime, DruidCluster druidCluster, MetadataRuleManager databaseRuleManager, StrategicSegmentAssigner segmentAssigner, @Nullable TreeSet<DataSegment> usedSegments, @Nullable DataSourcesSnapshot dataSourcesSnapshot, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorCompactionConfig coordinatorCompactionConfig, SegmentLoadingConfig segmentLoadingConfig, CoordinatorRunStats stats, BalancerStrategy balancerStrategy, Set<String> broadcastDatasources) {
        this.coordinatorStartTime = coordinatorStartTime;
        this.druidCluster = druidCluster;
        this.databaseRuleManager = databaseRuleManager;
        this.segmentAssigner = segmentAssigner;
        this.usedSegments = usedSegments;
        this.dataSourcesSnapshot = dataSourcesSnapshot;
        this.coordinatorDynamicConfig = coordinatorDynamicConfig;
        this.coordinatorCompactionConfig = coordinatorCompactionConfig;
        this.segmentLoadingConfig = segmentLoadingConfig;
        this.stats = stats;
        this.balancerStrategy = balancerStrategy;
        this.broadcastDatasources = broadcastDatasources;
    }

    public DateTime getCoordinatorStartTime() {
        return this.coordinatorStartTime;
    }

    public DruidCluster getDruidCluster() {
        return this.druidCluster;
    }

    public MetadataRuleManager getDatabaseRuleManager() {
        return this.databaseRuleManager;
    }

    @Nullable
    public SegmentReplicationStatus getSegmentReplicationStatus() {
        return this.segmentAssigner == null ? null : this.segmentAssigner.getReplicationStatus();
    }

    public StrategicSegmentAssigner getSegmentAssigner() {
        return this.segmentAssigner;
    }

    public Map<String, SegmentTimeline> getUsedSegmentsTimelinesPerDataSource() {
        Preconditions.checkState((this.dataSourcesSnapshot != null ? 1 : 0) != 0, (Object)"dataSourcesSnapshot or usedSegments must be set");
        return this.dataSourcesSnapshot.getUsedSegmentsTimelinesPerDataSource();
    }

    public TreeSet<DataSegment> getUsedSegments() {
        Preconditions.checkState((this.usedSegments != null ? 1 : 0) != 0, (Object)"usedSegments or dataSourcesSnapshot must be set");
        return this.usedSegments;
    }

    public CoordinatorDynamicConfig getCoordinatorDynamicConfig() {
        return this.coordinatorDynamicConfig;
    }

    public CoordinatorCompactionConfig getCoordinatorCompactionConfig() {
        return this.coordinatorCompactionConfig;
    }

    public SegmentLoadingConfig getSegmentLoadingConfig() {
        return this.segmentLoadingConfig;
    }

    public CoordinatorRunStats getCoordinatorStats() {
        return this.stats;
    }

    public BalancerStrategy getBalancerStrategy() {
        return this.balancerStrategy;
    }

    public Set<String> getBroadcastDatasources() {
        return this.broadcastDatasources;
    }

    public DataSourcesSnapshot getDataSourcesSnapshot() {
        Preconditions.checkState((this.dataSourcesSnapshot != null ? 1 : 0) != 0, (Object)"usedSegments or dataSourcesSnapshot must be set");
        return this.dataSourcesSnapshot;
    }

    public static Builder newBuilder(DateTime coordinatorStartTime) {
        return new Builder(coordinatorStartTime);
    }

    public Builder buildFromExisting() {
        return new Builder(this.coordinatorStartTime, this.druidCluster, this.databaseRuleManager, this.segmentAssigner, this.usedSegments, this.dataSourcesSnapshot, this.coordinatorDynamicConfig, this.coordinatorCompactionConfig, this.segmentLoadingConfig, this.stats, this.balancerStrategy, this.broadcastDatasources);
    }

    public static class Builder {
        private final DateTime coordinatorStartTime;
        private DruidCluster druidCluster;
        private MetadataRuleManager databaseRuleManager;
        private SegmentLoadQueueManager loadQueueManager;
        private StrategicSegmentAssigner segmentAssigner;
        @Nullable
        private TreeSet<DataSegment> usedSegments;
        @Nullable
        private DataSourcesSnapshot dataSourcesSnapshot;
        private CoordinatorDynamicConfig coordinatorDynamicConfig;
        private CoordinatorCompactionConfig coordinatorCompactionConfig;
        private SegmentLoadingConfig segmentLoadingConfig;
        private CoordinatorRunStats stats;
        private BalancerStrategy balancerStrategy;
        private Set<String> broadcastDatasources;

        private Builder(DateTime coordinatorStartTime) {
            this.coordinatorStartTime = coordinatorStartTime;
            this.coordinatorDynamicConfig = CoordinatorDynamicConfig.builder().build();
            this.coordinatorCompactionConfig = CoordinatorCompactionConfig.empty();
            this.broadcastDatasources = Collections.emptySet();
        }

        private Builder(DateTime coordinatorStartTime, DruidCluster cluster, MetadataRuleManager databaseRuleManager, StrategicSegmentAssigner segmentAssigner, @Nullable TreeSet<DataSegment> usedSegments, @Nullable DataSourcesSnapshot dataSourcesSnapshot, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorCompactionConfig coordinatorCompactionConfig, SegmentLoadingConfig segmentLoadingConfig, CoordinatorRunStats stats, BalancerStrategy balancerStrategy, Set<String> broadcastDatasources) {
            this.coordinatorStartTime = coordinatorStartTime;
            this.druidCluster = cluster;
            this.databaseRuleManager = databaseRuleManager;
            this.segmentAssigner = segmentAssigner;
            this.usedSegments = usedSegments;
            this.dataSourcesSnapshot = dataSourcesSnapshot;
            this.coordinatorDynamicConfig = coordinatorDynamicConfig;
            this.coordinatorCompactionConfig = coordinatorCompactionConfig;
            this.segmentLoadingConfig = segmentLoadingConfig;
            this.stats = stats;
            this.balancerStrategy = balancerStrategy;
            this.broadcastDatasources = broadcastDatasources;
        }

        public DruidCoordinatorRuntimeParams build() {
            this.initStatsIfRequired();
            this.initSegmentAssignerIfRequired();
            return new DruidCoordinatorRuntimeParams(this.coordinatorStartTime, this.druidCluster, this.databaseRuleManager, this.segmentAssigner, this.usedSegments, this.dataSourcesSnapshot, this.coordinatorDynamicConfig, this.coordinatorCompactionConfig, this.segmentLoadingConfig, this.stats, this.balancerStrategy, this.broadcastDatasources);
        }

        private void initStatsIfRequired() {
            Map<Dimension, String> debugDimensions = this.coordinatorDynamicConfig == null ? null : this.coordinatorDynamicConfig.getValidatedDebugDimensions();
            this.stats = this.stats == null ? new CoordinatorRunStats(debugDimensions) : this.stats;
        }

        private void initSegmentAssignerIfRequired() {
            if (this.segmentAssigner != null || this.loadQueueManager == null) {
                return;
            }
            Preconditions.checkNotNull((Object)this.druidCluster);
            Preconditions.checkNotNull((Object)this.balancerStrategy);
            Preconditions.checkNotNull(this.usedSegments);
            Preconditions.checkNotNull((Object)this.stats);
            if (this.segmentLoadingConfig == null) {
                this.segmentLoadingConfig = SegmentLoadingConfig.create(this.coordinatorDynamicConfig, this.usedSegments.size());
            }
            this.segmentAssigner = new StrategicSegmentAssigner(this.loadQueueManager, this.druidCluster, this.balancerStrategy, this.segmentLoadingConfig, this.stats);
        }

        public Builder withDruidCluster(DruidCluster cluster) {
            this.druidCluster = cluster;
            return this;
        }

        public Builder withDatabaseRuleManager(MetadataRuleManager databaseRuleManager) {
            this.databaseRuleManager = databaseRuleManager;
            return this;
        }

        public Builder withSegmentAssignerUsing(SegmentLoadQueueManager loadQueueManager) {
            this.loadQueueManager = loadQueueManager;
            return this;
        }

        public Builder withDataSourcesSnapshot(DataSourcesSnapshot snapshot) {
            this.usedSegments = DruidCoordinatorRuntimeParams.createUsedSegmentsSet(snapshot.iterateAllUsedSegmentsInSnapshot());
            this.dataSourcesSnapshot = snapshot;
            return this;
        }

        public Builder withUsedSegments(DataSegment ... usedSegments) {
            return this.withUsedSegments(Arrays.asList(usedSegments));
        }

        public Builder withUsedSegments(Collection<DataSegment> usedSegments) {
            this.usedSegments = DruidCoordinatorRuntimeParams.createUsedSegmentsSet(usedSegments);
            this.dataSourcesSnapshot = DataSourcesSnapshot.fromUsedSegments(usedSegments, (ImmutableMap<String, String>)ImmutableMap.of());
            return this;
        }

        public Builder withDynamicConfigs(CoordinatorDynamicConfig configs) {
            this.coordinatorDynamicConfig = configs;
            return this;
        }

        public Builder withSegmentLoadingConfig(SegmentLoadingConfig config) {
            this.segmentLoadingConfig = config;
            return this;
        }

        public Builder withCompactionConfig(CoordinatorCompactionConfig config) {
            this.coordinatorCompactionConfig = config;
            return this;
        }

        public Builder withBalancerStrategy(BalancerStrategy balancerStrategy) {
            this.balancerStrategy = balancerStrategy;
            return this;
        }

        public Builder withBroadcastDatasources(Set<String> broadcastDatasources) {
            this.broadcastDatasources = broadcastDatasources;
            return this;
        }
    }
}

