/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.balancer.BalancerStrategy;
import org.apache.druid.server.coordinator.balancer.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.DisabledCachingCostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.DiskNormalizedCostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.balancer.RandomBalancerStrategyFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="strategy", defaultImpl=CostBalancerStrategyFactory.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="cost", value=CostBalancerStrategyFactory.class), @JsonSubTypes.Type(name="cachingCost", value=DisabledCachingCostBalancerStrategyFactory.class), @JsonSubTypes.Type(name="diskNormalized", value=DiskNormalizedCostBalancerStrategyFactory.class), @JsonSubTypes.Type(name="random", value=RandomBalancerStrategyFactory.class)})
public abstract class BalancerStrategyFactory {
    private static final Logger log = new Logger(BalancerStrategyFactory.class);
    private int cachedBalancerThreadNumber;
    private ListeningExecutorService balancerExec;

    public abstract BalancerStrategy createBalancerStrategy(int var1);

    public void stopExecutor() {
        if (this.balancerExec != null) {
            this.balancerExec.shutdownNow();
            this.balancerExec = null;
        }
    }

    protected ListeningExecutorService getOrCreateBalancerExecutor(int balancerComputeThreads) {
        if (this.balancerExec == null) {
            this.balancerExec = this.createNewBalancerExecutor(balancerComputeThreads);
        } else if (this.cachedBalancerThreadNumber != balancerComputeThreads) {
            log.info("'balancerComputeThreads' has changed from [%d] to [%d].", new Object[]{this.cachedBalancerThreadNumber, balancerComputeThreads});
            this.balancerExec.shutdownNow();
            this.balancerExec = this.createNewBalancerExecutor(balancerComputeThreads);
        }
        return this.balancerExec;
    }

    private ListeningExecutorService createNewBalancerExecutor(int numThreads) {
        log.info("Creating new balancer executor with [%d] threads.", new Object[]{numThreads});
        this.cachedBalancerThreadNumber = numThreads;
        return MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)numThreads, (String)"coordinator-cost-balancer-%s"));
    }
}

