/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.SegmentCountsPerInterval;
import org.apache.druid.server.coordinator.ServerHolder;
import org.joda.time.Duration;

public class SegmentToMoveCalculator {
    private static final int MIN_SEGMENTS_TO_MOVE = 100;
    private static final Logger log = new Logger(SegmentToMoveCalculator.class);

    public static int computeNumSegmentsToMoveInTier(String tier, List<ServerHolder> historicals, int maxSegmentsToMoveInTier) {
        int totalSegments = historicals.stream().mapToInt(server -> server.getProjectedSegments().getTotalSegmentCount()).sum();
        int minSegmentsToMove = SegmentToMoveCalculator.computeMinSegmentsToMoveInTier(totalSegments);
        int segmentsToMoveToFixDeviation = SegmentToMoveCalculator.computeNumSegmentsToMoveToBalanceTier(tier, historicals);
        log.info("Need to move [%,d] segments in tier[%s] to attain balance. Allowed values are [min=%d, max=%d].", new Object[]{segmentsToMoveToFixDeviation, tier, minSegmentsToMove, maxSegmentsToMoveInTier});
        int activeSegmentsToMove = Math.max(minSegmentsToMove, segmentsToMoveToFixDeviation);
        return Math.min(activeSegmentsToMove, maxSegmentsToMoveInTier);
    }

    public static int computeMinSegmentsToMoveInTier(int totalSegmentsInTier) {
        int upperBound = (totalSegmentsInTier >> 16) * 100;
        int lowerBound = Math.min(100, totalSegmentsInTier);
        return Math.max(lowerBound, upperBound);
    }

    public static int computeMaxSegmentsToMovePerTier(int totalSegments, int numBalancerThreads, Duration coordinatorPeriod) {
        Preconditions.checkArgument((numBalancerThreads > 0 && numBalancerThreads <= 100 ? 1 : 0) != 0, (Object)"Number of balancer threads must be in range (0, 100].");
        if (totalSegments <= 0) {
            return 0;
        }
        int upperBound = (totalSegments >> 9) * 100;
        int lowerBound = 100;
        int num30sPeriods = Math.min(4, (int)(coordinatorPeriod.getMillis() / 30000L));
        int maxComputationsInThousands = numBalancerThreads * num30sPeriods << 20;
        int maxSegmentsToMove = maxComputationsInThousands / totalSegments * 1000;
        if (upperBound < 100) {
            return Math.min(100, totalSegments);
        }
        return Math.min(maxSegmentsToMove, upperBound);
    }

    public static int computeNumSegmentsToMoveToBalanceTier(String tier, List<ServerHolder> historicals) {
        if (historicals.isEmpty()) {
            return 0;
        }
        return Math.max(SegmentToMoveCalculator.computeSegmentsToMoveToBalanceCountsPerDatasource(tier, historicals), SegmentToMoveCalculator.computeSegmentsToMoveToBalanceDiskUsage(tier, historicals));
    }

    private static double getAverageSegmentSize(List<ServerHolder> servers) {
        int totalSegmentCount = 0;
        long totalUsageBytes = 0L;
        for (ServerHolder server : servers) {
            totalSegmentCount += server.getProjectedSegments().getTotalSegmentCount();
            totalUsageBytes += server.getProjectedSegments().getTotalSegmentBytes();
        }
        if (totalSegmentCount <= 0 || totalUsageBytes <= 0L) {
            return 0.0;
        }
        return 1.0 * (double)totalUsageBytes / (double)totalSegmentCount;
    }

    static int computeSegmentsToMoveToBalanceCountsPerDatasource(String tier, List<ServerHolder> servers) {
        Set datasources = servers.stream().flatMap(s -> s.getProjectedSegments().getDatasourceToTotalSegmentCount().keySet().stream()).collect(Collectors.toSet());
        if (datasources.isEmpty()) {
            return 0;
        }
        Object2IntOpenHashMap datasourceToMaxSegments = new Object2IntOpenHashMap();
        Object2IntOpenHashMap datasourceToMinSegments = new Object2IntOpenHashMap();
        for (ServerHolder server : servers) {
            Object2IntMap<String> datasourceToSegmentCount = server.getProjectedSegments().getDatasourceToTotalSegmentCount();
            for (String datasource : datasources) {
                int count = datasourceToSegmentCount.getInt((Object)datasource);
                datasourceToMaxSegments.mergeInt((Object)datasource, count, Math::max);
                datasourceToMinSegments.mergeInt((Object)datasource, count, Math::min);
            }
        }
        TreeMap countDiffToDatasource = new TreeMap(Comparator.reverseOrder());
        datasourceToMaxSegments.object2IntEntrySet().forEach(arg_0 -> SegmentToMoveCalculator.lambda$computeSegmentsToMoveToBalanceCountsPerDatasource$2((Object2IntMap)datasourceToMinSegments, countDiffToDatasource, arg_0));
        Map.Entry maxCountDifference = countDiffToDatasource.firstEntry();
        String mostUnbalancedDatasource = (String)maxCountDifference.getValue();
        int minNumSegments = Integer.MAX_VALUE;
        int maxNumSegments = 0;
        for (ServerHolder server : servers) {
            int countForSkewedDatasource = server.getProjectedSegments().getDatasourceToTotalSegmentCount().getInt((Object)mostUnbalancedDatasource);
            minNumSegments = Math.min(minNumSegments, countForSkewedDatasource);
            maxNumSegments = Math.max(maxNumSegments, countForSkewedDatasource);
        }
        int numSegmentsToMove = (Integer)maxCountDifference.getKey() / 2;
        if (numSegmentsToMove > 0) {
            log.info("Need to move [%,d] segments of datasource[%s] in tier[%s] to fix gap between min[%,d] and max[%,d].", new Object[]{numSegmentsToMove, mostUnbalancedDatasource, tier, minNumSegments, maxNumSegments});
        }
        return numSegmentsToMove;
    }

    private static int computeSegmentsToMoveToBalanceDiskUsage(String tier, List<ServerHolder> servers) {
        int numSegmentsToMove;
        if (servers.isEmpty()) {
            return 0;
        }
        double maxUsagePercent = 0.0;
        double minUsagePercent = 100.0;
        long maxUsageBytes = 0L;
        long minUsageBytes = Long.MAX_VALUE;
        for (ServerHolder server : servers) {
            SegmentCountsPerInterval projectedSegments = server.getProjectedSegments();
            long serverUsageBytes = projectedSegments.getTotalSegmentBytes();
            maxUsageBytes = Math.max(serverUsageBytes, maxUsageBytes);
            minUsageBytes = Math.min(serverUsageBytes, minUsageBytes);
            double diskUsage = server.getMaxSize() <= 0L ? 0.0 : 100.0 * (double)projectedSegments.getTotalSegmentBytes() / (double)server.getMaxSize();
            maxUsagePercent = Math.max(diskUsage, maxUsagePercent);
            minUsagePercent = Math.min(diskUsage, minUsagePercent);
        }
        double averageSegmentSize = SegmentToMoveCalculator.getAverageSegmentSize(servers);
        long differenceInUsageBytes = maxUsageBytes - minUsageBytes;
        int n = numSegmentsToMove = averageSegmentSize <= 0.0 ? 0 : (int)((double)differenceInUsageBytes / averageSegmentSize) / 2;
        if (numSegmentsToMove > 0) {
            log.info("Need to move [%,d] segments of avg size [%,d MB] in tier[%s] to fix disk usage gap between min[%d GB][%.1f%%] and max[%d GB][%.1f%%].", new Object[]{numSegmentsToMove, (long)averageSegmentSize >> 20, tier, minUsageBytes >> 30, minUsagePercent, maxUsageBytes >> 30, maxUsagePercent});
        }
        return numSegmentsToMove;
    }

    private SegmentToMoveCalculator() {
    }

    private static /* synthetic */ void lambda$computeSegmentsToMoveToBalanceCountsPerDatasource$2(Object2IntMap datasourceToMinSegments, TreeMap countDiffToDatasource, Object2IntMap.Entry entry) {
        String datasource = (String)entry.getKey();
        int maxCount = entry.getIntValue();
        int minCount = datasourceToMinSegments.getInt((Object)datasource);
        countDiffToDatasource.put(maxCount - minCount, datasource);
    }
}

