/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.compact;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.compact.CompactionSegmentIterator;
import org.apache.druid.server.coordinator.compact.CompactionStatistics;
import org.apache.druid.server.coordinator.compact.CompactionStatus;
import org.apache.druid.server.coordinator.compact.SegmentsToCompact;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.Streams;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class NewestSegmentFirstIterator
implements CompactionSegmentIterator {
    private static final Logger log = new Logger(NewestSegmentFirstIterator.class);
    private final ObjectMapper objectMapper;
    private final Map<String, DataSourceCompactionConfig> compactionConfigs;
    private final Map<String, CompactionStatistics> compactedSegmentStats = new HashMap<String, CompactionStatistics>();
    private final Map<String, CompactionStatistics> skippedSegmentStats = new HashMap<String, CompactionStatistics>();
    private final Map<String, CompactibleSegmentIterator> timelineIterators;
    private final Map<String, Set<Interval>> intervalCompactedForDatasource = new HashMap<String, Set<Interval>>();
    private final PriorityQueue<SegmentsToCompact> queue = new PriorityQueue((o1, o2) -> Comparators.intervalsByStartThenEnd().compare(o2.getUmbrellaInterval(), o1.getUmbrellaInterval()));

    NewestSegmentFirstIterator(ObjectMapper objectMapper, Map<String, DataSourceCompactionConfig> compactionConfigs, Map<String, SegmentTimeline> dataSources, Map<String, List<Interval>> skipIntervals) {
        this.objectMapper = objectMapper;
        this.compactionConfigs = compactionConfigs;
        this.timelineIterators = Maps.newHashMapWithExpectedSize((int)dataSources.size());
        dataSources.forEach((dataSource, timeline) -> {
            DataSourceCompactionConfig config = (DataSourceCompactionConfig)compactionConfigs.get(dataSource);
            Granularity configuredSegmentGranularity = null;
            if (config != null && !timeline.isEmpty()) {
                List<Interval> searchIntervals;
                SegmentTimeline originalTimeline = null;
                if (config.getGranularitySpec() != null && config.getGranularitySpec().getSegmentGranularity() != null) {
                    String temporaryVersion = DateTimes.nowUtc().toString();
                    HashMap<Interval, Set> intervalToPartitionMap = new HashMap<Interval, Set>();
                    configuredSegmentGranularity = config.getGranularitySpec().getSegmentGranularity();
                    SegmentTimeline timelineWithConfiguredSegmentGranularity = new SegmentTimeline();
                    Set segments = timeline.findNonOvershadowedObjectsInInterval(Intervals.ETERNITY, Partitions.ONLY_COMPLETE);
                    for (DataSegment dataSegment : segments) {
                        if (Intervals.ETERNITY.getStart().equals((Object)dataSegment.getInterval().getStart()) || Intervals.ETERNITY.getEnd().equals((Object)dataSegment.getInterval().getEnd())) {
                            log.warn("Cannot compact datasource[%s] containing segments with partial-ETERNITY intervals", new Object[]{dataSource});
                            return;
                        }
                        for (Interval interval : configuredSegmentGranularity.getIterable(dataSegment.getInterval())) {
                            intervalToPartitionMap.computeIfAbsent(interval, k -> new HashSet()).add(dataSegment);
                        }
                    }
                    for (Map.Entry entry : intervalToPartitionMap.entrySet()) {
                        Interval interval = (Interval)entry.getKey();
                        int partitionNum = 0;
                        Set segmentSet = (Set)entry.getValue();
                        int partitions = segmentSet.size();
                        for (DataSegment segment : segmentSet) {
                            DataSegment segmentsForCompact = segment.withShardSpec((ShardSpec)new NumberedShardSpec(partitionNum, partitions));
                            timelineWithConfiguredSegmentGranularity.add(interval, (Object)temporaryVersion, (PartitionChunk)NumberedPartitionChunk.make((int)partitionNum, (int)partitions, (Object)segmentsForCompact));
                            ++partitionNum;
                        }
                    }
                    originalTimeline = timeline;
                    timeline = timelineWithConfiguredSegmentGranularity;
                }
                if (!(searchIntervals = this.findInitialSearchInterval((String)dataSource, (SegmentTimeline)timeline, config.getSkipOffsetFromLatest(), configuredSegmentGranularity, (List)skipIntervals.get(dataSource))).isEmpty()) {
                    this.timelineIterators.put((String)dataSource, new CompactibleSegmentIterator((SegmentTimeline)timeline, searchIntervals, originalTimeline));
                }
            }
        });
        compactionConfigs.forEach((dataSourceName, config) -> {
            if (config == null) {
                throw new ISE("Unknown dataSource[%s]", new Object[]{dataSourceName});
            }
            this.updateQueue((String)dataSourceName, (DataSourceCompactionConfig)config);
        });
    }

    @Override
    public Map<String, CompactionStatistics> totalCompactedStatistics() {
        return this.compactedSegmentStats;
    }

    @Override
    public Map<String, CompactionStatistics> totalSkippedStatistics() {
        return this.skippedSegmentStats;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public SegmentsToCompact next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SegmentsToCompact entry = this.queue.poll();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        List<DataSegment> resultSegments = entry.getSegments();
        Preconditions.checkState((!resultSegments.isEmpty() ? 1 : 0) != 0, (Object)"Queue entry must not be empty");
        String dataSource = resultSegments.get(0).getDataSource();
        this.updateQueue(dataSource, this.compactionConfigs.get(dataSource));
        return entry;
    }

    private void updateQueue(String dataSourceName, DataSourceCompactionConfig config) {
        SegmentsToCompact segmentsToCompact = this.findSegmentsToCompact(dataSourceName, config);
        if (!segmentsToCompact.isEmpty()) {
            this.queue.add(segmentsToCompact);
        }
    }

    private SegmentsToCompact findSegmentsToCompact(String dataSourceName, DataSourceCompactionConfig config) {
        CompactibleSegmentIterator compactibleSegmentIterator = this.timelineIterators.get(dataSourceName);
        if (compactibleSegmentIterator == null) {
            log.warn("Skipping compaction for datasource[%s] as there is no compactible segment in its timeline.", new Object[]{dataSourceName});
            return SegmentsToCompact.empty();
        }
        long inputSegmentSize = config.getInputSegmentSizeBytes();
        while (compactibleSegmentIterator.hasNext()) {
            Object segments = compactibleSegmentIterator.next();
            if (segments.size() == 1 && ((DataSegment)segments.get(0)).isTombstone()) continue;
            SegmentsToCompact candidates = SegmentsToCompact.from((List<DataSegment>)segments);
            Interval interval = candidates.getUmbrellaInterval();
            CompactionStatus compactionStatus = CompactionStatus.of(candidates, config, this.objectMapper);
            if (!compactionStatus.isComplete()) {
                log.debug("Datasource[%s], interval[%s] has [%d] segments that need to be compacted because [%s].", new Object[]{dataSourceName, interval, candidates.size(), compactionStatus.getReasonToCompact()});
            }
            if (compactionStatus.isComplete()) {
                this.addSegmentStatsTo(this.compactedSegmentStats, dataSourceName, candidates);
                continue;
            }
            if (candidates.getTotalBytes() > inputSegmentSize) {
                this.addSegmentStatsTo(this.skippedSegmentStats, dataSourceName, candidates);
                log.warn("Skipping compaction for datasource[%s], interval[%s] as total segment size[%d] is larger than allowed inputSegmentSize[%d].", new Object[]{dataSourceName, interval, candidates.getTotalBytes(), inputSegmentSize});
                continue;
            }
            if (config.getGranularitySpec() != null && config.getGranularitySpec().getSegmentGranularity() != null) {
                Set compactedIntervals = this.intervalCompactedForDatasource.computeIfAbsent(dataSourceName, k -> new HashSet());
                if (compactedIntervals.contains(interval)) continue;
                compactedIntervals.add(interval);
                return candidates;
            }
            return candidates;
        }
        log.debug("No more segments to compact for datasource[%s].", new Object[]{dataSourceName});
        return SegmentsToCompact.empty();
    }

    private void addSegmentStatsTo(Map<String, CompactionStatistics> statisticsMap, String dataSourceName, SegmentsToCompact segments) {
        statisticsMap.computeIfAbsent(dataSourceName, v -> CompactionStatistics.create()).addFrom(segments);
    }

    private List<Interval> findInitialSearchInterval(String dataSourceName, SegmentTimeline timeline, Period skipOffset, Granularity configuredSegmentGranularity, @Nullable List<Interval> skipIntervals) {
        Preconditions.checkArgument((timeline != null && !timeline.isEmpty() ? 1 : 0) != 0, (Object)"timeline should not be null or empty");
        Preconditions.checkNotNull((Object)skipOffset, (Object)"skipOffset");
        TimelineObjectHolder first = (TimelineObjectHolder)Preconditions.checkNotNull((Object)timeline.first(), (Object)"first");
        TimelineObjectHolder last = (TimelineObjectHolder)Preconditions.checkNotNull((Object)timeline.last(), (Object)"last");
        List<Interval> fullSkipIntervals = NewestSegmentFirstIterator.sortAndAddSkipIntervalFromLatest(last.getInterval().getEnd(), skipOffset, configuredSegmentGranularity, skipIntervals);
        for (Interval skipInterval : fullSkipIntervals) {
            ArrayList<DataSegment> segments = new ArrayList<DataSegment>(timeline.findNonOvershadowedObjectsInInterval(skipInterval, Partitions.ONLY_COMPLETE));
            this.addSegmentStatsTo(this.skippedSegmentStats, dataSourceName, SegmentsToCompact.from(segments));
        }
        Interval totalInterval = new Interval((ReadableInstant)first.getInterval().getStart(), (ReadableInstant)last.getInterval().getEnd());
        List<Interval> filteredInterval = NewestSegmentFirstIterator.filterSkipIntervals(totalInterval, fullSkipIntervals);
        ArrayList<Interval> searchIntervals = new ArrayList<Interval>();
        for (Interval lookupInterval : filteredInterval) {
            if (Intervals.ETERNITY.getStart().equals((Object)lookupInterval.getStart()) || Intervals.ETERNITY.getEnd().equals((Object)lookupInterval.getEnd())) {
                log.warn("Cannot compact datasource[%s] since interval[%s] coincides with ETERNITY.", new Object[]{dataSourceName, lookupInterval});
                return Collections.emptyList();
            }
            List segments = timeline.findNonOvershadowedObjectsInInterval(lookupInterval, Partitions.ONLY_COMPLETE).stream().filter(segment -> lookupInterval.contains((ReadableInterval)segment.getInterval())).collect(Collectors.toList());
            if (segments.isEmpty()) continue;
            DateTime searchStart = segments.stream().map(segment -> segment.getId().getIntervalStart()).min(Comparator.naturalOrder()).orElseThrow(AssertionError::new);
            DateTime searchEnd = segments.stream().map(segment -> segment.getId().getIntervalEnd()).max(Comparator.naturalOrder()).orElseThrow(AssertionError::new);
            searchIntervals.add(new Interval((ReadableInstant)searchStart, (ReadableInstant)searchEnd));
        }
        return searchIntervals;
    }

    @VisibleForTesting
    static List<Interval> sortAndAddSkipIntervalFromLatest(DateTime latest, Period skipOffset, Granularity configuredSegmentGranularity, @Nullable List<Interval> skipIntervals) {
        Interval skipFromLatest;
        ArrayList<Interval> nonNullSkipIntervals;
        ArrayList<Object> arrayList = nonNullSkipIntervals = skipIntervals == null ? new ArrayList<Interval>(1) : new ArrayList(skipIntervals.size());
        if (configuredSegmentGranularity != null) {
            DateTime skipFromLastest = new DateTime((Object)latest, latest.getZone()).minus((ReadablePeriod)skipOffset);
            DateTime skipOffsetBucketToSegmentGranularity = configuredSegmentGranularity.bucketStart(skipFromLastest);
            skipFromLatest = new Interval((ReadableInstant)skipOffsetBucketToSegmentGranularity, (ReadableInstant)latest);
        } else {
            skipFromLatest = new Interval((ReadablePeriod)skipOffset, (ReadableInstant)latest);
        }
        if (skipIntervals != null) {
            ArrayList<Interval> sortedSkipIntervals = new ArrayList<Interval>(skipIntervals);
            sortedSkipIntervals.sort(Comparators.intervalsByStartThenEnd());
            ArrayList<Interval> overlapIntervals = new ArrayList<Interval>();
            for (Interval interval : sortedSkipIntervals) {
                if (interval.overlaps((ReadableInterval)skipFromLatest)) {
                    overlapIntervals.add(interval);
                    continue;
                }
                nonNullSkipIntervals.add(interval);
            }
            if (!overlapIntervals.isEmpty()) {
                overlapIntervals.add(skipFromLatest);
                nonNullSkipIntervals.add(JodaUtils.umbrellaInterval(overlapIntervals));
            } else {
                nonNullSkipIntervals.add(skipFromLatest);
            }
        } else {
            nonNullSkipIntervals.add(skipFromLatest);
        }
        return nonNullSkipIntervals;
    }

    @VisibleForTesting
    static List<Interval> filterSkipIntervals(Interval totalInterval, List<Interval> skipIntervals) {
        ArrayList<Interval> filteredIntervals = new ArrayList<Interval>(skipIntervals.size() + 1);
        DateTime remainingStart = totalInterval.getStart();
        DateTime remainingEnd = totalInterval.getEnd();
        for (Interval skipInterval : skipIntervals) {
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingStart) && skipInterval.getEnd().isAfter((ReadableInstant)remainingStart)) {
                remainingStart = skipInterval.getEnd();
                continue;
            }
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingEnd) && skipInterval.getEnd().isAfter((ReadableInstant)remainingEnd)) {
                remainingEnd = skipInterval.getStart();
                continue;
            }
            if (!remainingStart.isAfter((ReadableInstant)skipInterval.getStart()) && !remainingEnd.isBefore((ReadableInstant)skipInterval.getEnd())) {
                filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)skipInterval.getStart()));
                remainingStart = skipInterval.getEnd();
                continue;
            }
            log.warn("skipInterval[%s] is not contained in remainingInterval[%s]", new Object[]{skipInterval, new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd)});
        }
        if (!remainingStart.equals((Object)remainingEnd)) {
            filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd));
        }
        return filteredIntervals;
    }

    private static class CompactibleSegmentIterator
    implements Iterator<List<DataSegment>> {
        private final List<TimelineObjectHolder<String, DataSegment>> holders;
        @Nullable
        private final SegmentTimeline originalTimeline;

        CompactibleSegmentIterator(SegmentTimeline timeline, List<Interval> totalIntervalsToSearch, @Nullable SegmentTimeline originalTimeline) {
            this.holders = totalIntervalsToSearch.stream().flatMap(interval -> timeline.lookup(interval).stream().filter(holder -> this.isCompactibleHolder((Interval)interval, (TimelineObjectHolder<String, DataSegment>)holder))).collect(Collectors.toList());
            this.originalTimeline = originalTimeline;
        }

        private boolean isCompactibleHolder(Interval searchInterval, TimelineObjectHolder<String, DataSegment> holder) {
            long partitionBytes;
            Iterator chunks = holder.getObject().iterator();
            if (!chunks.hasNext()) {
                return false;
            }
            PartitionChunk firstChunk = (PartitionChunk)chunks.next();
            if (!searchInterval.contains((ReadableInterval)((DataSegment)firstChunk.getObject()).getInterval())) {
                return false;
            }
            for (partitionBytes = ((DataSegment)firstChunk.getObject()).getSize(); partitionBytes == 0L && chunks.hasNext(); partitionBytes += ((DataSegment)((PartitionChunk)chunks.next()).getObject()).getSize()) {
            }
            return partitionBytes > 0L;
        }

        @Override
        public boolean hasNext() {
            return !this.holders.isEmpty();
        }

        @Override
        public List<DataSegment> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TimelineObjectHolder<String, DataSegment> timelineObjectHolder = this.holders.remove(this.holders.size() - 1);
            List<DataSegment> candidates = Streams.sequentialStreamFrom((Iterable)timelineObjectHolder.getObject()).map(PartitionChunk::getObject).collect(Collectors.toList());
            if (this.originalTimeline == null) {
                return candidates;
            }
            Interval umbrellaInterval = JodaUtils.umbrellaInterval((Iterable)candidates.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
            return Lists.newArrayList((Iterable)this.originalTimeline.findNonOvershadowedObjectsInInterval(umbrellaInterval, Partitions.ONLY_COMPLETE));
        }
    }
}

