/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.compact;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class SegmentsToCompact {
    private static final SegmentsToCompact EMPTY_INSTANCE = new SegmentsToCompact();
    private final List<DataSegment> segments;
    private final Interval umbrellaInterval;
    private final long totalBytes;
    private final int numIntervals;

    static SegmentsToCompact empty() {
        return EMPTY_INSTANCE;
    }

    public static SegmentsToCompact from(List<DataSegment> segments) {
        if (segments == null || segments.isEmpty()) {
            return SegmentsToCompact.empty();
        }
        return new SegmentsToCompact(segments);
    }

    private SegmentsToCompact() {
        this.segments = Collections.emptyList();
        this.totalBytes = 0L;
        this.numIntervals = 0;
        this.umbrellaInterval = null;
    }

    private SegmentsToCompact(List<DataSegment> segments) {
        this.segments = segments;
        this.totalBytes = segments.stream().mapToLong(DataSegment::getSize).sum();
        this.umbrellaInterval = JodaUtils.umbrellaInterval((Iterable)segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
        this.numIntervals = (int)segments.stream().map(DataSegment::getInterval).distinct().count();
    }

    public List<DataSegment> getSegments() {
        return this.segments;
    }

    public DataSegment getFirst() {
        if (this.segments.isEmpty()) {
            throw new NoSuchElementException("No segment to compact");
        }
        return this.segments.get(0);
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public int size() {
        return this.segments.size();
    }

    public Interval getUmbrellaInterval() {
        return this.umbrellaInterval;
    }

    public long getNumIntervals() {
        return this.numIntervals;
    }

    public String toString() {
        return "SegmentsToCompact{segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + ", totalSize=" + this.totalBytes + '}';
    }
}

