/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Predicate;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class CoordinatorDutyUtils {
    private static final Logger LOG = new Logger(CoordinatorDutyUtils.class);

    public static int getTotalWorkerCapacity(@Nonnull OverlordClient overlordClient) {
        int totalWorkerCapacity;
        try {
            IndexingTotalWorkerCapacityInfo workerCapacityInfo = (IndexingTotalWorkerCapacityInfo)FutureUtils.get(overlordClient.getTotalWorkerCapacity(), (boolean)true);
            totalWorkerCapacity = workerCapacityInfo.getMaximumCapacityWithAutoScale();
            if (totalWorkerCapacity < 0) {
                totalWorkerCapacity = workerCapacityInfo.getCurrentClusterCapacity();
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpResponseException && ((HttpResponseException)e.getCause()).getResponse().getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
                LOG.noStackTrace().warn((Throwable)e, "Call to getTotalWorkerCapacity failed. Falling back to getWorkers.", new Object[0]);
                totalWorkerCapacity = ((List)FutureUtils.getUnchecked(overlordClient.getWorkers(), (boolean)true)).stream().mapToInt(worker -> worker.getWorker().getCapacity()).sum();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return totalWorkerCapacity;
    }

    public static List<TaskStatusPlus> getNumActiveTaskSlots(@Nonnull OverlordClient overlordClient, Predicate<TaskStatusPlus> taskPredicate) {
        CloseableIterator activeTasks = (CloseableIterator)FutureUtils.getUnchecked(overlordClient.taskStatuses(null, null, 0), (boolean)true);
        ArrayList<TaskStatusPlus> taskStatuses = new ArrayList<TaskStatusPlus>();
        try (Closer closer = Closer.create();){
            closer.register((Closeable)activeTasks);
            while (activeTasks.hasNext()) {
                TaskStatusPlus status = (TaskStatusPlus)activeTasks.next();
                if (null == status || null != status.getType() && !taskPredicate.apply((Object)status)) continue;
                taskStatuses.add(status);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return taskStatuses;
    }
}

