/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.java.util.RetryableException;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.MetadataCleanupDuty;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class KillCompactionConfig
extends MetadataCleanupDuty {
    private static final Logger log = new Logger(KillCompactionConfig.class);
    private static final int UPDATE_NUM_RETRY = 5;
    private final SegmentsMetadataManager sqlSegmentsMetadataManager;
    private final CoordinatorConfigManager configManager;

    public KillCompactionConfig(DruidCoordinatorConfig config, SegmentsMetadataManager sqlSegmentsMetadataManager, CoordinatorConfigManager configManager) {
        super("compaction configs", "druid.coordinator.kill.compaction", config.isCompactionKillEnabled(), config.getCoordinatorCompactionKillPeriod(), Duration.millis((long)1L), Stats.Kill.COMPACTION_CONFIGS, config);
        this.sqlSegmentsMetadataManager = sqlSegmentsMetadataManager;
        this.configManager = configManager;
    }

    @Override
    protected int cleanupEntriesCreatedBefore(DateTime minCreatedTime) {
        try {
            return (Integer)RetryUtils.retry(this::tryDeleteCompactionConfigs, e -> e instanceof RetryableException, (int)5);
        }
        catch (Exception e2) {
            log.error((Throwable)e2, "Failed to kill compaction configurations", new Object[0]);
            return 0;
        }
    }

    private CoordinatorCompactionConfig deleteConfigsForInactiveDatasources(CoordinatorCompactionConfig current) {
        if (CoordinatorCompactionConfig.empty().equals(current)) {
            log.info("Nothing to do as compaction config is already empty.", new Object[0]);
            return current;
        }
        Set<String> activeDatasources = this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames();
        Map updated = current.getCompactionConfigs().stream().filter(dataSourceCompactionConfig -> activeDatasources.contains(dataSourceCompactionConfig.getDataSource())).collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        return CoordinatorCompactionConfig.from(current, (List<DataSourceCompactionConfig>)ImmutableList.copyOf(updated.values()));
    }

    private int tryDeleteCompactionConfigs() throws RetryableException {
        AtomicInteger compactionConfigRemoved = new AtomicInteger(0);
        ConfigManager.SetResult result = this.configManager.getAndUpdateCompactionConfig(current -> {
            CoordinatorCompactionConfig updated = this.deleteConfigsForInactiveDatasources((CoordinatorCompactionConfig)current);
            int numCurrentConfigs = current.getCompactionConfigs() == null ? 0 : current.getCompactionConfigs().size();
            int numUpdatedConfigs = updated.getCompactionConfigs() == null ? 0 : updated.getCompactionConfigs().size();
            compactionConfigRemoved.set(Math.max(0, numCurrentConfigs - numUpdatedConfigs));
            return updated;
        }, new AuditInfo("KillCompactionConfig", "KillCompactionConfig", "CoordinatorDuty for automatic deletion of compaction config", ""));
        if (result.isOk()) {
            return compactionConfigRemoved.get();
        }
        if (result.isRetryable()) {
            log.debug("Retrying KillCompactionConfig duty", new Object[0]);
            throw new RetryableException((Throwable)result.getException());
        }
        log.error((Throwable)result.getException(), "Failed to kill compaction configurations", new Object[0]);
        return 0;
    }
}

