/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.MetadataCleanupDuty;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;

public class KillDatasourceMetadata
extends MetadataCleanupDuty {
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    private final MetadataSupervisorManager metadataSupervisorManager;

    public KillDatasourceMetadata(DruidCoordinatorConfig config, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, MetadataSupervisorManager metadataSupervisorManager) {
        super("datasources", "druid.coordinator.kill.datasource", config.isDatasourceKillEnabled(), config.getCoordinatorDatasourceKillPeriod(), config.getCoordinatorDatasourceKillDurationToRetain(), Stats.Kill.DATASOURCES, config);
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.metadataSupervisorManager = metadataSupervisorManager;
    }

    @Override
    protected int cleanupEntriesCreatedBefore(DateTime minCreatedTime) {
        Map<String, SupervisorSpec> allActiveSupervisor = this.metadataSupervisorManager.getLatestActiveOnly();
        Set<String> allDatasourceWithActiveSupervisor = allActiveSupervisor.values().stream().map(SupervisorSpec::getDataSources).flatMap(Collection::stream).filter(datasource -> !Strings.isNullOrEmpty((String)datasource)).collect(Collectors.toSet());
        return this.indexerMetadataStorageCoordinator.removeDataSourceMetadataOlderThan(minCreatedTime.getMillis(), allDatasourceWithActiveSupervisor);
    }
}

