/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.MetadataCleanupDuty;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;

public class KillSupervisors
extends MetadataCleanupDuty {
    private final MetadataSupervisorManager metadataSupervisorManager;

    public KillSupervisors(DruidCoordinatorConfig config, MetadataSupervisorManager metadataSupervisorManager) {
        super("supervisors", "druid.coordinator.kill.supervisor", config.isSupervisorKillEnabled(), config.getCoordinatorSupervisorKillPeriod(), config.getCoordinatorSupervisorKillDurationToRetain(), Stats.Kill.SUPERVISOR_SPECS, config);
        this.metadataSupervisorManager = metadataSupervisorManager;
    }

    @Override
    protected int cleanupEntriesCreatedBefore(DateTime minCreatedTime) {
        return this.metadataSupervisorManager.removeTerminatedSupervisorsOlderThan(minCreatedTime.getMillis());
    }
}

