/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public abstract class MetadataCleanupDuty
implements CoordinatorDuty {
    private static final Logger log = new Logger(MetadataCleanupDuty.class);
    private final String propertyPrefix;
    private final String entryType;
    private final CoordinatorStat cleanupCountStat;
    private final boolean cleanupEnabled;
    private final Duration cleanupPeriod;
    private final Duration retainDuration;
    private DateTime lastCleanupTime = DateTimes.utc((long)0L);

    protected MetadataCleanupDuty(String entryType, String propertyPrefix, boolean cleanupEnabled, Duration cleanupPeriod, Duration retainDuration, CoordinatorStat cleanupCountStat, DruidCoordinatorConfig coordinatorConfig) {
        this.propertyPrefix = propertyPrefix;
        this.entryType = entryType;
        this.cleanupEnabled = cleanupEnabled;
        this.cleanupPeriod = cleanupPeriod;
        this.retainDuration = retainDuration;
        this.cleanupCountStat = cleanupCountStat;
        if (this.cleanupEnabled) {
            this.validatePeriod(cleanupPeriod, coordinatorConfig.getCoordinatorMetadataStoreManagementPeriod());
            this.validateRetainDuration(retainDuration);
            log.debug("Enabled cleanup of [%s] with period [%s] and durationToRetain [%s].", new Object[]{entryType, cleanupPeriod, retainDuration});
        }
    }

    @Override
    @Nullable
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (!this.cleanupEnabled) {
            return params;
        }
        DateTime now = DateTimes.nowUtc();
        if (this.lastCleanupTime.plus((ReadableDuration)this.cleanupPeriod).isBefore((ReadableInstant)now)) {
            this.lastCleanupTime = now;
            try {
                DateTime minCreatedTime = now.minus((ReadableDuration)this.retainDuration);
                int deletedEntries = this.cleanupEntriesCreatedBefore(minCreatedTime);
                log.info("Removed [%,d] [%s] created before [%s].", new Object[]{deletedEntries, this.entryType, minCreatedTime});
                params.getCoordinatorStats().add(this.cleanupCountStat, deletedEntries);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to perform cleanup of [%s]", new Object[]{this.entryType});
            }
        }
        return params;
    }

    protected abstract int cleanupEntriesCreatedBefore(DateTime var1);

    private void validatePeriod(Duration period, Duration metadataManagementPeriod) {
        Preconditions.checkArgument((period != null && period.getMillis() >= metadataManagementPeriod.getMillis() ? 1 : 0) != 0, (String)"[%s.period] must be greater than [druid.coordinator.period.metadataStoreManagementPeriod]", (Object)this.propertyPrefix);
    }

    private void validateRetainDuration(Duration retainDuration) {
        Preconditions.checkArgument((retainDuration != null && retainDuration.getMillis() >= 0L ? 1 : 0) != 0, (String)"[%s.durationToRetain] must be 0 milliseconds or higher", (Object)this.propertyPrefix);
        Preconditions.checkArgument((retainDuration.getMillis() < System.currentTimeMillis() ? 1 : 0) != 0, (String)"[%s.durationToRetain] cannot be greater than current time in milliseconds", (Object)this.propertyPrefix);
    }
}

