/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordination.SegmentChangeRequestNoop;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.loading.LoadPeonCallback;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.coordinator.loading.SegmentAction;
import org.apache.druid.server.coordinator.loading.SegmentHolder;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@Deprecated
public class CuratorLoadQueuePeon
implements LoadQueuePeon {
    private static final EmittingLogger log = new EmittingLogger(CuratorLoadQueuePeon.class);
    private final CuratorFramework curator;
    private final String basePath;
    private final ObjectMapper jsonMapper;
    private final ScheduledExecutorService processingExecutor;
    private final ExecutorService callBackExecutor;
    private final DruidCoordinatorConfig config;
    private final AtomicLong queuedSize = new AtomicLong(0L);
    private final CoordinatorRunStats stats = new CoordinatorRunStats();
    private final ConcurrentSkipListMap<DataSegment, SegmentHolder> segmentsToLoad = new ConcurrentSkipListMap((Comparator<DataSegment>)DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);
    private final ConcurrentSkipListMap<DataSegment, SegmentHolder> segmentsToDrop = new ConcurrentSkipListMap((Comparator<DataSegment>)DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);
    private final ConcurrentSkipListSet<DataSegment> segmentsMarkedToDrop = new ConcurrentSkipListSet<DataSegment>((Comparator<DataSegment>)DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);
    private final ConcurrentSkipListSet<DataSegment> timedOutSegments = new ConcurrentSkipListSet<DataSegment>((Comparator<DataSegment>)DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);

    public CuratorLoadQueuePeon(CuratorFramework curator, String basePath, ObjectMapper jsonMapper, ScheduledExecutorService processingExecutor, ExecutorService callbackExecutor, DruidCoordinatorConfig config) {
        this.curator = curator;
        this.basePath = basePath;
        this.jsonMapper = jsonMapper;
        this.callBackExecutor = callbackExecutor;
        this.processingExecutor = processingExecutor;
        this.config = config;
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsToLoad() {
        return this.segmentsToLoad.keySet();
    }

    @Override
    public Set<SegmentHolder> getSegmentsInQueue() {
        HashSet<SegmentHolder> segmentsInQueue = new HashSet<SegmentHolder>();
        segmentsInQueue.addAll(this.segmentsToLoad.values());
        segmentsInQueue.addAll(this.segmentsToDrop.values());
        return segmentsInQueue;
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsToDrop() {
        return this.segmentsToDrop.keySet();
    }

    @Override
    @JsonProperty
    public Set<DataSegment> getSegmentsMarkedToDrop() {
        return this.segmentsMarkedToDrop;
    }

    @Override
    public Set<DataSegment> getTimedOutSegments() {
        return this.timedOutSegments;
    }

    @Override
    public long getSizeOfSegmentsToLoad() {
        return this.queuedSize.get();
    }

    @Override
    public CoordinatorRunStats getAndResetStats() {
        return this.stats.getSnapshotAndReset();
    }

    @Override
    public void loadSegment(DataSegment segment, SegmentAction action, @Nullable LoadPeonCallback callback) {
        SegmentHolder segmentHolder = new SegmentHolder(segment, action, callback);
        SegmentHolder existingHolder = this.segmentsToLoad.putIfAbsent(segment, segmentHolder);
        if (existingHolder != null) {
            existingHolder.addCallback(callback);
            return;
        }
        log.debug("Asking server peon[%s] to load segment[%s]", new Object[]{this.basePath, segment.getId()});
        this.queuedSize.addAndGet(segment.getSize());
        this.processingExecutor.submit(new SegmentChangeProcessor(segmentHolder));
    }

    @Override
    public void dropSegment(DataSegment segment, @Nullable LoadPeonCallback callback) {
        SegmentHolder segmentHolder = new SegmentHolder(segment, SegmentAction.DROP, callback);
        SegmentHolder existingHolder = this.segmentsToDrop.putIfAbsent(segment, segmentHolder);
        if (existingHolder != null) {
            existingHolder.addCallback(callback);
            return;
        }
        log.debug("Asking server peon[%s] to drop segment[%s]", new Object[]{this.basePath, segment.getId()});
        this.processingExecutor.submit(new SegmentChangeProcessor(segmentHolder));
    }

    @Override
    public void markSegmentToDrop(DataSegment dataSegment) {
        this.segmentsMarkedToDrop.add(dataSegment);
    }

    @Override
    public void unmarkSegmentToDrop(DataSegment dataSegment) {
        this.segmentsMarkedToDrop.remove(dataSegment);
    }

    private void actionCompleted(SegmentHolder segmentHolder) {
        switch (segmentHolder.getAction()) {
            case LOAD: 
            case REPLICATE: 
            case MOVE_TO: {
                if (null == this.segmentsToLoad.remove(segmentHolder.getSegment())) break;
                this.queuedSize.addAndGet(-segmentHolder.getSegment().getSize());
                this.timedOutSegments.remove(segmentHolder.getSegment());
                break;
            }
            case DROP: {
                this.segmentsToDrop.remove(segmentHolder.getSegment());
                this.timedOutSegments.remove(segmentHolder.getSegment());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.executeCallbacks(segmentHolder, true);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        for (SegmentHolder holder : this.segmentsToDrop.values()) {
            this.executeCallbacks(holder, false);
        }
        this.segmentsToDrop.clear();
        for (SegmentHolder holder : this.segmentsToLoad.values()) {
            this.executeCallbacks(holder, false);
        }
        this.segmentsToLoad.clear();
        this.timedOutSegments.clear();
        this.queuedSize.set(0L);
        this.stats.clear();
    }

    private void onZkNodeDeleted(SegmentHolder segmentHolder, String path) {
        if (!ZKPaths.getNodeFromPath((String)path).equals(segmentHolder.getSegmentIdentifier())) {
            log.warn("Server[%s] entry [%s] was removed even though it's not what is currently loading[%s]", new Object[]{this.basePath, path, segmentHolder});
            return;
        }
        this.actionCompleted(segmentHolder);
        log.debug("Server[%s] done processing %s of segment [%s]", new Object[]{this.basePath, segmentHolder.getAction(), path});
    }

    private void failAssign(SegmentHolder segmentHolder, boolean handleTimeout, Exception e) {
        if (e != null) {
            log.error((Throwable)e, "Server[%s], throwable caught when submitting [%s].", new Object[]{this.basePath, segmentHolder});
        }
        this.stats.add(Stats.SegmentQueue.FAILED_ACTIONS, 1L);
        if (handleTimeout) {
            log.debug("Skipping segment removal from [%s] queue, since ZK Node still exists!", new Object[]{segmentHolder.getAction()});
            this.timedOutSegments.add(segmentHolder.getSegment());
            this.executeCallbacks(segmentHolder, false);
        } else {
            this.actionCompleted(segmentHolder);
        }
    }

    @Override
    public boolean cancelOperation(DataSegment segment) {
        return false;
    }

    private void executeCallbacks(SegmentHolder holder, boolean success) {
        for (LoadPeonCallback callback : holder.getCallbacks()) {
            this.callBackExecutor.submit(() -> callback.execute(success));
        }
    }

    private class SegmentChangeProcessor
    implements Runnable {
        private final SegmentHolder segmentHolder;

        private SegmentChangeProcessor(SegmentHolder segmentHolder) {
            this.segmentHolder = segmentHolder;
        }

        @Override
        public void run() {
            try {
                String path = ZKPaths.makePath((String)CuratorLoadQueuePeon.this.basePath, (String)this.segmentHolder.getSegmentIdentifier());
                byte[] payload = CuratorLoadQueuePeon.this.jsonMapper.writeValueAsBytes((Object)this.segmentHolder.getChangeRequest());
                ((ACLBackgroundPathAndBytesable)CuratorLoadQueuePeon.this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath(path, payload);
                log.debug("ZKNode created for server to [%s] %s [%s]", new Object[]{CuratorLoadQueuePeon.this.basePath, this.segmentHolder.getAction(), this.segmentHolder.getSegmentIdentifier()});
                ScheduledFuture<?> nodeDeletedCheck = this.scheduleNodeDeletedCheck(path);
                Stat stat = (Stat)((BackgroundPathable)CuratorLoadQueuePeon.this.curator.checkExists().usingWatcher(watchedEvent -> {
                    switch (watchedEvent.getType()) {
                        case NodeDeleted: {
                            nodeDeletedCheck.cancel(true);
                            CuratorLoadQueuePeon.this.onZkNodeDeleted(this.segmentHolder, watchedEvent.getPath());
                            break;
                        }
                    }
                })).forPath(path);
                if (stat == null) {
                    byte[] noopPayload = CuratorLoadQueuePeon.this.jsonMapper.writeValueAsBytes((Object)new SegmentChangeRequestNoop());
                    ((ACLBackgroundPathAndBytesable)CuratorLoadQueuePeon.this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath(path, noopPayload);
                    CuratorLoadQueuePeon.this.onZkNodeDeleted(this.segmentHolder, path);
                }
            }
            catch (KeeperException.NodeExistsException ne) {
                log.warn((Throwable)ne, "ZK node already exists because segment change request hasn't yet been processed", new Object[0]);
                CuratorLoadQueuePeon.this.failAssign(this.segmentHolder, true, null);
            }
            catch (Exception e) {
                CuratorLoadQueuePeon.this.failAssign(this.segmentHolder, false, e);
            }
        }

        @Nonnull
        private ScheduledFuture<?> scheduleNodeDeletedCheck(String path) {
            return CuratorLoadQueuePeon.this.processingExecutor.schedule(() -> {
                try {
                    if (CuratorLoadQueuePeon.this.curator.checkExists().forPath(path) != null) {
                        CuratorLoadQueuePeon.this.failAssign(this.segmentHolder, true, (Exception)new ISE("%s operation timed out and [%s] was never removed! These segments may still get processed.", new Object[]{this.segmentHolder.getAction(), path}));
                    } else {
                        log.debug("Path [%s] has been removed.", new Object[]{path});
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Exception caught and ignored when checking whether zk node was deleted", new Object[0]);
                    CuratorLoadQueuePeon.this.failAssign(this.segmentHolder, false, e);
                }
            }, CuratorLoadQueuePeon.this.config.getLoadTimeoutDelay().getMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

