/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Provider;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.loading.CuratorLoadQueuePeon;
import org.apache.druid.server.coordinator.loading.HttpLoadQueuePeon;
import org.apache.druid.server.coordinator.loading.LoadQueuePeon;
import org.apache.druid.server.initialization.ZkPathsConfig;

public class LoadQueueTaskMaster {
    private static final Logger log = new Logger(LoadQueueTaskMaster.class);
    private final Provider<CuratorFramework> curatorFrameworkProvider;
    private final ObjectMapper jsonMapper;
    private final ScheduledExecutorService peonExec;
    private final ExecutorService callbackExec;
    private final DruidCoordinatorConfig config;
    private final HttpClient httpClient;
    private final ZkPathsConfig zkPaths;
    private final boolean httpLoading;
    @GuardedBy(value="this")
    private final AtomicBoolean isLeader = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, LoadQueuePeon> loadManagementPeons = new ConcurrentHashMap();

    public LoadQueueTaskMaster(Provider<CuratorFramework> curatorFrameworkProvider, ObjectMapper jsonMapper, ScheduledExecutorService peonExec, ExecutorService callbackExec, DruidCoordinatorConfig config, HttpClient httpClient, ZkPathsConfig zkPaths) {
        this.curatorFrameworkProvider = curatorFrameworkProvider;
        this.jsonMapper = jsonMapper;
        this.peonExec = peonExec;
        this.callbackExec = callbackExec;
        this.config = config;
        this.httpClient = httpClient;
        this.zkPaths = zkPaths;
        this.httpLoading = "http".equalsIgnoreCase(config.getLoadQueuePeonType());
    }

    private LoadQueuePeon createPeon(ImmutableDruidServer server) {
        if (this.httpLoading) {
            return new HttpLoadQueuePeon(server.getURL(), this.jsonMapper, this.httpClient, this.config, this.peonExec, this.callbackExec);
        }
        return new CuratorLoadQueuePeon((CuratorFramework)this.curatorFrameworkProvider.get(), ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)server.getName()), this.jsonMapper, this.peonExec, this.callbackExec, this.config);
    }

    public Map<String, LoadQueuePeon> getAllPeons() {
        return this.loadManagementPeons;
    }

    public LoadQueuePeon getPeonForServer(ImmutableDruidServer server) {
        return this.loadManagementPeons.get(server.getName());
    }

    public synchronized void resetPeonsForNewServers(List<ImmutableDruidServer> currentServers) {
        if (!this.isLeader.get()) {
            return;
        }
        HashSet oldServers = Sets.newHashSet((Iterable)this.loadManagementPeons.keySet());
        for (ImmutableDruidServer server : currentServers) {
            this.loadManagementPeons.computeIfAbsent(server.getName(), serverName -> {
                LoadQueuePeon loadQueuePeon = this.createPeon(server);
                loadQueuePeon.start();
                log.debug("Created LoadQueuePeon for server[%s].", new Object[]{server.getName()});
                return loadQueuePeon;
            });
        }
        for (ImmutableDruidServer server : currentServers) {
            oldServers.remove(server.getName());
        }
        for (String name : oldServers) {
            log.debug("Removing LoadQueuePeon for disappeared server[%s].", new Object[]{name});
            LoadQueuePeon peon = this.loadManagementPeons.remove(name);
            peon.stop();
        }
    }

    public synchronized void onLeaderStart() {
        this.isLeader.set(true);
    }

    public synchronized void onLeaderStop() {
        this.isLeader.set(false);
        this.loadManagementPeons.values().forEach(LoadQueuePeon::stop);
        this.loadManagementPeons.clear();
    }

    public boolean isHttpLoading() {
        return this.httpLoading;
    }
}

