/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.loading.LoadPeonCallback;
import org.apache.druid.server.coordinator.loading.SegmentAction;
import org.apache.druid.timeline.DataSegment;

public class SegmentHolder
implements Comparable<SegmentHolder> {
    private static final Comparator<SegmentHolder> COMPARE_ACTION_THEN_INTERVAL = Ordering.explicit((Object)((Object)SegmentAction.DROP), (Object[])new SegmentAction[]{SegmentAction.LOAD, SegmentAction.REPLICATE, SegmentAction.MOVE_TO}).onResultOf(SegmentHolder::getAction).compound((Comparator)DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST.onResultOf(SegmentHolder::getSegment));
    private final DataSegment segment;
    private final DataSegmentChangeRequest changeRequest;
    private final SegmentAction action;
    private final List<LoadPeonCallback> callbacks = new ArrayList<LoadPeonCallback>();
    private final AtomicLong firstRequestMillis = new AtomicLong(0L);
    private int runsInQueue = 0;

    public SegmentHolder(DataSegment segment, SegmentAction action, @Nullable LoadPeonCallback callback) {
        this.segment = segment;
        this.action = action;
        DataSegmentChangeRequest dataSegmentChangeRequest = this.changeRequest = action == SegmentAction.DROP ? new SegmentChangeRequestDrop(segment) : new SegmentChangeRequestLoad(segment);
        if (callback != null) {
            this.callbacks.add(callback);
        }
    }

    public DataSegment getSegment() {
        return this.segment;
    }

    public SegmentAction getAction() {
        return this.action;
    }

    public boolean isLoad() {
        return this.action != SegmentAction.DROP;
    }

    public DataSegmentChangeRequest getChangeRequest() {
        return this.changeRequest;
    }

    public String getSegmentIdentifier() {
        return this.segment.getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(@Nullable LoadPeonCallback callback) {
        if (callback != null) {
            List<LoadPeonCallback> list = this.callbacks;
            synchronized (list) {
                this.callbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoadPeonCallback> getCallbacks() {
        List<LoadPeonCallback> list = this.callbacks;
        synchronized (list) {
            return ImmutableList.copyOf(this.callbacks);
        }
    }

    public void markRequestSentToServer() {
        this.firstRequestMillis.compareAndSet(0L, System.currentTimeMillis());
    }

    public boolean isRequestSentToServer() {
        return this.firstRequestMillis.get() > 0L;
    }

    public long getFirstRequestMillis() {
        return this.firstRequestMillis.get();
    }

    public int incrementAndGetRunsInQueue() {
        return ++this.runsInQueue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentHolder that = (SegmentHolder)o;
        return this.getSegment().equals((Object)that.getSegment()) && this.getAction() == that.getAction();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getSegment(), this.getAction()});
    }

    @Override
    public int compareTo(SegmentHolder that) {
        return Objects.compare(this, that, COMPARE_ACTION_THEN_INTERVAL);
    }

    public String toString() {
        return (Object)((Object)this.action) + "{segment=" + this.segment.getId() + ", runsInQueue=" + this.runsInQueue + '}';
    }
}

