/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;

public class SegmentLoadingConfig {
    private static final Logger log = new Logger(SegmentLoadingConfig.class);
    private final int maxSegmentsInLoadQueue;
    private final int replicationThrottleLimit;
    private final int maxLifetimeInLoadQueue;
    private final int balancerComputeThreads;
    private final boolean useRoundRobinSegmentAssignment;

    public static SegmentLoadingConfig create(CoordinatorDynamicConfig dynamicConfig, int numUsedSegments) {
        if (dynamicConfig.isSmartSegmentLoading()) {
            int throttlePercentage = 5;
            int replicationThrottleLimit = Math.max(100, numUsedSegments * 5 / 100);
            int numBalancerThreads = CoordinatorDynamicConfig.getDefaultBalancerComputeThreads();
            log.info("Smart segment loading is enabled. Calculated replicationThrottleLimit[%,d] (%d%% of used segments[%,d]) and numBalancerThreads[%d].", new Object[]{replicationThrottleLimit, 5, numUsedSegments, numBalancerThreads});
            return new SegmentLoadingConfig(0, replicationThrottleLimit, 60, true, numBalancerThreads);
        }
        return new SegmentLoadingConfig(dynamicConfig.getMaxSegmentsInNodeLoadingQueue(), dynamicConfig.getReplicationThrottleLimit(), dynamicConfig.getReplicantLifetime(), dynamicConfig.isUseRoundRobinSegmentAssignment(), dynamicConfig.getBalancerComputeThreads());
    }

    private SegmentLoadingConfig(int maxSegmentsInLoadQueue, int replicationThrottleLimit, int maxLifetimeInLoadQueue, boolean useRoundRobinSegmentAssignment, int balancerComputeThreads) {
        this.maxSegmentsInLoadQueue = maxSegmentsInLoadQueue;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.maxLifetimeInLoadQueue = maxLifetimeInLoadQueue;
        this.useRoundRobinSegmentAssignment = useRoundRobinSegmentAssignment;
        this.balancerComputeThreads = balancerComputeThreads;
    }

    public int getMaxSegmentsInLoadQueue() {
        return this.maxSegmentsInLoadQueue;
    }

    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    public boolean isUseRoundRobinSegmentAssignment() {
        return this.useRoundRobinSegmentAssignment;
    }

    public int getMaxLifetimeInLoadQueue() {
        return this.maxLifetimeInLoadQueue;
    }

    public int getBalancerComputeThreads() {
        return this.balancerComputeThreads;
    }
}

