/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.druid.timeline.DataSegment;

@Path(value="/druid/coordinator/v1")
public class CoordinatorResource {
    private final DruidCoordinator coordinator;

    @Inject
    public CoordinatorResource(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @GET
    @Path(value="/leader")
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Response getLeader() {
        return Response.ok((Object)this.coordinator.getCurrentLeader()).build();
    }

    @GET
    @Path(value="/isLeader")
    @Produces(value={"application/json"})
    public Response isLeader() {
        boolean leading = this.coordinator.isLeader();
        ImmutableMap response = ImmutableMap.of((Object)"leader", (Object)leading);
        if (leading) {
            return Response.ok((Object)response).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)response).build();
    }

    @GET
    @Path(value="/loadstatus")
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Response getLoadStatus(@QueryParam(value="simple") String simple, @QueryParam(value="full") String full, @QueryParam(value="computeUsingClusterView") @Nullable String computeUsingClusterView) {
        if (simple != null) {
            return Response.ok(this.coordinator.getDatasourceToUnavailableSegmentCount()).build();
        }
        if (full != null) {
            return Response.ok(this.coordinator.getTierToDatasourceToUnderReplicatedCount(computeUsingClusterView != null)).build();
        }
        return Response.ok(this.coordinator.getDatasourceToLoadStatus()).build();
    }

    @GET
    @Path(value="/loadqueue")
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Response getLoadQueue(@QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple != null) {
            return Response.ok((Object)Maps.transformValues(this.coordinator.getLoadManagementPeons(), input -> {
                long loadSize = input.getSizeOfSegmentsToLoad();
                long dropSize = input.getSegmentsToDrop().stream().mapToLong(DataSegment::getSize).sum();
                return new ImmutableMap.Builder().put((Object)"segmentsToLoad", (Object)input.getSegmentsToLoad().size()).put((Object)"segmentsToDrop", (Object)input.getSegmentsToDrop().size()).put((Object)"segmentsToLoadSize", (Object)loadSize).put((Object)"segmentsToDropSize", (Object)dropSize).build();
            })).build();
        }
        if (full != null) {
            return Response.ok(this.coordinator.getLoadManagementPeons()).build();
        }
        return Response.ok((Object)Maps.transformValues(this.coordinator.getLoadManagementPeons(), peon -> ImmutableMap.builder().put((Object)"segmentsToLoad", (Object)Collections2.transform(peon.getSegmentsToLoad(), DataSegment::getId)).put((Object)"segmentsToDrop", (Object)Collections2.transform(peon.getSegmentsToDrop(), DataSegment::getId)).build())).build();
    }
}

