/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.base.Strings;
import org.apache.druid.java.util.common.StringUtils;

public class Access {
    public static final String DEFAULT_ERROR_MESSAGE = "Unauthorized";
    public static final Access OK = new Access(true);
    public static final Access DENIED = new Access(false);
    private final boolean allowed;
    private final String message;

    public Access(boolean allowed) {
        this(allowed, "");
    }

    public Access(boolean allowed, String message) {
        this.allowed = allowed;
        this.message = message;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public String getMessage() {
        return this.message;
    }

    public String toMessage() {
        if (!Strings.isNullOrEmpty((String)this.message)) {
            return this.toString();
        }
        if (this.allowed) {
            return "Authorized";
        }
        return DEFAULT_ERROR_MESSAGE;
    }

    public String toString() {
        return StringUtils.format((String)"Allowed:%s, Message:%s", (Object[])new Object[]{this.allowed, this.message});
    }
}

