/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.servlet.GuiceFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.Servlet;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.BaseJettyTest;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.easymock.EasyMock;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DruidLeaderClientTest
extends BaseJettyTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private DiscoveryDruidNode discoveryDruidNode;
    private HttpClient httpClient;

    @Override
    protected Injector setupInjector() {
        final DruidNode node = new DruidNode("test", "localhost", false, null, null, true, false);
        this.discoveryDruidNode = new DiscoveryDruidNode(node, NodeRole.PEON, (Map)ImmutableMap.of());
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)node);
                binder.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"port")).toInstance((Object)node.getPlaintextPort());
                binder.bind(JettyServerInitializer.class).to(TestJettyServerInitializer.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, SimpleResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
            }
        }));
        this.httpClient = ((BaseJettyTest.ClientHolder)injector.getInstance(BaseJettyTest.ClientHolder.class)).getClient();
        return injector;
    }

    @Test
    public void testSimple() throws Exception {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.discoveryDruidNode));
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.PEON)).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider});
        DruidLeaderClient druidLeaderClient = new DruidLeaderClient(this.httpClient, druidNodeDiscoveryProvider, NodeRole.PEON, "/simple/leader");
        druidLeaderClient.start();
        Request request = druidLeaderClient.makeRequest(HttpMethod.POST, "/simple/direct");
        request.setContent("hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"hello", (Object)druidLeaderClient.go(request).getContent());
    }

    @Test
    public void testNoLeaderFound() throws Exception {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of());
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.PEON)).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider});
        DruidLeaderClient druidLeaderClient = new DruidLeaderClient(this.httpClient, druidNodeDiscoveryProvider, NodeRole.PEON, "/simple/leader");
        druidLeaderClient.start();
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("A leader node could not be found for [PEON] service. Check logs of service [PEON] to confirm it is healthy.");
        druidLeaderClient.makeRequest(HttpMethod.POST, "/simple/direct");
    }

    @Test
    public void testRedirection() throws Exception {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.discoveryDruidNode));
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.PEON)).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider});
        DruidLeaderClient druidLeaderClient = new DruidLeaderClient(this.httpClient, druidNodeDiscoveryProvider, NodeRole.PEON, "/simple/leader");
        druidLeaderClient.start();
        Request request = druidLeaderClient.makeRequest(HttpMethod.POST, "/simple/redirect");
        request.setContent("hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"hello", (Object)druidLeaderClient.go(request).getContent());
    }

    @Test
    public void testServerFailureAndRedirect() throws Exception {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        DiscoveryDruidNode dummyNode = new DiscoveryDruidNode(new DruidNode("test", "dummyhost", false, Integer.valueOf(64231), null, true, false), NodeRole.PEON, (Map)ImmutableMap.of());
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)dummyNode));
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.discoveryDruidNode));
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.PEON)).andReturn((Object)druidNodeDiscovery).anyTimes();
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider});
        DruidLeaderClient druidLeaderClient = new DruidLeaderClient(this.httpClient, druidNodeDiscoveryProvider, NodeRole.PEON, "/simple/leader");
        druidLeaderClient.start();
        Request request = druidLeaderClient.makeRequest(HttpMethod.POST, "/simple/redirect");
        request.setContent("hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"hello", (Object)druidLeaderClient.go(request).getContent());
    }

    @Test
    public void test503ResponseFromServerAndCacheRefresh() throws Exception {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.discoveryDruidNode)).times(2);
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.PEON)).andReturn((Object)druidNodeDiscovery).anyTimes();
        ListenableFutureTask task = (ListenableFutureTask)EasyMock.createMock(ListenableFutureTask.class);
        EasyMock.expect((Object)task.get()).andReturn((Object)new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE), Charset.defaultCharset()));
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider, task});
        HttpClient spyHttpClient = (HttpClient)Mockito.spy((Object)this.httpClient);
        ((HttpClient)Mockito.doReturn((Object)task).doCallRealMethod().when((Object)spyHttpClient)).go((Request)ArgumentMatchers.any(), (HttpResponseHandler)ArgumentMatchers.any());
        DruidLeaderClient druidLeaderClient = new DruidLeaderClient(spyHttpClient, druidNodeDiscoveryProvider, NodeRole.PEON, "/simple/leader");
        druidLeaderClient.start();
        Request request = druidLeaderClient.makeRequest(HttpMethod.POST, "/simple/direct");
        request.setContent("hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"hello", (Object)druidLeaderClient.go(request).getContent());
        EasyMock.verify((Object[])new Object[]{druidNodeDiscovery});
    }

    @Test
    public void testFindCurrentLeader() {
        DruidNodeDiscovery druidNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)druidNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.discoveryDruidNode));
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForNodeRole(NodeRole.PEON)).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscovery, druidNodeDiscoveryProvider});
        DruidLeaderClient druidLeaderClient = new DruidLeaderClient(this.httpClient, druidNodeDiscoveryProvider, NodeRole.PEON, "/simple/leader");
        druidLeaderClient.start();
        Assert.assertEquals((Object)"http://localhost:1234/", (Object)druidLeaderClient.findCurrentLeader());
    }

    @Path(value="/simple")
    public static class SimpleResource {
        private final int port;

        @Inject
        public SimpleResource(@Named(value="port") int port) {
            this.port = port;
        }

        @POST
        @Path(value="/direct")
        @Produces(value={"application/json"})
        public Response direct(String input) {
            if ("hello".equals(input)) {
                return Response.ok((Object)"hello").build();
            }
            return Response.serverError().build();
        }

        @POST
        @Path(value="/redirect")
        @Produces(value={"application/json"})
        public Response redirecting() throws Exception {
            return Response.temporaryRedirect((URI)new URI(StringUtils.format((String)"http://localhost:%s/simple/direct", (Object[])new Object[]{this.port}))).build();
        }

        @GET
        @Path(value="/leader")
        @Produces(value={"application/json"})
        public Response leader() {
            return Response.ok((Object)"http://localhost:1234/").build();
        }
    }

    static class TestJettyServerInitializer
    implements JettyServerInitializer {
        TestJettyServerInitializer() {
        }

        public void initialize(Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            root.addFilter(GuiceFilter.class, "/*", null);
            HandlerList handlerList = new HandlerList();
            handlerList.setHandlers(new Handler[]{root});
            server.setHandler((Handler)handlerList);
        }
    }
}

