/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexer.TaskIdentifier;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.DerbyMetadataStorageActionHandler;
import org.apache.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SQLMetadataStorageActionHandler;
import org.apache.druid.metadata.TaskLookup;
import org.apache.druid.metadata.TestDerbyConnector;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SQLMetadataStorageActionHandlerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final Random RANDOM = new Random(1L);
    private SQLMetadataStorageActionHandler<Map<String, Object>, Map<String, Object>, Map<String, String>, Map<String, Object>> handler;
    private final String entryTable = "entries";

    @Before
    public void setUp() {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        String entryType = "entry";
        String lockTable = "locks";
        connector.prepareTaskEntryTable("entries");
        connector.createLockTable("locks", "entry");
        this.handler = new DerbyMetadataStorageActionHandler((SQLMetadataConnector)connector, JSON_MAPPER, (MetadataStorageActionHandlerTypes)new MetadataStorageActionHandlerTypes<Map<String, Object>, Map<String, Object>, Map<String, String>, Map<String, Object>>(){

            public TypeReference<Map<String, Object>> getEntryType() {
                return new TypeReference<Map<String, Object>>(){};
            }

            public TypeReference<Map<String, Object>> getStatusType() {
                return new TypeReference<Map<String, Object>>(){};
            }

            public TypeReference<Map<String, Object>> getLockType() {
                return new TypeReference<Map<String, Object>>(){};
            }
        }, "entry", "entries", null, "locks");
    }

    @Test
    public void testEntryAndStatus() {
        ImmutableMap entry = ImmutableMap.of((Object)"numericId", (Object)1234);
        ImmutableMap status1 = ImmutableMap.of((Object)"count", (Object)42);
        ImmutableMap status2 = ImmutableMap.of((Object)"count", (Object)42, (Object)"temp", (Object)1);
        String entryId = "1234";
        this.handler.insert("1234", DateTimes.of((String)"2014-01-02T00:00:00.123"), "testDataSource", (Object)entry, true, null, "type", "group");
        Assert.assertEquals((Object)Optional.of((Object)entry), (Object)this.handler.getEntry("1234"));
        Assert.assertEquals((Object)Optional.absent(), (Object)this.handler.getEntry("non_exist_entry"));
        Assert.assertEquals((Object)Optional.absent(), (Object)this.handler.getStatus("1234"));
        Assert.assertEquals((Object)Optional.absent(), (Object)this.handler.getStatus("non_exist_entry"));
        Assert.assertTrue((boolean)this.handler.setStatus("1234", true, (Object)status1));
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)entry, (Object)status1)), this.handler.getTaskInfos((TaskLookup)TaskLookup.ActiveTaskLookup.getInstance(), null).stream().map(taskInfo -> Pair.of((Object)taskInfo.getTask(), (Object)taskInfo.getStatus())).collect(Collectors.toList()));
        Assert.assertTrue((boolean)this.handler.setStatus("1234", true, (Object)status2));
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)entry, (Object)status2)), this.handler.getTaskInfos((TaskLookup)TaskLookup.ActiveTaskLookup.getInstance(), null).stream().map(taskInfo -> Pair.of((Object)taskInfo.getTask(), (Object)taskInfo.getStatus())).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.handler.getTaskInfos((TaskLookup)TaskLookup.CompleteTaskLookup.withTasksCreatedPriorTo(null, (DateTime)DateTimes.of((String)"2014-01-01")), null));
        Assert.assertTrue((boolean)this.handler.setStatus("1234", false, (Object)status1));
        Assert.assertEquals((Object)Optional.of((Object)status1), (Object)this.handler.getStatus("1234"));
        Assert.assertFalse((boolean)this.handler.setStatus("1234", false, (Object)status2));
        Assert.assertEquals((Object)Optional.of((Object)status1), (Object)this.handler.getStatus("1234"));
        Assert.assertEquals((Object)Optional.of((Object)entry), (Object)this.handler.getEntry("1234"));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.handler.getTaskInfos((TaskLookup)TaskLookup.CompleteTaskLookup.withTasksCreatedPriorTo(null, (DateTime)DateTimes.of((String)"2014-01-03")), null));
        Assert.assertEquals((Object)ImmutableList.of((Object)status1), this.handler.getTaskInfos((TaskLookup)TaskLookup.CompleteTaskLookup.withTasksCreatedPriorTo(null, (DateTime)DateTimes.of((String)"2014-01-01")), null).stream().map(TaskInfo::getStatus).collect(Collectors.toList()));
    }

    @Test
    public void testGetRecentStatuses() {
        for (int i = 1; i < 11; ++i) {
            String entryId = "abcd_" + i;
            ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)i);
            ImmutableMap status = ImmutableMap.of((Object)"count", (Object)(i * 10));
            this.handler.insert(entryId, DateTimes.of((String)StringUtils.format((String)"2014-01-%02d", (Object[])new Object[]{i})), "test", (Object)entry, false, (Object)status, "type", "group");
        }
        List statuses = this.handler.getTaskInfos((TaskLookup)TaskLookup.CompleteTaskLookup.withTasksCreatedPriorTo((Integer)7, (DateTime)DateTimes.of((String)"2014-01-01")), null);
        Assert.assertEquals((long)7L, (long)statuses.size());
        int i = 10;
        for (ImmutableMap status : statuses) {
            Assert.assertEquals((Object)ImmutableMap.of((Object)"count", (Object)(i-- * 10)), (Object)status.getStatus());
        }
    }

    @Test
    public void testGetRecentStatuses2() {
        for (int i = 1; i < 6; ++i) {
            String entryId = "abcd_" + i;
            ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)i);
            ImmutableMap status = ImmutableMap.of((Object)"count", (Object)(i * 10));
            this.handler.insert(entryId, DateTimes.of((String)StringUtils.format((String)"2014-01-%02d", (Object[])new Object[]{i})), "test", (Object)entry, false, (Object)status, "type", "group");
        }
        List statuses = this.handler.getTaskInfos((TaskLookup)TaskLookup.CompleteTaskLookup.withTasksCreatedPriorTo((Integer)10, (DateTime)DateTimes.of((String)"2014-01-01")), null);
        Assert.assertEquals((long)5L, (long)statuses.size());
        int i = 5;
        for (ImmutableMap status : statuses) {
            Assert.assertEquals((Object)ImmutableMap.of((Object)"count", (Object)(i-- * 10)), (Object)status.getStatus());
        }
    }

    @Test(timeout=60000L)
    public void testDuplicateInsertThrowsEntryExistsException() {
        String entryId = "abcd";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("abcd", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status, "type", "group");
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> this.lambda$testDuplicateInsertThrowsEntryExistsException$2((Map)entry, (Map)status));
        Assert.assertEquals((Object)"invalidInput", (Object)exception.getErrorCode());
        Assert.assertEquals((Object)"Task [abcd] already exists", (Object)exception.getMessage());
    }

    @Test
    public void testAddLogThrowsUnsupportedException() {
        Exception exception = (Exception)Assert.assertThrows(DruidException.class, () -> this.handler.addLog("abcd", (Object)ImmutableMap.of((Object)"logentry", (Object)"created")));
        Assert.assertEquals((Object)"Task actions are not logged anymore.", (Object)exception.getMessage());
    }

    @Test
    public void testGetLogsThrowsUnsupportedException() {
        Exception exception = (Exception)Assert.assertThrows(DruidException.class, () -> this.handler.getLogs("abcd"));
        Assert.assertEquals((Object)"Task actions are not logged anymore.", (Object)exception.getMessage());
    }

    @Test
    public void testLocks() {
        String entryId = "ABC123";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("ABC123", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status, "type", "group");
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("non_exist_entry"));
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("ABC123"));
        ImmutableMap lock1 = ImmutableMap.of((Object)"lock", (Object)1);
        ImmutableMap lock2 = ImmutableMap.of((Object)"lock", (Object)2);
        Assert.assertTrue((boolean)this.handler.addLock("ABC123", (Object)lock1));
        Assert.assertTrue((boolean)this.handler.addLock("ABC123", (Object)lock2));
        Map locks = this.handler.getLocks("ABC123");
        Assert.assertEquals((long)2L, (long)locks.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)lock1, (Object)lock2), new HashSet(locks.values()));
        long lockId = (Long)locks.keySet().iterator().next();
        this.handler.removeLock(lockId);
        locks.remove(lockId);
        Map updated = this.handler.getLocks("ABC123");
        Assert.assertEquals(new HashSet(locks.values()), new HashSet(updated.values()));
        Assert.assertEquals(updated.keySet(), locks.keySet());
    }

    @Test
    public void testReplaceLock() {
        String entryId = "ABC123";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("ABC123", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status, "type", "group");
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("non_exist_entry"));
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("ABC123"));
        ImmutableMap lock1 = ImmutableMap.of((Object)"lock", (Object)1);
        ImmutableMap lock2 = ImmutableMap.of((Object)"lock", (Object)2);
        Assert.assertTrue((boolean)this.handler.addLock("ABC123", (Object)lock1));
        Long lockId1 = this.handler.getLockId("ABC123", (Object)lock1);
        Assert.assertNotNull((Object)lockId1);
        Assert.assertTrue((boolean)this.handler.replaceLock("ABC123", lockId1.longValue(), (Object)lock2));
    }

    @Test
    public void testGetLockId() {
        String entryId = "ABC123";
        ImmutableMap entry = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("ABC123", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status, "type", "group");
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("non_exist_entry"));
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)this.handler.getLocks("ABC123"));
        ImmutableMap lock1 = ImmutableMap.of((Object)"lock", (Object)1);
        ImmutableMap lock2 = ImmutableMap.of((Object)"lock", (Object)2);
        Assert.assertTrue((boolean)this.handler.addLock("ABC123", (Object)lock1));
        Assert.assertNotNull((Object)this.handler.getLockId("ABC123", (Object)lock1));
        Assert.assertNull((Object)this.handler.getLockId("ABC123", (Object)lock2));
    }

    @Test
    public void testRemoveTasksOlderThan() {
        String entryId1 = "1234";
        ImmutableMap entry1 = ImmutableMap.of((Object)"numericId", (Object)1234);
        ImmutableMap status1 = ImmutableMap.of((Object)"count", (Object)42, (Object)"temp", (Object)1);
        this.handler.insert("1234", DateTimes.of((String)"2014-01-01T00:00:00.123"), "testDataSource", (Object)entry1, false, (Object)status1, "type", "group");
        String entryId2 = "ABC123";
        ImmutableMap entry2 = ImmutableMap.of((Object)"a", (Object)1);
        ImmutableMap status2 = ImmutableMap.of((Object)"count", (Object)42);
        this.handler.insert("ABC123", DateTimes.of((String)"2014-01-01T00:00:00.123"), "test", (Object)entry2, true, (Object)status2, "type", "group");
        String entryId3 = "DEF5678";
        ImmutableMap entry3 = ImmutableMap.of((Object)"numericId", (Object)5678);
        ImmutableMap status3 = ImmutableMap.of((Object)"count", (Object)21, (Object)"temp", (Object)2);
        this.handler.insert("DEF5678", DateTimes.of((String)"2014-01-02T12:00:00.123"), "testDataSource", (Object)entry3, false, (Object)status3, "type", "group");
        Assert.assertEquals((Object)Optional.of((Object)entry1), (Object)this.handler.getEntry("1234"));
        Assert.assertEquals((Object)Optional.of((Object)entry2), (Object)this.handler.getEntry("ABC123"));
        Assert.assertEquals((Object)Optional.of((Object)entry3), (Object)this.handler.getEntry("DEF5678"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"ABC123"), this.handler.getTaskInfos((TaskLookup)TaskLookup.ActiveTaskLookup.getInstance(), null).stream().map(taskInfo -> taskInfo.getId()).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableList.of((Object)"DEF5678", (Object)"1234"), this.handler.getTaskInfos((TaskLookup)TaskLookup.CompleteTaskLookup.withTasksCreatedPriorTo(null, (DateTime)DateTimes.of((String)"2014-01-01")), null).stream().map(taskInfo -> taskInfo.getId()).collect(Collectors.toList()));
        this.handler.removeTasksOlderThan(DateTimes.of((String)"2014-01-02").getMillis());
        Assert.assertEquals((Object)ImmutableList.of((Object)"ABC123"), this.handler.getTaskInfos((TaskLookup)TaskLookup.ActiveTaskLookup.getInstance(), null).stream().map(taskInfo -> taskInfo.getId()).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableList.of((Object)"DEF5678"), this.handler.getTaskInfos((TaskLookup)TaskLookup.CompleteTaskLookup.withTasksCreatedPriorTo(null, (DateTime)DateTimes.of((String)"2014-01-01")), null).stream().map(taskInfo -> taskInfo.getId()).collect(Collectors.toList()));
    }

    @Test
    public void testMigration() {
        int numActiveTasks = 123;
        for (int i = 0; i < numActiveTasks; ++i) {
            this.insertTaskInfo(this.createRandomTaskInfo(TaskState.RUNNING), false);
        }
        int numCompletedTasks = 101;
        for (int i = 0; i < numCompletedTasks; ++i) {
            this.insertTaskInfo(this.createRandomTaskInfo(TaskState.SUCCESS), false);
        }
        Assert.assertEquals((long)(numActiveTasks + numCompletedTasks), (long)this.getUnmigratedTaskCount().intValue());
        this.handler.populateTaskTypeAndGroupId();
        Assert.assertEquals((long)0L, (long)this.getUnmigratedTaskCount().intValue());
    }

    @Test
    public void testGetTaskStatusPlusListInternal() {
        TaskInfo<Map<String, Object>, Map<String, Object>> activeUnaltered = this.createRandomTaskInfo(TaskState.RUNNING);
        this.insertTaskInfo(activeUnaltered, false);
        TaskInfo<Map<String, Object>, Map<String, Object>> completedUnaltered = this.createRandomTaskInfo(TaskState.SUCCESS);
        this.insertTaskInfo(completedUnaltered, false);
        TaskInfo<Map<String, Object>, Map<String, Object>> activeAltered = this.createRandomTaskInfo(TaskState.RUNNING);
        this.insertTaskInfo(activeAltered, true);
        TaskInfo<Map<String, Object>, Map<String, Object>> completedAltered = this.createRandomTaskInfo(TaskState.SUCCESS);
        this.insertTaskInfo(completedAltered, true);
        HashMap<TaskLookup.TaskLookupType, Object> taskLookups = new HashMap<TaskLookup.TaskLookupType, Object>();
        taskLookups.put(TaskLookup.TaskLookupType.ACTIVE, TaskLookup.ActiveTaskLookup.getInstance());
        taskLookups.put(TaskLookup.TaskLookupType.COMPLETE, TaskLookup.CompleteTaskLookup.of(null, (Duration)Duration.millis((long)86400000L)));
        List taskMetadataInfos = this.handler.getTaskStatusList(taskLookups, null, true);
        Assert.assertEquals((long)4L, (long)taskMetadataInfos.size());
        this.verifyTaskInfoToMetadataInfo(completedUnaltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(completedAltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(activeUnaltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(activeAltered, taskMetadataInfos, false);
        taskMetadataInfos = this.handler.getTaskStatusList(taskLookups, null, false);
        Assert.assertEquals((long)4L, (long)taskMetadataInfos.size());
        this.verifyTaskInfoToMetadataInfo(completedUnaltered, taskMetadataInfos, true);
        this.verifyTaskInfoToMetadataInfo(completedAltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(activeUnaltered, taskMetadataInfos, true);
        this.verifyTaskInfoToMetadataInfo(activeAltered, taskMetadataInfos, false);
        this.handler.populateTaskTypeAndGroupId();
        taskMetadataInfos = this.handler.getTaskStatusList(taskLookups, null, true);
        Assert.assertEquals((long)4L, (long)taskMetadataInfos.size());
        this.verifyTaskInfoToMetadataInfo(completedUnaltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(completedAltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(activeUnaltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(activeAltered, taskMetadataInfos, false);
        taskMetadataInfos = this.handler.getTaskStatusList(taskLookups, null, false);
        Assert.assertEquals((long)4L, (long)taskMetadataInfos.size());
        this.verifyTaskInfoToMetadataInfo(completedUnaltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(completedAltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(activeUnaltered, taskMetadataInfos, false);
        this.verifyTaskInfoToMetadataInfo(activeAltered, taskMetadataInfos, false);
    }

    private Integer getUnmigratedTaskCount() {
        return (Integer)this.handler.getConnector().retryWithHandle(handle -> {
            String sql = StringUtils.format((String)"SELECT COUNT(*) FROM %s WHERE type is NULL or group_id is NULL", (Object[])new Object[]{"entries"});
            ResultSet resultSet = handle.getConnection().createStatement().executeQuery(sql);
            resultSet.next();
            return resultSet.getInt(1);
        });
    }

    private TaskInfo<Map<String, Object>, Map<String, Object>> createRandomTaskInfo(TaskState taskState) {
        String id = UUID.randomUUID().toString();
        DateTime createdTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        String datasource = UUID.randomUUID().toString();
        String type = UUID.randomUUID().toString();
        String groupId = UUID.randomUUID().toString();
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("id", id);
        payload.put("type", type);
        payload.put("groupId", groupId);
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("id", id);
        status.put("status", taskState);
        status.put("duration", RANDOM.nextLong());
        status.put("location", TaskLocation.create((String)UUID.randomUUID().toString(), (int)8080, (int)995));
        status.put("errorMsg", UUID.randomUUID().toString());
        return new TaskInfo(id, createdTime, status, datasource, payload);
    }

    private void insertTaskInfo(TaskInfo<Map<String, Object>, Map<String, Object>> taskInfo, boolean altered) {
        try {
            this.handler.insert(taskInfo.getId(), taskInfo.getCreatedTime(), taskInfo.getDataSource(), taskInfo.getTask(), TaskState.RUNNING.equals(((Map)taskInfo.getStatus()).get("status")), taskInfo.getStatus(), altered ? ((Map)taskInfo.getTask()).get("type").toString() : null, altered ? ((Map)taskInfo.getTask()).get("groupId").toString() : null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyTaskInfoToMetadataInfo(TaskInfo<Map<String, Object>, Map<String, Object>> taskInfo, List<TaskInfo<TaskIdentifier, Map<String, Object>>> taskMetadataInfos, boolean nullNewColumns) {
        Iterator<TaskInfo<TaskIdentifier, Map<String, Object>>> iterator = taskMetadataInfos.iterator();
        if (iterator.hasNext()) {
            TaskInfo<TaskIdentifier, Map<String, Object>> taskMetadataInfo = iterator.next();
            if (taskMetadataInfo.getId().equals(taskInfo.getId())) {
                this.verifyTaskInfoToMetadataInfo(taskInfo, taskMetadataInfo, nullNewColumns);
            }
            return;
        }
        Assert.fail();
    }

    private void verifyTaskInfoToMetadataInfo(TaskInfo<Map<String, Object>, Map<String, Object>> taskInfo, TaskInfo<TaskIdentifier, Map<String, Object>> taskMetadataInfo, boolean nullNewColumns) {
        Assert.assertEquals((Object)taskInfo.getId(), (Object)taskMetadataInfo.getId());
        Assert.assertEquals((Object)taskInfo.getCreatedTime(), (Object)taskMetadataInfo.getCreatedTime());
        Assert.assertEquals((Object)taskInfo.getDataSource(), (Object)taskMetadataInfo.getDataSource());
        this.verifyTaskStatus((Map)taskInfo.getStatus(), (Map)taskMetadataInfo.getStatus());
        Map task = (Map)taskInfo.getTask();
        TaskIdentifier taskIdentifier = (TaskIdentifier)taskMetadataInfo.getTask();
        Assert.assertEquals(task.get("id"), (Object)taskIdentifier.getId());
        if (nullNewColumns) {
            Assert.assertNull((Object)taskIdentifier.getGroupId());
            Assert.assertNull((Object)taskIdentifier.getType());
        } else {
            Assert.assertEquals(task.get("groupId"), (Object)taskIdentifier.getGroupId());
            Assert.assertEquals(task.get("type"), (Object)taskIdentifier.getType());
        }
    }

    private void verifyTaskStatus(Map<String, Object> expected, Map<String, Object> actual) {
        Assert.assertEquals((Object)expected.get("id"), (Object)actual.get("id"));
        Assert.assertEquals((Object)expected.get("duration"), (Object)actual.get("duration"));
        Assert.assertEquals((Object)expected.get("errorMsg"), (Object)actual.get("errorMsg"));
        Assert.assertEquals((Object)expected.get("status").toString(), (Object)actual.get("status"));
        Assert.assertEquals((Object)expected.get("location"), (Object)JSON_MAPPER.convertValue(actual.get("location"), TaskLocation.class));
    }

    private /* synthetic */ void lambda$testDuplicateInsertThrowsEntryExistsException$2(Map entry, Map status) throws Throwable {
        this.handler.insert("abcd", DateTimes.of((String)"2014-01-01"), "test", (Object)entry, true, (Object)status, "type", "group");
    }
}

