/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.junit.Assert;
import org.junit.Test;

public class ServiceLocationsTest {
    @Test
    public void test_forLocation() {
        ServiceLocation location = new ServiceLocation("h", -1, 2, "");
        ServiceLocations locations = ServiceLocations.forLocation((ServiceLocation)location);
        Assert.assertEquals((Object)ImmutableSet.of((Object)location), (Object)locations.getLocations());
        Assert.assertFalse((boolean)locations.isClosed());
    }

    @Test
    public void test_forLocations() {
        ServiceLocation location1 = new ServiceLocation("h", -1, 2, "");
        ServiceLocation location2 = new ServiceLocation("h", -1, 2, "");
        ServiceLocations locations = ServiceLocations.forLocations((Set)ImmutableSet.of((Object)location1, (Object)location2));
        Assert.assertEquals((Object)ImmutableSet.of((Object)location1, (Object)location2), (Object)locations.getLocations());
        Assert.assertFalse((boolean)locations.isClosed());
    }

    @Test
    public void test_closed() {
        ServiceLocations locations = ServiceLocations.closed();
        Assert.assertEquals(Collections.emptySet(), (Object)locations.getLocations());
        Assert.assertTrue((boolean)locations.isClosed());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(ServiceLocations.class).usingGetClass().verify();
    }
}

