/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.AlertBuilder;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class StorageLocationTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testStorageLocationFreePercent() {
        StorageLocation locationPlain = this.fakeLocation(100000L, 5000L, 10000L, null);
        Assert.assertTrue((boolean)locationPlain.canHandle(this.newSegmentId("2012/2013").toString(), 9000L));
        Assert.assertFalse((boolean)locationPlain.canHandle(this.newSegmentId("2012/2013").toString(), 11000L));
        StorageLocation locationFree = this.fakeLocation(100000L, 25000L, 10000L, 10.0);
        Assert.assertTrue((boolean)locationFree.canHandle(this.newSegmentId("2012/2013").toString(), 9000L));
        Assert.assertFalse((boolean)locationFree.canHandle(this.newSegmentId("2012/2013").toString(), 11000L));
        StorageLocation locationFull = this.fakeLocation(100000L, 15000L, 10000L, 10.0);
        Assert.assertTrue((boolean)locationFull.canHandle(this.newSegmentId("2012/2013").toString(), 4000L));
        Assert.assertFalse((boolean)locationFull.canHandle(this.newSegmentId("2012/2013").toString(), 6000L));
    }

    @Test
    public void testStorageLocationRealFileSystem() throws IOException {
        File file = this.temporaryFolder.newFolder();
        StorageLocation location = new StorageLocation(file, 10000L, Double.valueOf(100.0));
        Assert.assertFalse((boolean)location.canHandle(this.newSegmentId("2012/2013").toString(), 5000L));
        location = new StorageLocation(file, 10000L, Double.valueOf(1.0E-4));
        Assert.assertTrue((boolean)location.canHandle(this.newSegmentId("2012/2013").toString(), 1L));
    }

    private StorageLocation fakeLocation(long total, long free, long max, Double percent) {
        File file = (File)EasyMock.mock(File.class);
        EasyMock.expect((Object)file.getTotalSpace()).andReturn((Object)total).anyTimes();
        EasyMock.expect((Object)file.getFreeSpace()).andReturn((Object)free).anyTimes();
        EasyMock.replay((Object[])new Object[]{file});
        return new StorageLocation(file, max, percent);
    }

    @Test
    public void testStorageLocation() throws IOException {
        File dir = this.temporaryFolder.newFolder();
        long expectedAvail = 1000L;
        StorageLocation loc = new StorageLocation(dir, expectedAvail, null);
        this.verifyLoc(expectedAvail, loc);
        DataSegment secondSegment = this.makeSegment("2012-01-02/2012-01-03", 23L);
        loc.reserve("test1", this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail -= 10L, loc);
        loc.reserve("test1", this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail, loc);
        loc.reserve("test2", secondSegment);
        this.verifyLoc(expectedAvail -= 23L, loc);
        loc.removeSegmentDir(new File(dir, "test1"), this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail += 10L, loc);
        loc.removeSegmentDir(new File(dir, "test1"), this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail, loc);
        loc.removeSegmentDir(new File(dir, "test2"), secondSegment);
        this.verifyLoc(expectedAvail += 23L, loc);
    }

    @Test
    public void testMaybeReserve() throws IOException {
        ServiceEmitter emitter = (ServiceEmitter)Mockito.mock(ServiceEmitter.class);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ServiceEventBuilder.class);
        EmittingLogger.registerEmitter((ServiceEmitter)emitter);
        File dir = this.temporaryFolder.newFolder();
        long expectedAvail = 1000L;
        StorageLocation loc = new StorageLocation(dir, expectedAvail, null);
        this.verifyLoc(expectedAvail, loc);
        DataSegment secondSegment = this.makeSegment("2012-01-02/2012-01-03", 23L);
        loc.maybeReserve("test1", this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail -= 10L, loc);
        loc.maybeReserve("test1", this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail, loc);
        loc.maybeReserve("test2", secondSegment);
        this.verifyLoc(expectedAvail -= 23L, loc);
        loc.removeSegmentDir(new File(dir, "test1"), this.makeSegment("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail += 10L, loc);
        loc.maybeReserve("test3", this.makeSegment("2012-01-01/2012-01-02", 999L));
        this.verifyLoc(expectedAvail -= 999L, loc);
        ((ServiceEmitter)Mockito.verify((Object)emitter)).emit((ServiceEventBuilder)argumentCaptor.capture());
        AlertBuilder alertBuilder = (AlertBuilder)argumentCaptor.getValue();
        String description = alertBuilder.build(ImmutableMap.of()).getDescription();
        Assert.assertNotNull((Object)description);
        Assert.assertTrue((String)description, (boolean)description.contains("Please increase druid.segmentCache.locations maxSize param"));
    }

    @Test
    public void testReserveAndRelease() throws IOException {
        File dir = this.temporaryFolder.newFolder();
        StorageLocation loc = new StorageLocation(dir, 1000L, null);
        File reserved = loc.reserve("testPath", "segmentId", 100L);
        Assert.assertNotNull((Object)reserved);
        Assert.assertEquals((Object)new File(dir, "testPath"), (Object)reserved.getAbsoluteFile());
        Assert.assertEquals((long)900L, (long)loc.availableSizeBytes());
        Assert.assertTrue((boolean)loc.contains("testPath"));
        Assert.assertNull((Object)loc.reserve("testPath", "segmentId", 100L));
        Assert.assertTrue((boolean)loc.release("testPath", 100L));
        Assert.assertEquals((long)1000L, (long)loc.availableSizeBytes());
        Assert.assertFalse((boolean)loc.contains("testPath"));
        Assert.assertFalse((boolean)loc.release("testPath", 100L));
    }

    private void verifyLoc(long maxSize, StorageLocation loc) {
        Assert.assertEquals((long)maxSize, (long)loc.availableSizeBytes());
        int i = 0;
        while ((long)i <= maxSize) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)loc.canHandle(this.newSegmentId("2013/2014").toString(), (long)i));
            ++i;
        }
    }

    private DataSegment makeSegment(String intervalString, long size) {
        return new DataSegment("test", Intervals.of((String)intervalString), "1", (Map)ImmutableMap.of(), Collections.singletonList("d"), Collections.singletonList("m"), null, null, size);
    }

    private SegmentId newSegmentId(String intervalString) {
        return SegmentId.of((String)"test", (Interval)Intervals.of((String)intervalString), (String)"1", (int)0);
    }
}

