/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.metadata.AbstractSegmentMetadataCache;
import org.apache.druid.segment.metadata.AvailableSegmentMetadata;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCache;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCacheTestBase;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.segment.metadata.SegmentMetadataCacheConfig;
import org.apache.druid.segment.metadata.SegmentSchemaBackFillQueue;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.metadata.SegmentSchemaTestUtils;
import org.apache.druid.segment.metadata.TestCoordinatorServerView;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.loading.SegmentReplicaCount;
import org.apache.druid.server.coordinator.loading.SegmentReplicationStatus;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CoordinatorSegmentMetadataCacheTest
extends CoordinatorSegmentMetadataCacheTestBase {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();
    private static final SegmentMetadataCacheConfig SEGMENT_CACHE_CONFIG_DEFAULT = SegmentMetadataCacheConfig.create((String)"PT1S");
    private CoordinatorSegmentMetadataCache runningSchema;
    private CountDownLatch buildTableLatch = new CountDownLatch(1);
    private CountDownLatch markDataSourceLatch = new CountDownLatch(1);
    private SqlSegmentsMetadataManager sqlSegmentsMetadataManager;
    private Supplier<SegmentsMetadataManagerConfig> segmentsMetadataManagerConfigSupplier;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.sqlSegmentsMetadataManager = (SqlSegmentsMetadataManager)Mockito.mock(SqlSegmentsMetadataManager.class);
        Mockito.when((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).thenReturn(Collections.emptyList());
        SegmentsMetadataManagerConfig metadataManagerConfig = (SegmentsMetadataManagerConfig)Mockito.mock(SegmentsMetadataManagerConfig.class);
        Mockito.when((Object)metadataManagerConfig.getPollDuration()).thenReturn((Object)Period.millis((int)1000));
        this.segmentsMetadataManagerConfigSupplier = Suppliers.ofInstance((Object)metadataManagerConfig);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.runningSchema != null) {
            this.runningSchema.onLeaderStop();
        }
    }

    public CoordinatorSegmentMetadataCache buildSchemaMarkAndTableLatch() throws InterruptedException {
        return this.buildSchemaMarkAndTableLatch(SEGMENT_CACHE_CONFIG_DEFAULT);
    }

    public CoordinatorSegmentMetadataCache buildSchemaMarkAndTableLatch(SegmentMetadataCacheConfig config) throws InterruptedException {
        Preconditions.checkState((this.runningSchema == null ? 1 : 0) != 0);
        this.runningSchema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, config, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public RowSignature buildDataSourceRowSignature(String dataSource) {
                RowSignature table = super.buildDataSourceRowSignature(dataSource);
                CoordinatorSegmentMetadataCacheTest.this.buildTableLatch.countDown();
                return table;
            }

            public void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
                CoordinatorSegmentMetadataCacheTest.this.markDataSourceLatch.countDown();
            }
        };
        this.runningSchema.onLeaderStart();
        this.runningSchema.awaitInitialization();
        return this.runningSchema;
    }

    @Test
    public void testGetTableMap() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2", (Object)"some_datasource"), (Object)schema.getDatasourceNames());
        Set tableNames = schema.getDatasourceNames();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2", (Object)"some_datasource"), (Object)tableNames);
    }

    @Test
    public void testGetTableMapFoo() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        this.verifyFooDSSchema(schema, 6);
    }

    @Test
    public void testGetTableMapFoo2() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        this.verifyFoo2DSSchema(schema);
    }

    @Test
    public void testGetTableMapSomeTable() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch(new SegmentMetadataCacheConfig(){

            public AbstractSegmentMetadataCache.ColumnTypeMergePolicy getMetadataColumnTypeMergePolicy() {
                return new AbstractSegmentMetadataCache.FirstTypeMergePolicy();
            }
        });
        DataSourceInformation fooDs = schema.getDatasource("some_datasource");
        RowSignature fooRowSignature = fooDs.getRowSignature();
        List columnNames = fooRowSignature.getColumnNames();
        Assert.assertEquals((long)9L, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"numbery", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"numberyArrays", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(2)).get());
        Assert.assertEquals((Object)"stringy", columnNames.get(3));
        Assert.assertEquals((Object)ColumnType.STRING, fooRowSignature.getColumnType((String)columnNames.get(3)).get());
        Assert.assertEquals((Object)"array", columnNames.get(4));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(4)).get());
        Assert.assertEquals((Object)"nested", columnNames.get(5));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"json"), fooRowSignature.getColumnType((String)columnNames.get(5)).get());
        Assert.assertEquals((Object)"cnt", columnNames.get(6));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(6)).get());
        Assert.assertEquals((Object)"m1", columnNames.get(7));
        Assert.assertEquals((Object)ColumnType.DOUBLE, fooRowSignature.getColumnType((String)columnNames.get(7)).get());
        Assert.assertEquals((Object)"unique_dim1", columnNames.get(8));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"hyperUnique"), fooRowSignature.getColumnType((String)columnNames.get(8)).get());
    }

    @Test
    public void testGetTableMapSomeTableLeastRestrictiveTypeMerge() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        DataSourceInformation fooDs = schema.getDatasource("some_datasource");
        RowSignature fooRowSignature = fooDs.getRowSignature();
        List columnNames = fooRowSignature.getColumnNames();
        Assert.assertEquals((long)9L, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"numbery", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.DOUBLE, fooRowSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"numberyArrays", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(2)).get());
        Assert.assertEquals((Object)"stringy", columnNames.get(3));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(3)).get());
        Assert.assertEquals((Object)"array", columnNames.get(4));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, fooRowSignature.getColumnType((String)columnNames.get(4)).get());
        Assert.assertEquals((Object)"nested", columnNames.get(5));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"json"), fooRowSignature.getColumnType((String)columnNames.get(5)).get());
        Assert.assertEquals((Object)"cnt", columnNames.get(6));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(6)).get());
        Assert.assertEquals((Object)"m1", columnNames.get(7));
        Assert.assertEquals((Object)ColumnType.DOUBLE, fooRowSignature.getColumnType((String)columnNames.get(7)).get());
        Assert.assertEquals((Object)"unique_dim1", columnNames.get(8));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"hyperUnique"), fooRowSignature.getColumnType((String)columnNames.get(8)).get());
    }

    @Test
    public void testNullDatasource() throws IOException, InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        schema.refreshSegments(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()));
        Assert.assertEquals((long)5L, (long)schema.getSegmentMetadataSnapshot().size());
    }

    @Test
    public void testAllDatasourcesRebuiltOnDatasourceRemoval() throws IOException, InterruptedException {
        final CountDownLatch addSegmentLatch = new CountDownLatch(7);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                addSegmentLatch.countDown();
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
            }

            public void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
                CoordinatorSegmentMetadataCacheTest.this.markDataSourceLatch.countDown();
            }

            @VisibleForTesting
            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
            }
        };
        schema.onLeaderStart();
        schema.awaitInitialization();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSourceInformation fooDs = schema.getDatasource("foo");
        Assert.assertTrue((boolean)fooDs.getRowSignature().getColumnNames().stream().noneMatch("dim3"::equals));
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        DataSegment newSegment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2002/P1Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        File tmpDir = this.temporaryFolder.newFolder();
        ImmutableList rows = ImmutableList.of((Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-01", (Object)"m1", (Object)"1.0", (Object)"dim1", (Object)"", (Object)"dim3", (Object)"c1")), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-02", (Object)"m1", (Object)"2.0", (Object)"dim1", (Object)"10.1", (Object)"dim3", (Object)"c2")), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-03", (Object)"m1", (Object)"3.0", (Object)"dim1", (Object)"2", (Object)"dim3", (Object)"c3")));
        QueryableIndex index = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HyperUniquesAggregatorFactory("unique_dim1", "dim1")}).withRollup(false).build()).rows((Iterable)rows).buildMMappedIndex();
        this.walker.add(newSegment, index);
        this.serverView.addSegment(newSegment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Set dataSources = segments.stream().map(DataSegment::getDataSource).collect(Collectors.toSet());
        dataSources.remove("foo2");
        LinkedHashSet<String> dataSourcesToRefresh = new LinkedHashSet<String>();
        dataSourcesToRefresh.add("foo2");
        dataSourcesToRefresh.addAll(dataSources);
        segments = schema.getSegmentMetadataSnapshot().values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), dataSourcesToRefresh);
        Assert.assertEquals((long)6L, (long)schema.getSegmentMetadataSnapshot().size());
        fooDs = schema.getDatasource("foo");
        Assert.assertTrue((boolean)fooDs.getRowSignature().getColumnNames().stream().anyMatch("dim3"::equals));
    }

    @Test
    public void testNullAvailableSegmentMetadata() throws IOException, InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        schema.refreshSegments(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()));
        Assert.assertEquals((long)5L, (long)schema.getSegmentMetadataSnapshot().size());
    }

    @Test
    public void testAvailableSegmentMetadataIsRealtime() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentsMetadata = schema.getSegmentMetadataSnapshot();
        List segments = segmentsMetadata.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        DataSegment existingSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)existingSegment);
        AvailableSegmentMetadata metadata = (AvailableSegmentMetadata)segmentsMetadata.get(existingSegment.getId());
        Assert.assertEquals((long)1L, (long)metadata.isRealtime());
        DruidServer historicalServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.HISTORICAL)).findAny().orElse(null);
        Assert.assertNotNull((Object)historicalServer);
        DruidServerMetadata historicalServerMetadata = historicalServer.getMetadata();
        schema.addSegment(historicalServerMetadata, existingSegment);
        segmentsMetadata = schema.getSegmentMetadataSnapshot();
        DataSegment currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)currentSegment);
        AvailableSegmentMetadata currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((long)0L, (long)currentMetadata.isRealtime());
        DruidServer realtimeServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.INDEXER_EXECUTOR)).findAny().orElse(null);
        Assert.assertNotNull((Object)realtimeServer);
        schema.removeServerSegment(realtimeServer.getMetadata(), existingSegment);
        segmentsMetadata = schema.getSegmentMetadataSnapshot();
        currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo3")).findFirst().orElse(null);
        Assert.assertNotNull((Object)currentSegment);
        currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((long)0L, (long)currentMetadata.isRealtime());
    }

    @Test
    public void testSegmentAddedCallbackAddNewHistoricalSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(this.newSegment(datasource, 1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddExistingSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        SqlSegmentsMetadataManager sqlSegmentsMetadataManager = (SqlSegmentsMetadataManager)Mockito.mock(SqlSegmentsMetadataManager.class);
        Mockito.when((Object)sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).thenReturn(Collections.emptyList());
        SegmentsMetadataManagerConfig metadataManagerConfig = (SegmentsMetadataManagerConfig)Mockito.mock(SegmentsMetadataManagerConfig.class);
        Mockito.when((Object)metadataManagerConfig.getPollDuration()).thenReturn((Object)Period.millis((int)1000));
        Supplier segmentsMetadataManagerConfigSupplier = Suppliers.ofInstance((Object)metadataManagerConfig);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, sqlSegmentsMetadataManager, segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = this.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.INDEXER_EXECUTOR);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertEquals((long)2L, (long)metadata2.getNumReplicas());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddNewRealtimeSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        SqlSegmentsMetadataManager sqlSegmentsMetadataManager = (SqlSegmentsMetadataManager)Mockito.mock(SqlSegmentsMetadataManager.class);
        Mockito.when((Object)sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).thenReturn(Collections.emptyList());
        SegmentsMetadataManagerConfig metadataManagerConfig = (SegmentsMetadataManagerConfig)Mockito.mock(SegmentsMetadataManagerConfig.class);
        Mockito.when((Object)metadataManagerConfig.getPollDuration()).thenReturn((Object)Period.millis((int)1000));
        Supplier segmentsMetadataManagerConfigSupplier = Suppliers.ofInstance((Object)metadataManagerConfig);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, sqlSegmentsMetadataManager, segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(this.newSegment(datasource, 1), ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)1L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(metadata2.getSegment().getId()));
        Assert.assertTrue((boolean)schema.getMutableSegments().contains(metadata2.getSegment().getId()));
    }

    @Test
    public void testSegmentAddedCallbackAddNewBroadcastSegment() throws InterruptedException {
        final String datasource = "newSegmentAddTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        SqlSegmentsMetadataManager sqlSegmentsMetadataManager = (SqlSegmentsMetadataManager)Mockito.mock(SqlSegmentsMetadataManager.class);
        Mockito.when((Object)sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).thenReturn(Collections.emptyList());
        SegmentsMetadataManagerConfig metadataManagerConfig = (SegmentsMetadataManagerConfig)Mockito.mock(SegmentsMetadataManagerConfig.class);
        Mockito.when((Object)metadataManagerConfig.getPollDuration()).thenReturn((Object)Period.millis((int)1000));
        Supplier segmentsMetadataManagerConfigSupplier = Suppliers.ofInstance((Object)metadataManagerConfig);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, sqlSegmentsMetadataManager, segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(this.newSegment(datasource, 1), ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)6L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)0L, (long)metadatas.size());
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
    }

    @Test
    public void testSegmentRemovedCallbackEmptyDataSourceAfterRemove() throws InterruptedException, IOException {
        final String datasource = "segmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = this.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh((Set)Sets.newHashSet((Object[])new SegmentId[]{segment.getId()}), (Set)Sets.newHashSet((Object[])new String[]{datasource}));
        this.serverView.removeSegment(segment, ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)removeSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)6L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)0L, (long)metadatas.size());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(segment.getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(segment.getId()));
        Assert.assertFalse((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
        Assert.assertFalse((boolean)schema.getDatasourceNames().contains(datasource));
    }

    @Test
    public void testSegmentRemovedCallbackNonEmptyDataSourceAfterRemove() throws InterruptedException, IOException {
        final String datasource = "segmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        final CountDownLatch removeSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeSegmentLatch.countDown();
                }
            }
        };
        ImmutableList segments = ImmutableList.of((Object)this.newSegment(datasource, 1), (Object)this.newSegment(datasource, 2));
        this.serverView.addSegment((DataSegment)segments.get(0), ServerType.INDEXER_EXECUTOR);
        this.serverView.addSegment((DataSegment)segments.get(1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), (Set)Sets.newHashSet((Object[])new String[]{datasource}));
        this.serverView.removeSegment((DataSegment)segments.get(0), ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)removeSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(((DataSegment)segments.get(0)).getId()));
        Assert.assertFalse((boolean)schema.getMutableSegments().contains(((DataSegment)segments.get(0)).getId()));
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
        Assert.assertTrue((boolean)schema.getDatasourceNames().contains(datasource));
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveUnknownSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        this.serverView.addSegment(this.newSegment(datasource, 1), ServerType.BROKER);
        this.serverView.removeSegment(this.newSegment(datasource, 1), ServerType.HISTORICAL);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)6L, (long)schema.getTotalSegments());
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveBrokerSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = this.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        this.serverView.addSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        this.serverView.removeSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        Assert.assertTrue((boolean)schema.getDataSourcesNeedingRebuild().contains(datasource));
    }

    @Test
    public void testServerSegmentRemovedCallbackRemoveHistoricalSegment() throws InterruptedException {
        final String datasource = "serverSegmentRemoveTest";
        final CountDownLatch addSegmentLatch = new CountDownLatch(1);
        final CountDownLatch removeServerSegmentLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeServerSegment(DruidServerMetadata server, DataSegment segment) {
                super.removeServerSegment(server, segment);
                if (datasource.equals(segment.getDataSource())) {
                    removeServerSegmentLatch.countDown();
                }
            }
        };
        DataSegment segment = this.newSegment(datasource, 1);
        this.serverView.addSegment(segment, ServerType.HISTORICAL);
        this.serverView.addSegment(segment, ServerType.BROKER);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        this.serverView.removeSegment(segment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)removeServerSegmentLatch.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)7L, (long)schema.getTotalSegments());
        List metadatas = schema.getSegmentMetadataSnapshot().values().stream().filter(metadata -> datasource.equals(metadata.getSegment().getDataSource())).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)metadatas.size());
        AvailableSegmentMetadata metadata2 = (AvailableSegmentMetadata)metadatas.get(0);
        Assert.assertEquals((long)0L, (long)metadata2.isRealtime());
        Assert.assertEquals((long)0L, (long)metadata2.getNumRows());
        Assert.assertEquals((long)0L, (long)metadata2.getNumReplicas());
    }

    @Test
    public void testRunSegmentMetadataQueryWithContext() throws Exception {
        String brokerInternalQueryConfigJson = "{\"context\": { \"priority\": 5} }";
        TestHelper.makeJsonMapper();
        InternalQueryConfig internalQueryConfig = (InternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(brokerInternalQueryConfigJson, InternalQueryConfig.class)), InternalQueryConfig.class);
        QueryLifecycleFactory factoryMock = (QueryLifecycleFactory)EasyMock.createMock(QueryLifecycleFactory.class);
        QueryLifecycle lifecycleMock = (QueryLifecycle)EasyMock.createMock(QueryLifecycle.class);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(factoryMock, (CoordinatorServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), internalQueryConfig, (ServiceEmitter)new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier);
        ImmutableMap queryContext = ImmutableMap.of((Object)"priority", (Object)5, (Object)"enableParallelMerge", (Object)false);
        DataSegment segment = this.newSegment("test", 0);
        ImmutableList segmentIterable = ImmutableList.of((Object)segment.getId());
        SegmentMetadataQuery expectedMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(segment.getDataSource()), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentIterable.stream().map(SegmentId::toDescriptor).collect(Collectors.toList())), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), (Map)queryContext, EnumSet.of(SegmentMetadataQuery.AnalysisType.AGGREGATORS), Boolean.valueOf(false), null, null);
        EasyMock.expect((Object)factoryMock.factorize()).andReturn((Object)lifecycleMock).once();
        EasyMock.expect((Object)lifecycleMock.runSimple((Query)expectedMetadataQuery, AllowAllAuthenticator.ALLOW_ALL_RESULT, Access.OK)).andReturn((Object)QueryResponse.withEmptyContext((Sequence)Sequences.empty()));
        EasyMock.replay((Object[])new Object[]{factoryMock, lifecycleMock});
        schema.runSegmentMetadataQuery((Iterable)segmentIterable);
        EasyMock.verify((Object[])new Object[]{factoryMock, lifecycleMock});
    }

    @Test
    public void testSegmentMetadataColumnType() {
        LinkedHashMap<String, ColumnAnalysis> columns = new LinkedHashMap<String, ColumnAnalysis>();
        columns.put("a", new ColumnAnalysis(ColumnType.STRING, ColumnType.STRING.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null));
        columns.put("count", new ColumnAnalysis(ColumnType.LONG, ColumnType.LONG.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null));
        columns.put("b", new ColumnAnalysis(ColumnType.DOUBLE, ColumnType.DOUBLE.asTypeString(), false, true, 1234L, Integer.valueOf(26), null, null, null));
        RowSignature signature = AbstractSegmentMetadataCache.analysisToRowSignature((SegmentAnalysis)new SegmentAnalysis("id", (List)ImmutableList.of((Object)Intervals.utc((long)1L, (long)2L)), columns, 1234L, 100L, null, null, null, null));
        Assert.assertEquals((Object)RowSignature.builder().add("a", ColumnType.STRING).add("count", ColumnType.LONG).add("b", ColumnType.DOUBLE).build(), (Object)signature);
    }

    @Test
    public void testSegmentMetadataFallbackType() {
        RowSignature signature = AbstractSegmentMetadataCache.analysisToRowSignature((SegmentAnalysis)new SegmentAnalysis("id", (List)ImmutableList.of((Object)Intervals.utc((long)1L, (long)2L)), new LinkedHashMap(ImmutableMap.of((Object)"a", (Object)new ColumnAnalysis(null, ColumnType.STRING.asTypeString(), false, true, 1234L, Integer.valueOf(26), (Comparable)((Object)"a"), (Comparable)((Object)"z"), null), (Object)"count", (Object)new ColumnAnalysis(null, ColumnType.LONG.asTypeString(), false, true, 1234L, null, null, null, null), (Object)"distinct", (Object)new ColumnAnalysis(null, "hyperUnique", false, true, 1234L, null, null, null, null))), 1234L, 100L, null, null, null, null));
        Assert.assertEquals((Object)RowSignature.builder().add("a", ColumnType.STRING).add("count", ColumnType.LONG).add("distinct", ColumnType.ofComplex((String)"hyperUnique")).build(), (Object)signature);
    }

    @Test
    public void testStaleDatasourceRefresh() throws IOException, InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        HashSet segments = new HashSet();
        HashSet<String> datasources = new HashSet<String>();
        datasources.add("wat");
        Assert.assertNull((Object)schema.getDatasource("wat"));
        schema.refresh(segments, datasources);
        Assert.assertNull((Object)schema.getDatasource("wat"));
    }

    @Test
    public void testRefreshShouldEmitMetrics() throws InterruptedException, IOException {
        final String dataSource = "xyz";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        StubServiceEmitter emitter = new StubServiceEmitter("broker", "host");
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)emitter, this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (dataSource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
            }
        };
        ImmutableList segments = ImmutableList.of((Object)this.newSegment(dataSource, 1), (Object)this.newSegment(dataSource, 2));
        this.serverView.addSegment((DataSegment)segments.get(0), ServerType.HISTORICAL);
        this.serverView.addSegment((DataSegment)segments.get(1), ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), (Set)Sets.newHashSet((Object[])new String[]{dataSource}));
        emitter.verifyEmitted("metadatacache/refresh/time", (Map)ImmutableMap.of((Object)"dataSource", (Object)dataSource), 1);
        emitter.verifyEmitted("metadatacache/refresh/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)dataSource), 1);
    }

    @Test
    public void testMergeOrCreateRowSignatureDeltaSchemaNoPreviousSignature() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        EmittingLogger.registerEmitter((ServiceEmitter)new StubServiceEmitter("coordinator", "dummy"));
        Assert.assertFalse((boolean)schema.mergeOrCreateRowSignature(this.segment1.getId(), null, new SegmentSchemas.SegmentSchema("foo", this.segment1.getId().toString(), true, Integer.valueOf(20), (List)ImmutableList.of((Object)"dim1"), Collections.emptyList(), (Map)ImmutableMap.of((Object)"dim1", (Object)ColumnType.STRING))).isPresent());
    }

    @Test
    public void testMergeOrCreateRowSignatureDeltaSchema() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo", this.segment1.getId());
        Optional mergedSignature = schema.mergeOrCreateRowSignature(this.segment1.getId(), availableSegmentMetadata.getRowSignature(), new SegmentSchemas.SegmentSchema("foo", this.segment1.getId().toString(), true, Integer.valueOf(1000), (List)ImmutableList.of((Object)"dim2"), (List)ImmutableList.of((Object)"m1"), (Map)ImmutableMap.of((Object)"dim2", (Object)ColumnType.STRING, (Object)"m1", (Object)ColumnType.STRING)));
        Assert.assertTrue((boolean)mergedSignature.isPresent());
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("dim1", ColumnType.STRING);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("m1", ColumnType.STRING);
        rowSignatureBuilder.add("unique_dim1", ColumnType.ofComplex((String)"hyperUnique"));
        rowSignatureBuilder.add("dim2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), mergedSignature.get());
    }

    @Test
    public void testMergeOrCreateRowSignatureDeltaSchemaNewUpdateColumnOldNewColumn() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        EmittingLogger.registerEmitter((ServiceEmitter)new StubServiceEmitter("coordinator", "dummy"));
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo", this.segment1.getId());
        Optional mergedSignature = schema.mergeOrCreateRowSignature(this.segment1.getId(), availableSegmentMetadata.getRowSignature(), new SegmentSchemas.SegmentSchema("foo", this.segment1.getId().toString(), true, Integer.valueOf(1000), (List)ImmutableList.of((Object)"m1"), (List)ImmutableList.of((Object)"m2"), (Map)ImmutableMap.of((Object)"m1", (Object)ColumnType.LONG, (Object)"m2", (Object)ColumnType.STRING)));
        Assert.assertTrue((boolean)mergedSignature.isPresent());
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("dim1", ColumnType.STRING);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("m1", ColumnType.DOUBLE);
        rowSignatureBuilder.add("unique_dim1", ColumnType.ofComplex((String)"hyperUnique"));
        rowSignatureBuilder.add("m2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), mergedSignature.get());
    }

    @Test
    public void testMergeOrCreateRowSignatureAbsoluteSchema() throws InterruptedException {
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo", this.segment1.getId());
        Optional mergedSignature = schema.mergeOrCreateRowSignature(this.segment1.getId(), availableSegmentMetadata.getRowSignature(), new SegmentSchemas.SegmentSchema("foo", this.segment1.getId().toString(), false, Integer.valueOf(1000), (List)ImmutableList.of((Object)"__time", (Object)"cnt", (Object)"dim2"), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"__time", (Object)ColumnType.LONG, (Object)"dim2", (Object)ColumnType.STRING, (Object)"cnt", (Object)ColumnType.LONG)));
        Assert.assertTrue((boolean)mergedSignature.isPresent());
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("dim2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), mergedSignature.get());
    }

    @Test
    public void testRealtimeSchemaAnnouncement() throws InterruptedException, IOException {
        final CountDownLatch schemaAddedLatch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            void updateSchemaForRealtimeSegments(SegmentSchemas segmentSchemas) {
                super.updateSchemaForRealtimeSegments(segmentSchemas);
                schemaAddedLatch.countDown();
            }
        };
        schema.onLeaderStart();
        schema.awaitInitialization();
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo3", this.realtimeSegment1.getId());
        Assert.assertNull((Object)availableSegmentMetadata.getRowSignature());
        schema.refresh(this.walker.getSegments().stream().map(DataSegment::getId).collect(Collectors.toSet()), new HashSet());
        Assert.assertNull((Object)schema.getDatasource("foo3"));
        Assert.assertNotNull((Object)schema.getDatasource("foo"));
        Assert.assertNotNull((Object)schema.getDatasource("foo2"));
        Assert.assertNotNull((Object)schema.getDatasource("some_datasource"));
        this.serverView.addSegmentSchemas(new SegmentSchemas(Collections.singletonList(new SegmentSchemas.SegmentSchema("foo3", this.realtimeSegment1.getId().toString(), false, Integer.valueOf(1000), (List)ImmutableList.of((Object)"__time", (Object)"dim1", (Object)"cnt", (Object)"m1", (Object)"unique_dim1", (Object)"dim2"), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"__time", (Object)ColumnType.LONG, (Object)"dim1", (Object)ColumnType.STRING, (Object)"cnt", (Object)ColumnType.LONG, (Object)"m1", (Object)ColumnType.STRING, (Object)"unique_dim1", (Object)ColumnType.ofComplex((String)"hyperUnique"), (Object)"dim2", (Object)ColumnType.STRING)))));
        Assert.assertTrue((boolean)schemaAddedLatch.await(1L, TimeUnit.SECONDS));
        availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo3", this.realtimeSegment1.getId());
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("dim1", ColumnType.STRING);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("m1", ColumnType.STRING);
        rowSignatureBuilder.add("unique_dim1", ColumnType.ofComplex((String)"hyperUnique"));
        rowSignatureBuilder.add("dim2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), (Object)availableSegmentMetadata.getRowSignature());
    }

    @Test
    public void testRealtimeSchemaAnnouncementDataSourceSchemaUpdated() throws InterruptedException {
        final CountDownLatch refresh1Latch = new CountDownLatch(1);
        final CountDownLatch refresh2Latch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
                if (refresh1Latch.getCount() == 0L) {
                    refresh2Latch.countDown();
                } else {
                    refresh1Latch.countDown();
                }
            }
        };
        schema.onLeaderStart();
        schema.awaitInitialization();
        Assert.assertTrue((boolean)refresh1Latch.await(10L, TimeUnit.SECONDS));
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("foo3", this.realtimeSegment1.getId());
        Assert.assertNull((Object)availableSegmentMetadata.getRowSignature());
        Assert.assertNull((Object)schema.getDatasource("foo3"));
        Assert.assertNotNull((Object)schema.getDatasource("foo"));
        Assert.assertNotNull((Object)schema.getDatasource("foo2"));
        Assert.assertNotNull((Object)schema.getDatasource("some_datasource"));
        this.serverView.addSegmentSchemas(new SegmentSchemas(Collections.singletonList(new SegmentSchemas.SegmentSchema("foo3", this.realtimeSegment1.getId().toString(), false, Integer.valueOf(1000), (List)ImmutableList.of((Object)"__time", (Object)"dim1", (Object)"cnt", (Object)"m1", (Object)"unique_dim1", (Object)"dim2"), (List)ImmutableList.of(), (Map)ImmutableMap.of((Object)"__time", (Object)ColumnType.LONG, (Object)"dim1", (Object)ColumnType.STRING, (Object)"cnt", (Object)ColumnType.LONG, (Object)"m1", (Object)ColumnType.STRING, (Object)"unique_dim1", (Object)ColumnType.ofComplex((String)"hyperUnique"), (Object)"dim2", (Object)ColumnType.STRING)))));
        Assert.assertTrue((boolean)refresh2Latch.await(10L, TimeUnit.SECONDS));
        Assert.assertNotNull((Object)schema.getDatasource("foo3"));
        Assert.assertNotNull((Object)schema.getDatasource("foo"));
        Assert.assertNotNull((Object)schema.getDatasource("foo2"));
        Assert.assertNotNull((Object)schema.getDatasource("some_datasource"));
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        rowSignatureBuilder.add("__time", ColumnType.LONG);
        rowSignatureBuilder.add("dim1", ColumnType.STRING);
        rowSignatureBuilder.add("cnt", ColumnType.LONG);
        rowSignatureBuilder.add("m1", ColumnType.STRING);
        rowSignatureBuilder.add("unique_dim1", ColumnType.ofComplex((String)"hyperUnique"));
        rowSignatureBuilder.add("dim2", ColumnType.STRING);
        Assert.assertEquals((Object)rowSignatureBuilder.build(), (Object)schema.getDatasource("foo3").getRowSignature());
    }

    @Test
    public void testSchemaBackfilling() throws InterruptedException {
        CentralizedDatasourceSchemaConfig config = CentralizedDatasourceSchemaConfig.create();
        config.setEnabled(true);
        config.setBackFillEnabled(true);
        config.setBackFillPeriod(1L);
        this.backFillQueue = new SegmentSchemaBackFillQueue(this.segmentSchemaManager, ScheduledExecutors::fixed, this.segmentSchemaCache, this.fingerprintGenerator, (ServiceEmitter)new NoopServiceEmitter(), config);
        QueryableIndexCursorFactory index1CursorFactory = new QueryableIndexCursorFactory(this.index1);
        QueryableIndexCursorFactory index2CursorFactory = new QueryableIndexCursorFactory(this.index2);
        MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        TestDerbyConnector derbyConnector = this.derbyConnectorRule.getConnector();
        derbyConnector.createSegmentSchemasTable();
        derbyConnector.createSegmentTable();
        HashSet<DataSegment> segmentsToPersist = new HashSet<DataSegment>();
        segmentsToPersist.add(this.segment1);
        segmentsToPersist.add(this.segment2);
        segmentsToPersist.add(this.segment3);
        ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus> pluses = new ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus>();
        pluses.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(this.segment1.getId(), this.fingerprintGenerator.generateFingerprint(new SchemaPayload(index1CursorFactory.getRowSignature()), this.segment1.getDataSource(), 1), new SchemaPayloadPlus(new SchemaPayload(index1CursorFactory.getRowSignature()), Long.valueOf(this.index1.getNumRows()))));
        pluses.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(this.segment2.getId(), this.fingerprintGenerator.generateFingerprint(new SchemaPayload(index2CursorFactory.getRowSignature()), this.segment1.getDataSource(), 1), new SchemaPayloadPlus(new SchemaPayload(index2CursorFactory.getRowSignature()), Long.valueOf(this.index2.getNumRows()))));
        SegmentSchemaTestUtils segmentSchemaTestUtils = new SegmentSchemaTestUtils(this.derbyConnectorRule, derbyConnector, this.mapper);
        segmentSchemaTestUtils.insertUsedSegments(segmentsToPersist, Collections.emptyMap());
        this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable("foo", pluses, 1);
        ImmutableMap.Builder segmentMetadataMap = new ImmutableMap.Builder();
        ImmutableMap.Builder schemaPayloadMap = new ImmutableMap.Builder();
        derbyConnector.retryWithHandle(handle -> {
            handle.createQuery(StringUtils.format((String)"select s1.id, s1.dataSource, s1.schema_fingerprint, s1.num_rows, s2.payload from %1$s as s1 inner join %2$s as s2 on s1.schema_fingerprint = s2.fingerprint", (Object[])new Object[]{tablesConfig.getSegmentsTable(), tablesConfig.getSegmentSchemasTable()})).map((index, r, ctx) -> {
                try {
                    String segmentId = r.getString(1);
                    String dataSource = r.getString(2);
                    String schemaFingerprint = r.getString(3);
                    long numRows = r.getLong(4);
                    SchemaPayload schemaPayload = (SchemaPayload)this.mapper.readValue(r.getBytes(5), SchemaPayload.class);
                    schemaPayloadMap.put((Object)schemaFingerprint, (Object)schemaPayload);
                    segmentMetadataMap.put((Object)SegmentId.tryParse((String)dataSource, (String)segmentId), (Object)new SegmentMetadata(Long.valueOf(numRows), schemaFingerprint));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }).list();
            return null;
        });
        this.segmentSchemaCache.updateFinalizedSegmentSchema(new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentMetadataMap.build(), schemaPayloadMap.build()));
        this.segmentSchemaCache.setInitialized();
        this.serverView = new TestCoordinatorServerView(Collections.emptyList(), Collections.emptyList());
        final AtomicInteger refreshCount = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(2);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public Set<SegmentId> refreshSegmentsForDataSource(String dataSource, Set<SegmentId> segments) throws IOException {
                refreshCount.incrementAndGet();
                return super.refreshSegmentsForDataSource(dataSource, segments);
            }

            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
                latch.countDown();
            }
        };
        this.serverView.addSegment(this.segment1, ServerType.HISTORICAL);
        this.serverView.addSegment(this.segment2, ServerType.HISTORICAL);
        schema.onLeaderStart();
        schema.awaitInitialization();
        Assert.assertEquals((long)0L, (long)refreshCount.get());
        this.verifyFooDSSchema(schema, 6);
        this.serverView.addSegment(this.segment3, ServerType.HISTORICAL);
        latch.await();
        this.verifyFoo2DSSchema(schema);
        derbyConnector.retryWithHandle(handle -> {
            handle.createQuery(StringUtils.format((String)"select s2.payload, s1.num_rows from %1$s as s1 inner join %2$s as s2 on s1.schema_fingerprint = s2.fingerprint where s1.id = '%3$s'", (Object[])new Object[]{tablesConfig.getSegmentsTable(), tablesConfig.getSegmentSchemasTable(), this.segment3.getId().toString()})).map((index, r, ctx) -> {
                try {
                    SchemaPayload schemaPayload = (SchemaPayload)this.mapper.readValue(r.getBytes(1), SchemaPayload.class);
                    long numRows = r.getLong(2);
                    QueryableIndexCursorFactory cursorFa = new QueryableIndexCursorFactory(this.index2);
                    Assert.assertEquals((Object)cursorFa.getRowSignature(), (Object)schemaPayload.getRowSignature());
                    Assert.assertEquals((long)this.index2.getNumRows(), (long)numRows);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }).list();
            return null;
        });
    }

    @Test
    public void testSameSegmentAddedOnMultipleServer() throws InterruptedException, IOException {
        SegmentMetadataCacheConfig config = SegmentMetadataCacheConfig.create((String)"PT1S");
        config.setDisableSegmentMetadataQueries(true);
        CoordinatorSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch(config);
        QueryableIndexSegment queryableIndexSegment = new QueryableIndexSegment(this.index2, SegmentId.dummy((String)"test"));
        PhysicalSegmentInspector rowCountInspector = (PhysicalSegmentInspector)queryableIndexSegment.as(PhysicalSegmentInspector.class);
        QueryableIndexCursorFactory cursorFactory = new QueryableIndexCursorFactory(this.index2);
        ImmutableMap.Builder segmentStatsMap = new ImmutableMap.Builder();
        segmentStatsMap.put((Object)this.segment3.getId(), (Object)new SegmentMetadata(Long.valueOf(rowCountInspector.getNumRows()), "fp"));
        ImmutableMap.Builder schemaPayloadMap = new ImmutableMap.Builder();
        schemaPayloadMap.put((Object)"fp", (Object)new SchemaPayload(cursorFactory.getRowSignature()));
        this.segmentSchemaCache.updateFinalizedSegmentSchema(new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentStatsMap.build(), schemaPayloadMap.build()));
        Map segmentsMetadata = schema.getSegmentMetadataSnapshot();
        List segments = segmentsMetadata.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment existingSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)existingSegment);
        AvailableSegmentMetadata existingMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(existingSegment.getId());
        segmentStatsMap = new ImmutableMap.Builder();
        segmentStatsMap.put((Object)existingSegment.getId(), (Object)new SegmentMetadata(Long.valueOf(5L), "fp"));
        this.segmentSchemaCache.updateFinalizedSegmentSchema(new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentStatsMap.build(), schemaPayloadMap.build()));
        Pair pair = this.druidServers.stream().flatMap(druidServer -> this.serverView.getSegmentsOfServer((DruidServer)druidServer).stream().filter(segment -> segment.getId().equals((Object)existingSegment.getId())).map(segment -> Pair.of((Object)druidServer, (Object)segment))).findAny().orElse(null);
        Assert.assertNotNull((Object)pair);
        DruidServer server = (DruidServer)pair.lhs;
        Assert.assertNotNull((Object)server);
        DruidServerMetadata druidServerMetadata = server.getMetadata();
        schema.addSegment(druidServerMetadata, existingSegment);
        segmentsMetadata = schema.getSegmentMetadataSnapshot();
        segments = segmentsMetadata.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), new HashSet());
        this.verifyFoo2DSSchema(schema);
        schema.addSegment(druidServerMetadata, existingSegment);
        segmentsMetadata = schema.getSegmentMetadataSnapshot();
        DataSegment currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        AvailableSegmentMetadata currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((Object)currentSegment.getId(), (Object)currentMetadata.getSegment().getId());
        Assert.assertEquals((long)5L, (long)currentMetadata.getNumRows());
        Assert.assertEquals((long)existingMetadata.getNumReplicas(), (long)currentMetadata.getNumReplicas());
    }

    private CoordinatorSegmentMetadataCache setupForColdDatasourceSchemaTest(ServiceEmitter emitter) {
        DataSegment coldSegment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"1998/P2Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        DataSegment singleColdSegment = DataSegment.builder().dataSource("cold").interval(Intervals.of((String)"2000/P2Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        ImmutableMap.Builder segmentStatsMap = new ImmutableMap.Builder();
        segmentStatsMap.put((Object)coldSegment.getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "foo-fingerprint"));
        segmentStatsMap.put((Object)singleColdSegment.getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "cold-fingerprint"));
        ImmutableMap.Builder schemaPayloadMap = new ImmutableMap.Builder();
        schemaPayloadMap.put((Object)"foo-fingerprint", (Object)new SchemaPayload(RowSignature.builder().add("dim1", ColumnType.STRING).add("c1", ColumnType.STRING).add("c2", ColumnType.LONG).build()));
        schemaPayloadMap.put((Object)"cold-fingerprint", (Object)new SchemaPayload(RowSignature.builder().add("f1", ColumnType.STRING).add("f2", ColumnType.DOUBLE).build()));
        this.segmentSchemaCache.updateFinalizedSegmentSchema(new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentStatsMap.build(), schemaPayloadMap.build()));
        ArrayList<ImmutableDruidDataSource> druidDataSources = new ArrayList<ImmutableDruidDataSource>();
        HashMap<SegmentId, DataSegment> segmentMap = new HashMap<SegmentId, DataSegment>();
        segmentMap.put(coldSegment.getId(), coldSegment);
        segmentMap.put(this.segment1.getId(), this.segment1);
        segmentMap.put(this.segment2.getId(), this.segment2);
        druidDataSources.add(new ImmutableDruidDataSource(coldSegment.getDataSource(), Collections.emptyMap(), segmentMap));
        druidDataSources.add(new ImmutableDruidDataSource(singleColdSegment.getDataSource(), Collections.emptyMap(), Collections.singletonMap(singleColdSegment.getId(), singleColdSegment)));
        Mockito.when((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).thenReturn(druidDataSources);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), (CoordinatorServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), emitter, this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier);
        SegmentReplicaCount zeroSegmentReplicaCount = (SegmentReplicaCount)Mockito.mock(SegmentReplicaCount.class);
        SegmentReplicaCount nonZeroSegmentReplicaCount = (SegmentReplicaCount)Mockito.mock(SegmentReplicaCount.class);
        Mockito.when((Object)zeroSegmentReplicaCount.required()).thenReturn((Object)0);
        Mockito.when((Object)nonZeroSegmentReplicaCount.required()).thenReturn((Object)1);
        SegmentReplicationStatus segmentReplicationStatus = (SegmentReplicationStatus)Mockito.mock(SegmentReplicationStatus.class);
        Mockito.when((Object)segmentReplicationStatus.getReplicaCountsInCluster((SegmentId)ArgumentMatchers.eq((Object)coldSegment.getId()))).thenReturn((Object)zeroSegmentReplicaCount);
        Mockito.when((Object)segmentReplicationStatus.getReplicaCountsInCluster((SegmentId)ArgumentMatchers.eq((Object)singleColdSegment.getId()))).thenReturn((Object)zeroSegmentReplicaCount);
        Mockito.when((Object)segmentReplicationStatus.getReplicaCountsInCluster((SegmentId)ArgumentMatchers.eq((Object)this.segment1.getId()))).thenReturn((Object)nonZeroSegmentReplicaCount);
        Mockito.when((Object)segmentReplicationStatus.getReplicaCountsInCluster((SegmentId)ArgumentMatchers.eq((Object)this.segment2.getId()))).thenReturn((Object)nonZeroSegmentReplicaCount);
        schema.updateSegmentReplicationStatus(segmentReplicationStatus);
        schema.updateSegmentReplicationStatus(segmentReplicationStatus);
        return schema;
    }

    @Test
    public void testColdDatasourceSchema_refreshAfterColdSchemaExec() throws IOException {
        StubServiceEmitter emitter = new StubServiceEmitter("coordinator", "host");
        CoordinatorSegmentMetadataCache schema = this.setupForColdDatasourceSchemaTest((ServiceEmitter)emitter);
        schema.coldDatasourceSchemaExec();
        emitter.verifyEmitted("metadatacache/deepStorageOnly/segment/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"foo"), 1);
        emitter.verifyEmitted("metadatacache/deepStorageOnly/refresh/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"foo"), 1);
        emitter.verifyEmitted("metadatacache/deepStorageOnly/segment/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"cold"), 1);
        emitter.verifyEmitted("metadatacache/deepStorageOnly/refresh/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"cold"), 1);
        emitter.verifyEmitted("metadatacache/deepStorageOnly/process/time", 1);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "cold")), schema.getDataSourceInformationMap().keySet());
        RowSignature fooSignature = schema.getDatasource("foo").getRowSignature();
        List columnNames = fooSignature.getColumnNames();
        Assert.assertEquals((long)3L, (long)columnNames.size());
        Assert.assertEquals((Object)"dim1", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.STRING, fooSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"c1", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.STRING, fooSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"c2", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.LONG, fooSignature.getColumnType((String)columnNames.get(2)).get());
        RowSignature coldSignature = schema.getDatasource("cold").getRowSignature();
        columnNames = coldSignature.getColumnNames();
        Assert.assertEquals((Object)"f1", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.STRING, coldSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"f2", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.DOUBLE, coldSignature.getColumnType((String)columnNames.get(1)).get());
        HashSet<SegmentId> segmentIds = new HashSet<SegmentId>();
        segmentIds.add(this.segment1.getId());
        segmentIds.add(this.segment2.getId());
        schema.refresh(segmentIds, new HashSet());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "cold")), schema.getDataSourceInformationMap().keySet());
        coldSignature = schema.getDatasource("cold").getRowSignature();
        columnNames = coldSignature.getColumnNames();
        Assert.assertEquals((Object)"f1", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.STRING, coldSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"f2", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.DOUBLE, coldSignature.getColumnType((String)columnNames.get(1)).get());
        this.verifyFooDSSchema(schema, 8);
        RowSignature rowSignature = schema.getDatasource("foo").getRowSignature();
        columnNames = rowSignature.getColumnNames();
        Assert.assertEquals((Object)"c1", columnNames.get(6));
        Assert.assertEquals((Object)ColumnType.STRING, rowSignature.getColumnType((String)columnNames.get(6)).get());
        Assert.assertEquals((Object)"c2", columnNames.get(7));
        Assert.assertEquals((Object)ColumnType.LONG, rowSignature.getColumnType((String)columnNames.get(7)).get());
    }

    @Test
    public void testColdDatasourceSchema_coldSchemaExecAfterRefresh() throws IOException {
        StubServiceEmitter emitter = new StubServiceEmitter("coordinator", "host");
        CoordinatorSegmentMetadataCache schema = this.setupForColdDatasourceSchemaTest((ServiceEmitter)emitter);
        HashSet<SegmentId> segmentIds = new HashSet<SegmentId>();
        segmentIds.add(this.segment1.getId());
        segmentIds.add(this.segment2.getId());
        schema.refresh(segmentIds, new HashSet());
        Assert.assertEquals(Collections.singleton("foo"), schema.getDataSourceInformationMap().keySet());
        this.verifyFooDSSchema(schema, 6);
        Assert.assertNull((Object)schema.getDatasource("cold"));
        schema.coldDatasourceSchemaExec();
        emitter.verifyEmitted("metadatacache/deepStorageOnly/segment/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"foo"), 1);
        emitter.verifyEmitted("metadatacache/deepStorageOnly/refresh/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"foo"), 1);
        emitter.verifyEmitted("metadatacache/deepStorageOnly/segment/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"cold"), 1);
        emitter.verifyEmitted("metadatacache/deepStorageOnly/refresh/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"cold"), 1);
        emitter.verifyEmitted("metadatacache/deepStorageOnly/process/time", 1);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "cold")), schema.getDataSourceInformationMap().keySet());
        RowSignature coldSignature = schema.getDatasource("cold").getRowSignature();
        List columnNames = coldSignature.getColumnNames();
        Assert.assertEquals((Object)"f1", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.STRING, coldSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"f2", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.DOUBLE, coldSignature.getColumnType((String)columnNames.get(1)).get());
        this.verifyFooDSSchema(schema, 8);
        RowSignature rowSignature = schema.getDatasource("foo").getRowSignature();
        columnNames = rowSignature.getColumnNames();
        Assert.assertEquals((Object)"c1", columnNames.get(6));
        Assert.assertEquals((Object)ColumnType.STRING, rowSignature.getColumnType((String)columnNames.get(6)).get());
        Assert.assertEquals((Object)"c2", columnNames.get(7));
        Assert.assertEquals((Object)ColumnType.LONG, rowSignature.getColumnType((String)columnNames.get(7)).get());
    }

    @Test
    public void testColdDatasourceSchema_verifyStaleDatasourceRemoved() {
        DataSegment coldSegmentAlpha = DataSegment.builder().dataSource("alpha").interval(Intervals.of((String)"2000/P2Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        DataSegment coldSegmentBeta = DataSegment.builder().dataSource("beta").interval(Intervals.of((String)"2000/P2Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        DataSegment coldSegmentGamma = DataSegment.builder().dataSource("gamma").interval(Intervals.of((String)"2000/P2Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        DataSegment hotSegmentGamma = DataSegment.builder().dataSource("gamma").interval(Intervals.of((String)"2001/P2Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        ImmutableMap.Builder segmentStatsMap = new ImmutableMap.Builder();
        segmentStatsMap.put((Object)coldSegmentAlpha.getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "cold"));
        segmentStatsMap.put((Object)coldSegmentBeta.getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "cold"));
        segmentStatsMap.put((Object)hotSegmentGamma.getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "hot"));
        segmentStatsMap.put((Object)coldSegmentGamma.getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "cold"));
        ImmutableMap.Builder schemaPayloadMap = new ImmutableMap.Builder();
        schemaPayloadMap.put((Object)"cold", (Object)new SchemaPayload(RowSignature.builder().add("dim1", ColumnType.STRING).add("c1", ColumnType.STRING).add("c2", ColumnType.LONG).build()));
        schemaPayloadMap.put((Object)"hot", (Object)new SchemaPayload(RowSignature.builder().add("c3", ColumnType.STRING).add("c4", ColumnType.STRING).build()));
        this.segmentSchemaCache.updateFinalizedSegmentSchema(new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentStatsMap.build(), schemaPayloadMap.build()));
        ArrayList<ImmutableDruidDataSource> druidDataSources = new ArrayList<ImmutableDruidDataSource>();
        druidDataSources.add(new ImmutableDruidDataSource("alpha", Collections.emptyMap(), Collections.singletonMap(coldSegmentAlpha.getId(), coldSegmentAlpha)));
        HashMap<SegmentId, DataSegment> gammaSegments = new HashMap<SegmentId, DataSegment>();
        gammaSegments.put(hotSegmentGamma.getId(), hotSegmentGamma);
        gammaSegments.put(coldSegmentGamma.getId(), coldSegmentGamma);
        druidDataSources.add(new ImmutableDruidDataSource("gamma", Collections.emptyMap(), gammaSegments));
        Mockito.when((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).thenReturn(druidDataSources);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), (CoordinatorServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier);
        SegmentReplicaCount zeroSegmentReplicaCount = (SegmentReplicaCount)Mockito.mock(SegmentReplicaCount.class);
        SegmentReplicaCount nonZeroSegmentReplicaCount = (SegmentReplicaCount)Mockito.mock(SegmentReplicaCount.class);
        Mockito.when((Object)zeroSegmentReplicaCount.required()).thenReturn((Object)0);
        Mockito.when((Object)nonZeroSegmentReplicaCount.required()).thenReturn((Object)1);
        SegmentReplicationStatus segmentReplicationStatus = (SegmentReplicationStatus)Mockito.mock(SegmentReplicationStatus.class);
        Mockito.when((Object)segmentReplicationStatus.getReplicaCountsInCluster((SegmentId)ArgumentMatchers.eq((Object)coldSegmentAlpha.getId()))).thenReturn((Object)zeroSegmentReplicaCount);
        Mockito.when((Object)segmentReplicationStatus.getReplicaCountsInCluster((SegmentId)ArgumentMatchers.eq((Object)coldSegmentBeta.getId()))).thenReturn((Object)zeroSegmentReplicaCount);
        Mockito.when((Object)segmentReplicationStatus.getReplicaCountsInCluster((SegmentId)ArgumentMatchers.eq((Object)coldSegmentGamma.getId()))).thenReturn((Object)zeroSegmentReplicaCount);
        Mockito.when((Object)segmentReplicationStatus.getReplicaCountsInCluster((SegmentId)ArgumentMatchers.eq((Object)hotSegmentGamma.getId()))).thenReturn((Object)nonZeroSegmentReplicaCount);
        schema.updateSegmentReplicationStatus(segmentReplicationStatus);
        schema.coldDatasourceSchemaExec();
        Assert.assertNotNull((Object)schema.getDatasource("alpha"));
        Assert.assertNotNull((Object)schema.getDatasource("gamma"));
        RowSignature rowSignature = schema.getDatasource("gamma").getRowSignature();
        Assert.assertTrue((boolean)rowSignature.contains("dim1"));
        Assert.assertTrue((boolean)rowSignature.contains("c1"));
        Assert.assertTrue((boolean)rowSignature.contains("c2"));
        Assert.assertFalse((boolean)rowSignature.contains("c3"));
        Assert.assertFalse((boolean)rowSignature.contains("c4"));
        Assert.assertEquals(new HashSet<String>(Arrays.asList("alpha", "gamma")), schema.getDataSourceInformationMap().keySet());
        druidDataSources.clear();
        druidDataSources.add(new ImmutableDruidDataSource("beta", Collections.emptyMap(), Collections.singletonMap(coldSegmentBeta.getId(), coldSegmentBeta)));
        druidDataSources.add(new ImmutableDruidDataSource("gamma", Collections.emptyMap(), Collections.singletonMap(hotSegmentGamma.getId(), hotSegmentGamma)));
        Mockito.when((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).thenReturn(druidDataSources);
        schema.coldDatasourceSchemaExec();
        Assert.assertNotNull((Object)schema.getDatasource("beta"));
        Assert.assertNull((Object)schema.getDatasource("alpha"));
        Assert.assertNull((Object)schema.getDatasource("gamma"));
        Assert.assertNull((Object)schema.getDatasource("doesnotexist"));
        Assert.assertEquals(Collections.singleton("beta"), schema.getDataSourceInformationMap().keySet());
    }

    @Test
    public void testColdDatasourceSchemaExecRunsPeriodically() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(2);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            long getColdSchemaExecPeriodMillis() {
                return 10L;
            }

            protected void coldDatasourceSchemaExec() {
                latch.countDown();
                super.coldDatasourceSchemaExec();
            }
        };
        schema.onLeaderStart();
        schema.awaitInitialization();
        latch.await(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testTombstoneSegmentIsNotRefreshed() throws IOException {
        String brokerInternalQueryConfigJson = "{\"context\": { \"priority\": 5} }";
        TestHelper.makeJsonMapper();
        InternalQueryConfig internalQueryConfig = (InternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(brokerInternalQueryConfigJson, InternalQueryConfig.class)), InternalQueryConfig.class);
        QueryLifecycleFactory factoryMock = (QueryLifecycleFactory)EasyMock.createMock(QueryLifecycleFactory.class);
        QueryLifecycle lifecycleMock = (QueryLifecycle)EasyMock.createMock(QueryLifecycle.class);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(factoryMock, (CoordinatorServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), internalQueryConfig, (ServiceEmitter)new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier);
        ImmutableMap queryContext = ImmutableMap.of((Object)"priority", (Object)5, (Object)"enableParallelMerge", (Object)false);
        DataSegment segment = this.newSegment("test", 0);
        DataSegment tombstone = DataSegment.builder().dataSource("test").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec((ShardSpec)new TombstoneShardSpec()).loadSpec(Collections.singletonMap("type", "tombstone")).size(0L).build();
        DruidServer historicalServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.HISTORICAL)).findAny().orElse(null);
        Assert.assertNotNull((Object)historicalServer);
        DruidServerMetadata historicalServerMetadata = historicalServer.getMetadata();
        schema.addSegment(historicalServerMetadata, segment);
        schema.addSegment(historicalServerMetadata, tombstone);
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(tombstone.getId()));
        ImmutableList segmentIterable = ImmutableList.of((Object)segment.getId(), (Object)tombstone.getId());
        SegmentMetadataQuery expectedMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(segment.getDataSource()), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentIterable.stream().filter(id -> !id.equals((Object)tombstone.getId())).map(SegmentId::toDescriptor).collect(Collectors.toList())), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), (Map)queryContext, EnumSet.of(SegmentMetadataQuery.AnalysisType.AGGREGATORS), Boolean.valueOf(false), null, null);
        EasyMock.expect((Object)factoryMock.factorize()).andReturn((Object)lifecycleMock).once();
        EasyMock.expect((Object)lifecycleMock.runSimple((Query)expectedMetadataQuery, AllowAllAuthenticator.ALLOW_ALL_RESULT, Access.OK)).andReturn((Object)QueryResponse.withEmptyContext((Sequence)Sequences.empty())).once();
        EasyMock.replay((Object[])new Object[]{factoryMock, lifecycleMock});
        schema.refresh(Collections.singleton(segment.getId()), Collections.singleton("test"));
        EasyMock.verify((Object[])new Object[]{factoryMock, lifecycleMock});
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(tombstone.getId()));
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("test", tombstone.getId());
        Assert.assertNotNull((Object)availableSegmentMetadata);
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(tombstone.getId()));
        HashSet metadatas = new HashSet();
        schema.iterateSegmentMetadata().forEachRemaining(metadatas::add);
        Assert.assertEquals((long)1L, (long)metadatas.stream().filter(metadata -> metadata.getSegment().isTombstone()).count());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(tombstone.getId()));
    }

    @Test
    public void testUnusedSegmentIsNotRefreshed() throws InterruptedException, IOException {
        String dataSource = "xyz";
        final CountDownLatch latch = new CountDownLatch(1);
        CoordinatorSegmentMetadataCache schema = new CoordinatorSegmentMetadataCache(this.getQueryLifecycleFactory((QuerySegmentWalker)this.walker), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), new NoopServiceEmitter(), this.segmentSchemaCache, this.backFillQueue, this.sqlSegmentsMetadataManager, this.segmentsMetadataManagerConfigSupplier){

            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
                latch.countDown();
            }
        };
        ImmutableList segments = ImmutableList.of((Object)this.newSegment(dataSource, 1), (Object)this.newSegment(dataSource, 2), (Object)this.newSegment(dataSource, 3));
        DruidServer historicalServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.HISTORICAL)).findAny().orElse(null);
        Assert.assertNotNull((Object)historicalServer);
        DruidServerMetadata historicalServerMetadata = historicalServer.getMetadata();
        ImmutableMap.Builder segmentStatsMap = new ImmutableMap.Builder();
        segmentStatsMap.put((Object)((DataSegment)segments.get(0)).getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "fp"));
        segmentStatsMap.put((Object)((DataSegment)segments.get(1)).getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "fp"));
        segmentStatsMap.put((Object)((DataSegment)segments.get(2)).getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "fp"));
        ImmutableMap.Builder schemaPayloadMap = new ImmutableMap.Builder();
        schemaPayloadMap.put((Object)"fp", (Object)new SchemaPayload(RowSignature.builder().add("c1", ColumnType.DOUBLE).build()));
        this.segmentSchemaCache.updateFinalizedSegmentSchema(new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentStatsMap.build(), schemaPayloadMap.build()));
        schema.addSegment(historicalServerMetadata, (DataSegment)segments.get(0));
        schema.addSegment(historicalServerMetadata, (DataSegment)segments.get(1));
        schema.addSegment(historicalServerMetadata, (DataSegment)segments.get(2));
        this.serverView.addSegment((DataSegment)segments.get(0), ServerType.HISTORICAL);
        this.serverView.addSegment((DataSegment)segments.get(1), ServerType.HISTORICAL);
        this.serverView.addSegment((DataSegment)segments.get(2), ServerType.HISTORICAL);
        schema.onLeaderStart();
        schema.awaitInitialization();
        Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        segmentStatsMap = new ImmutableMap.Builder();
        segmentStatsMap.put((Object)((DataSegment)segments.get(0)).getId(), (Object)new SegmentMetadata(Long.valueOf(20L), "fp"));
        this.segmentSchemaCache.updateFinalizedSegmentSchema(new SegmentSchemaCache.FinalizedSegmentSchemaInfo(segmentStatsMap.build(), schemaPayloadMap.build()));
        HashMap segmentMap = new HashMap();
        segmentMap.put(((DataSegment)segments.get(0)).getId(), segments.get(0));
        segmentMap.put(((DataSegment)segments.get(1)).getId(), segments.get(1));
        ImmutableDruidDataSource druidDataSource = new ImmutableDruidDataSource("xyz", Collections.emptyMap(), segmentMap);
        Mockito.when((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments(ArgumentMatchers.anyString())).thenReturn((Object)druidDataSource);
        Set segmentsToRefresh = segments.stream().map(DataSegment::getId).collect(Collectors.toSet());
        segmentsToRefresh.remove(((DataSegment)segments.get(1)).getId());
        segmentsToRefresh.remove(((DataSegment)segments.get(2)).getId());
        schema.refresh(segmentsToRefresh, (Set)Sets.newHashSet((Object[])new String[]{dataSource}));
        Assert.assertTrue((boolean)schema.getSegmentsNeedingRefresh().contains(((DataSegment)segments.get(1)).getId()));
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(((DataSegment)segments.get(2)).getId()));
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata(dataSource, ((DataSegment)segments.get(0)).getId());
        Assert.assertNotNull((Object)availableSegmentMetadata);
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(((DataSegment)segments.get(0)).getId()));
        HashSet metadatas = new HashSet();
        schema.iterateSegmentMetadata().forEachRemaining(metadatas::add);
        Assert.assertEquals((long)1L, (long)metadatas.stream().filter(arg_0 -> CoordinatorSegmentMetadataCacheTest.lambda$testUnusedSegmentIsNotRefreshed$28((List)segments, arg_0)).count());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(((DataSegment)segments.get(0)).getId()));
    }

    private void verifyFooDSSchema(CoordinatorSegmentMetadataCache schema, int columns) {
        DataSourceInformation fooDs = schema.getDatasource("foo");
        RowSignature fooRowSignature = fooDs.getRowSignature();
        List columnNames = fooRowSignature.getColumnNames();
        Assert.assertEquals((long)columns, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"dim2", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.STRING, fooRowSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"m1", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.DOUBLE, fooRowSignature.getColumnType((String)columnNames.get(2)).get());
        Assert.assertEquals((Object)"dim1", columnNames.get(3));
        Assert.assertEquals((Object)ColumnType.STRING, fooRowSignature.getColumnType((String)columnNames.get(3)).get());
        Assert.assertEquals((Object)"cnt", columnNames.get(4));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(4)).get());
        Assert.assertEquals((Object)"unique_dim1", columnNames.get(5));
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"hyperUnique"), fooRowSignature.getColumnType((String)columnNames.get(5)).get());
    }

    private void verifyFoo2DSSchema(CoordinatorSegmentMetadataCache schema) {
        DataSourceInformation fooDs = schema.getDatasource("foo2");
        RowSignature fooRowSignature = fooDs.getRowSignature();
        List columnNames = fooRowSignature.getColumnNames();
        Assert.assertEquals((long)3L, (long)columnNames.size());
        Assert.assertEquals((Object)"__time", columnNames.get(0));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(0)).get());
        Assert.assertEquals((Object)"dim2", columnNames.get(1));
        Assert.assertEquals((Object)ColumnType.STRING, fooRowSignature.getColumnType((String)columnNames.get(1)).get());
        Assert.assertEquals((Object)"m1", columnNames.get(2));
        Assert.assertEquals((Object)ColumnType.LONG, fooRowSignature.getColumnType((String)columnNames.get(2)).get());
    }

    private static /* synthetic */ boolean lambda$testUnusedSegmentIsNotRefreshed$28(List segments, AvailableSegmentMetadata metadata) {
        return metadata.getSegment().getId().equals((Object)((DataSegment)segments.get(0)).getId());
    }
}

