/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.metadata.SegmentSchemaTestUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SegmentSchemaManagerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule(CentralizedDatasourceSchemaConfig.create((boolean)true));
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();
    SegmentSchemaManager segmentSchemaManager;
    TestDerbyConnector derbyConnector;
    MetadataStorageTablesConfig tablesConfig;
    FingerprintGenerator fingerprintGenerator;
    SegmentSchemaTestUtils segmentSchemaTestUtils;

    @Before
    public void setUp() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.derbyConnector.createSegmentSchemasTable();
        this.derbyConnector.createSegmentTable();
        this.fingerprintGenerator = new FingerprintGenerator(this.mapper);
        this.segmentSchemaManager = new SegmentSchemaManager((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), this.mapper, (SQLMetadataConnector)this.derbyConnector);
        this.segmentSchemaTestUtils = new SegmentSchemaTestUtils(this.derbyConnectorRule, this.derbyConnector, this.mapper);
    }

    @Test
    public void testPersistSchemaAndUpdateSegmentsTable() {
        HashMap<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap = new HashMap<String, Pair<SchemaPayload, Integer>>();
        Random random = new Random(5L);
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus> schemaMetadataPluses = new ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus>();
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)("2023-01-0" + i + "/2023-01-0" + (i + 1))), "2023-01-0" + i, (Map)ImmutableMap.of((Object)"path", (Object)("a-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
            segments.add(segment);
            int randomNum = random.nextInt();
            RowSignature rowSignature = RowSignature.builder().add("c" + randomNum, ColumnType.FLOAT).build();
            HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
            aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
            SchemaPayloadPlus schemaMetadata = new SchemaPayloadPlus(schemaPayload, Long.valueOf(randomNum));
            SegmentSchemaManager.SegmentSchemaMetadataPlus plus = new SegmentSchemaManager.SegmentSchemaMetadataPlus(segment.getId(), this.fingerprintGenerator.generateFingerprint(schemaPayload, segment.getDataSource(), 1), schemaMetadata);
            schemaMetadataPluses.add(plus);
            segmentIdSchemaMap.put(segment.getId().toString(), (Pair<SchemaPayload, Integer>)Pair.of((Object)schemaPayload, (Object)randomNum));
        }
        this.segmentSchemaTestUtils.insertUsedSegments(segments, Collections.emptyMap());
        this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable("foo", schemaMetadataPluses, 1);
        this.segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
        DataSegment segment = (DataSegment)segments.stream().findAny().get();
        Pair schemaPayloadIntegerPair = (Pair)segmentIdSchemaMap.get(segment.getId().toString());
        DataSegment newSegment = new DataSegment("foo", Intervals.of((String)"2024-01-01/2024-01-02"), "2023-01-01", (Map)ImmutableMap.of((Object)"path", (Object)"a-1"), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        SchemaPayloadPlus schemaMetadata = new SchemaPayloadPlus((SchemaPayload)schemaPayloadIntegerPair.lhs, Long.valueOf(500L));
        SegmentSchemaManager.SegmentSchemaMetadataPlus plus = new SegmentSchemaManager.SegmentSchemaMetadataPlus(newSegment.getId(), this.fingerprintGenerator.generateFingerprint((SchemaPayload)schemaPayloadIntegerPair.lhs, newSegment.getDataSource(), 1), schemaMetadata);
        this.segmentSchemaTestUtils.insertUsedSegments(Collections.singleton(newSegment), Collections.emptyMap());
        this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable("foo", Collections.singletonList(plus), 1);
        segmentIdSchemaMap.clear();
        segmentIdSchemaMap.put(newSegment.getId().toString(), (Pair<SchemaPayload, Integer>)Pair.of((Object)schemaPayloadIntegerPair.lhs, (Object)500));
        this.segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
    }

    @Test
    public void testPersistAndUpdateSegmentsTable_unusedExistingSegment() {
        HashMap<String, Pair<SchemaPayload, Integer>> segmentIdSchemaMap = new HashMap<String, Pair<SchemaPayload, Integer>>();
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus> schemaMetadataPluses = new ArrayList<SegmentSchemaManager.SegmentSchemaMetadataPlus>();
        for (int i = 1; i < 9; ++i) {
            DataSegment segment = new DataSegment("foo", Intervals.of((String)("2023-01-0" + i + "/2023-01-0" + (i + 1))), "2023-01-0" + i, (Map)ImmutableMap.of((Object)"path", (Object)("a-" + i)), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
            segments.add(segment);
            RowSignature rowSignature = RowSignature.builder().add("c" + i, ColumnType.FLOAT).build();
            HashMap<String, LongFirstAggregatorFactory> aggregatorFactoryMap = new HashMap<String, LongFirstAggregatorFactory>();
            aggregatorFactoryMap.put("longFirst", new LongFirstAggregatorFactory("longFirst", "long-col", null));
            SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregatorFactoryMap);
            SchemaPayloadPlus schemaMetadata = new SchemaPayloadPlus(schemaPayload, Long.valueOf(i));
            SegmentSchemaManager.SegmentSchemaMetadataPlus plus = new SegmentSchemaManager.SegmentSchemaMetadataPlus(segment.getId(), this.fingerprintGenerator.generateFingerprint(schemaPayload, segment.getDataSource(), 1), schemaMetadata);
            schemaMetadataPluses.add(plus);
            segmentIdSchemaMap.put(segment.getId().toString(), (Pair<SchemaPayload, Integer>)Pair.of((Object)schemaPayload, (Object)i));
        }
        this.segmentSchemaTestUtils.insertUsedSegments(segments, Collections.emptyMap());
        HashSet<String> unusedFingerprints = new HashSet<String>();
        HashMap<String, SchemaPayload> schemaPayloadMapToPersist = new HashMap<String, SchemaPayload>();
        for (int i = 1; i <= 6; ++i) {
            SegmentSchemaManager.SegmentSchemaMetadataPlus plus = (SegmentSchemaManager.SegmentSchemaMetadataPlus)schemaMetadataPluses.get(i);
            schemaPayloadMapToPersist.put(plus.getFingerprint(), plus.getSegmentSchemaMetadata().getSchemaPayload());
            if (i > 3) continue;
            unusedFingerprints.add(plus.getFingerprint());
        }
        this.segmentSchemaTestUtils.insertSegmentSchema("foo", schemaPayloadMapToPersist, unusedFingerprints);
        this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable("foo", schemaMetadataPluses, 1);
        this.segmentSchemaTestUtils.verifySegmentSchema(segmentIdSchemaMap);
    }

    static {
        NullHandling.initializeForTests();
    }
}

