/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.inject.Key;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;

public interface EtagProvider {
    public static final Key<EtagProvider> KEY = Key.get(EtagProvider.class);

    public String getEtagFor(Query<?> var1);

    public static class ProvideEtagBasedOnDatasource
    implements EtagProvider {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String getEtagFor(Query<?> query) {
            if (!query.getDataSource().isCacheable(true)) {
                return null;
            }
            if (!(query.getDataSource() instanceof TableDataSource)) {
                throw DruidException.defensive((String)"only TableDataSource handled right now", (Object[])new Object[0]);
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                TableDataSource tableDataSource = (TableDataSource)query.getDataSource();
                baos.write(query.getDataSource().getCacheKey());
                baos.write(tableDataSource.getName().getBytes(StandardCharsets.UTF_8));
                String string = "ETP-" + new String(baos.toByteArray(), StandardCharsets.UTF_8);
                return string;
            }
            catch (IOException e) {
                throw DruidException.defensive().build((Throwable)e, "Unexpected IOException", new Object[0]);
            }
        }
    }

    public static class EmptyEtagProvider
    implements EtagProvider {
        @Override
        public String getEtagFor(Query<?> query) {
            return null;
        }
    }
}

