/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.NoopOverlordClient;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionRunSimulator;
import org.apache.druid.server.compaction.CompactionSimulateResult;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.compaction.Table;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.simulate.TestSegmentsMetadataManager;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class CompactionRunSimulatorTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private final CompactionRunSimulator simulator = new CompactionRunSimulator(new CompactionStatusTracker(OBJECT_MAPPER), (OverlordClient)new TestOverlordClient());

    @Test
    public void testSimulateClusterCompactionConfigUpdate() {
        TestSegmentsMetadataManager segmentsMetadataManager = new TestSegmentsMetadataManager();
        List<DataSegment> wikiSegments = CreateDataSegments.ofDatasource("wiki").forIntervals(10, Granularities.DAY).withNumPartitions(10).startingAt("2013-01-01").eachOfSizeInMb(100L);
        wikiSegments.forEach(segmentsMetadataManager::addSegment);
        CompactionSimulateResult simulateResult = this.simulator.simulateRunWithConfig(DruidCompactionConfig.empty().withDatasourceConfig(DataSourceCompactionConfig.builder().forDataSource("wiki").build()), segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments().getUsedSegmentsTimelinesPerDataSource(), CompactionEngine.NATIVE);
        Assert.assertNotNull((Object)simulateResult);
        Map compactionStates = simulateResult.getCompactionStates();
        Assert.assertNotNull((Object)compactionStates);
        Assert.assertNull(compactionStates.get(CompactionStatus.State.COMPLETE));
        Assert.assertNull(compactionStates.get(CompactionStatus.State.RUNNING));
        Table queuedTable = (Table)compactionStates.get(CompactionStatus.State.PENDING);
        Assert.assertEquals(Arrays.asList("dataSource", "interval", "numSegments", "bytes", "maxTaskSlots", "reasonToCompact"), (Object)queuedTable.getColumnNames());
        Assert.assertEquals(Arrays.asList(Arrays.asList("wiki", Intervals.of((String)"2013-01-09/P1D"), 10, 1000000000L, 1, "not compacted yet"), Arrays.asList("wiki", Intervals.of((String)"2013-01-08/P1D"), 10, 1000000000L, 1, "not compacted yet"), Arrays.asList("wiki", Intervals.of((String)"2013-01-07/P1D"), 10, 1000000000L, 1, "not compacted yet"), Arrays.asList("wiki", Intervals.of((String)"2013-01-06/P1D"), 10, 1000000000L, 1, "not compacted yet"), Arrays.asList("wiki", Intervals.of((String)"2013-01-05/P1D"), 10, 1000000000L, 1, "not compacted yet"), Arrays.asList("wiki", Intervals.of((String)"2013-01-04/P1D"), 10, 1000000000L, 1, "not compacted yet"), Arrays.asList("wiki", Intervals.of((String)"2013-01-03/P1D"), 10, 1000000000L, 1, "not compacted yet"), Arrays.asList("wiki", Intervals.of((String)"2013-01-02/P1D"), 10, 1000000000L, 1, "not compacted yet"), Arrays.asList("wiki", Intervals.of((String)"2013-01-01/P1D"), 10, 1000000000L, 1, "not compacted yet")), (Object)queuedTable.getRows());
        Table skippedTable = (Table)compactionStates.get(CompactionStatus.State.SKIPPED);
        Assert.assertEquals(Arrays.asList("dataSource", "interval", "numSegments", "bytes", "reasonToSkip"), (Object)skippedTable.getColumnNames());
        Assert.assertEquals(Collections.singletonList(Arrays.asList("wiki", Intervals.of((String)"2013-01-10/P1D"), 10, 1000000000L, "skip offset from latest[P1D]")), (Object)skippedTable.getRows());
    }

    private static class TestOverlordClient
    extends NoopOverlordClient {
        private TestOverlordClient() {
        }

        @Override
        public ListenableFuture<CloseableIterator<TaskStatusPlus>> taskStatuses(@Nullable String state, @Nullable String dataSource, @Nullable Integer maxCompletedTasks) {
            return Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(Collections.emptyIterator()));
        }

        @Override
        public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
            return Futures.immediateFuture(Collections.emptyMap());
        }

        @Override
        public ListenableFuture<TaskPayloadResponse> taskPayload(String taskId) {
            return Futures.immediateFuture(null);
        }

        @Override
        public ListenableFuture<Void> runTask(String taskId, Object taskObject) {
            return Futures.immediateVoidFuture();
        }

        @Override
        public ListenableFuture<Void> cancelTask(String taskId) {
            return Futures.immediateVoidFuture();
        }

        @Override
        public ListenableFuture<Map<String, List<Interval>>> findLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
            return Futures.immediateFuture(Collections.emptyMap());
        }
    }
}

