/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorRunStatsTest {
    private CoordinatorRunStats stats;

    @Before
    public void setUp() {
        this.stats = new CoordinatorRunStats();
    }

    @After
    public void tearDown() {
        this.stats = null;
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((long)0L, (long)this.stats.get(Stat.ERROR_1));
        this.stats.add(Stat.ERROR_1, 1L);
        Assert.assertEquals((long)1L, (long)this.stats.get(Stat.ERROR_1));
        this.stats.add(Stat.ERROR_1, -11L);
        Assert.assertEquals((long)-10L, (long)this.stats.get(Stat.ERROR_1));
    }

    @Test
    public void testAddForRowKey() {
        this.stats.add(Stat.ERROR_1, Key.TIER_1, 1L);
        this.stats.add(Stat.ERROR_1, Key.TIER_2, 1L);
        this.stats.add(Stat.ERROR_1, Key.TIER_1, -5L);
        this.stats.add(Stat.INFO_1, Key.TIER_1, 1L);
        this.stats.add(Stat.ERROR_1, Key.TIER_2, 1L);
        Assert.assertFalse((boolean)this.stats.hasStat(Stat.INFO_2));
        Assert.assertEquals((long)-4L, (long)this.stats.get(Stat.ERROR_1, Key.TIER_1));
        Assert.assertEquals((long)2L, (long)this.stats.get(Stat.ERROR_1, Key.TIER_2));
        Assert.assertEquals((long)1L, (long)this.stats.get(Stat.INFO_1, Key.TIER_1));
    }

    @Test
    public void testUpdateMax() {
        this.stats.updateMax(Stat.ERROR_1, Key.TIER_1, 2L);
        this.stats.updateMax(Stat.ERROR_1, Key.TIER_1, 6L);
        this.stats.updateMax(Stat.ERROR_1, Key.TIER_1, 5L);
        this.stats.updateMax(Stat.INFO_1, Key.TIER_1, 5L);
        this.stats.updateMax(Stat.INFO_1, Key.TIER_1, 4L);
        this.stats.updateMax(Stat.INFO_1, Key.TIER_1, 5L);
        this.stats.updateMax(Stat.ERROR_1, Key.TIER_2, 7L);
        this.stats.updateMax(Stat.ERROR_1, Key.TIER_2, 9L);
        this.stats.updateMax(Stat.ERROR_1, Key.TIER_2, 10L);
        Assert.assertFalse((boolean)this.stats.hasStat(Stat.INFO_2));
        Assert.assertEquals((long)6L, (long)this.stats.get(Stat.ERROR_1, Key.TIER_1));
        Assert.assertEquals((long)5L, (long)this.stats.get(Stat.INFO_1, Key.TIER_1));
        Assert.assertEquals((long)10L, (long)this.stats.get(Stat.ERROR_1, Key.TIER_2));
    }

    @Test
    public void testAddToDutyStat() {
        this.stats.add(Stat.ERROR_1, Key.DUTY_1, 1L);
        this.stats.add(Stat.ERROR_1, Key.DUTY_2, 1L);
        this.stats.add(Stat.ERROR_1, Key.DUTY_1, -5L);
        this.stats.add(Stat.INFO_1, Key.DUTY_1, 1L);
        this.stats.add(Stat.ERROR_1, Key.DUTY_2, 1L);
        Assert.assertFalse((boolean)this.stats.hasStat(Stat.INFO_2));
        Assert.assertEquals((long)-4L, (long)this.stats.get(Stat.ERROR_1, Key.DUTY_1));
        Assert.assertEquals((long)2L, (long)this.stats.get(Stat.ERROR_1, Key.DUTY_2));
        Assert.assertEquals((long)1L, (long)this.stats.get(Stat.INFO_1, Key.DUTY_1));
    }

    @Test
    public void testForEachStat() {
        ImmutableMap expected = ImmutableMap.of((Object)"duty1", (Object)1L, (Object)"duty2", (Object)2L, (Object)"duty3", (Object)3L);
        expected.forEach((duty, count) -> this.stats.add(Stat.ERROR_1, RowKey.of((Dimension)Dimension.DUTY, (String)duty), count.longValue()));
        HashMap actual = new HashMap();
        this.stats.forEachStat((stat, rowKey, value) -> {
            if (stat.equals(Stat.ERROR_1)) {
                actual.put(rowKey.getValues().get(Dimension.DUTY), value);
            }
        });
        Assert.assertEquals((Object)expected, actual);
    }

    @Test
    public void testBuildStatsTable() {
        this.stats.add(Stat.ERROR_1, Key.DUTY_1, 10L);
        this.stats.add(Stat.INFO_1, Key.DUTY_1, 20L);
        this.stats.add(Stat.DEBUG_1, Key.DUTY_1, 30L);
        String expectedTable = "\nError: {duty=duty1} ==> {error1=10}\nInfo : {duty=duty1} ==> {info1=20}";
        Assert.assertEquals((Object)"\nError: {duty=duty1} ==> {error1=10}\nInfo : {duty=duty1} ==> {info1=20}", (Object)this.stats.buildStatsTable());
    }

    @Test
    public void testBuildStatsTableWithDebugDimensions() {
        CoordinatorRunStats debugStats = new CoordinatorRunStats(Key.DUTY_1.getValues());
        debugStats.add(Stat.ERROR_1, Key.DUTY_1, 10L);
        debugStats.add(Stat.INFO_1, Key.DUTY_1, 20L);
        debugStats.add(Stat.DEBUG_1, Key.DUTY_1, 30L);
        String expectedTable = "\nError: {duty=duty1} ==> {error1=10}\nInfo : {duty=duty1} ==> {info1=20}\nDebug: {duty=duty1} ==> {debug1=30}";
        Assert.assertEquals((Object)"\nError: {duty=duty1} ==> {error1=10}\nInfo : {duty=duty1} ==> {info1=20}\nDebug: {duty=duty1} ==> {debug1=30}", (Object)debugStats.buildStatsTable());
    }

    @Test
    public void testAddToEmptyThrowsException() {
        CoordinatorRunStats runStats = CoordinatorRunStats.empty();
        Assert.assertThrows(UnsupportedOperationException.class, () -> runStats.add(Stat.ERROR_1, 10L));
        Assert.assertThrows(UnsupportedOperationException.class, () -> runStats.add(Stat.ERROR_1, Key.DUTY_1, 10L));
        Assert.assertThrows(UnsupportedOperationException.class, () -> runStats.addToSegmentStat(Stat.ERROR_1, "t", "ds", 10L));
        Assert.assertThrows(UnsupportedOperationException.class, () -> runStats.updateMax(Stat.INFO_1, Key.TIER_1, 10L));
    }

    private static class Stat {
        static final CoordinatorStat ERROR_1 = CoordinatorStat.toLogAndEmit((String)"error1", (String)"e1", (CoordinatorStat.Level)CoordinatorStat.Level.ERROR);
        static final CoordinatorStat INFO_1 = CoordinatorStat.toLogAndEmit((String)"info1", (String)"i1", (CoordinatorStat.Level)CoordinatorStat.Level.INFO);
        static final CoordinatorStat INFO_2 = CoordinatorStat.toLogAndEmit((String)"info2", (String)"i2", (CoordinatorStat.Level)CoordinatorStat.Level.INFO);
        static final CoordinatorStat DEBUG_1 = CoordinatorStat.toDebugAndEmit((String)"debug1", (String)"d1");

        private Stat() {
        }
    }

    private static class Key {
        static final RowKey TIER_1 = RowKey.of((Dimension)Dimension.TIER, (String)"tier1");
        static final RowKey TIER_2 = RowKey.of((Dimension)Dimension.TIER, (String)"tier2");
        static final RowKey DUTY_1 = RowKey.of((Dimension)Dimension.DUTY, (String)"duty1");
        static final RowKey DUTY_2 = RowKey.of((Dimension)Dimension.DUTY, (String)"duty2");

        private Key() {
        }
    }
}

