/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.apache.druid.server.coordinator.duty.KillCompactionConfig;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KillCompactionConfigTest {
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    private SqlSegmentsMetadataManager mockSqlSegmentsMetadataManager;
    @Mock
    private JacksonConfigManager mockJacksonConfigManager;
    @Mock
    private MetadataStorageConnector mockConnector;
    @Mock
    private MetadataStorageTablesConfig mockConnectorConfig;
    private CoordinatorConfigManager coordinatorConfigManager;
    private KillCompactionConfig killCompactionConfig;
    private CoordinatorRunStats runStats;

    @Before
    public void setup() {
        this.runStats = new CoordinatorRunStats();
        Mockito.when((Object)this.mockConnectorConfig.getConfigTable()).thenReturn((Object)"druid_config");
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.runStats);
        this.coordinatorConfigManager = new CoordinatorConfigManager(this.mockJacksonConfigManager, this.mockConnector, this.mockConnectorConfig);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration(Long.MAX_VALUE), null);
        this.killCompactionConfig = new KillCompactionConfig(config, (SegmentsMetadataManager)this.mockSqlSegmentsMetadataManager, this.coordinatorConfigManager);
        this.killCompactionConfig.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockSqlSegmentsMetadataManager});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockJacksonConfigManager});
        Assert.assertEquals((long)0L, (long)this.runStats.rowCount());
    }

    @Test
    public void testRunDoNothingIfCurrentConfigIsEmpty() {
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn(null);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq(null), (Class)ArgumentMatchers.eq(DruidCompactionConfig.class), ArgumentMatchers.eq((Object)DruidCompactionConfig.empty()))).thenReturn((Object)DruidCompactionConfig.empty());
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration((Object)"PT6S"), null);
        this.killCompactionConfig = new KillCompactionConfig(config, (SegmentsMetadataManager)this.mockSqlSegmentsMetadataManager, this.coordinatorConfigManager);
        this.killCompactionConfig.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockSqlSegmentsMetadataManager});
        Assert.assertTrue((boolean)this.runStats.hasStat(Stats.Kill.COMPACTION_CONFIGS));
        Assert.assertEquals((long)0L, (long)this.runStats.get(Stats.Kill.COMPACTION_CONFIGS));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager)).convertByteToConfig((byte[])ArgumentMatchers.eq(null), (Class)ArgumentMatchers.eq(DruidCompactionConfig.class), ArgumentMatchers.eq((Object)DruidCompactionConfig.empty()));
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockConnector)).lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockJacksonConfigManager});
    }

    @Test
    public void testRunRemoveInactiveDatasourceCompactionConfig() {
        String inactiveDatasourceName = "inactive_datasource";
        String activeDatasourceName = "active_datasource";
        DataSourceCompactionConfig inactiveDatasourceConfig = new DataSourceCompactionConfig(inactiveDatasourceName, null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        DataSourceCompactionConfig activeDatasourceConfig = new DataSourceCompactionConfig(activeDatasourceName, null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        DruidCompactionConfig originalCurrentConfig = DruidCompactionConfig.empty().withDatasourceConfigs((List)ImmutableList.of((Object)inactiveDatasourceConfig, (Object)activeDatasourceConfig));
        byte[] originalCurrentConfigBytes = new byte[]{1, 2, 3};
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn((Object)originalCurrentConfigBytes);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq((Object)originalCurrentConfigBytes), (Class)ArgumentMatchers.eq(DruidCompactionConfig.class), ArgumentMatchers.eq((Object)DruidCompactionConfig.empty()))).thenReturn((Object)originalCurrentConfig);
        Mockito.when((Object)this.mockSqlSegmentsMetadataManager.retrieveAllDataSourceNames()).thenReturn((Object)ImmutableSet.of((Object)activeDatasourceName));
        ArgumentCaptor oldConfigCaptor = ArgumentCaptor.forClass(byte[].class);
        ArgumentCaptor newConfigCaptor = ArgumentCaptor.forClass(DruidCompactionConfig.class);
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])oldConfigCaptor.capture(), newConfigCaptor.capture(), (AuditInfo)ArgumentMatchers.any())).thenReturn((Object)ConfigManager.SetResult.ok());
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration((Object)"PT6S"), null);
        this.killCompactionConfig = new KillCompactionConfig(config, (SegmentsMetadataManager)this.mockSqlSegmentsMetadataManager, this.coordinatorConfigManager);
        this.killCompactionConfig.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertNotNull((Object)oldConfigCaptor.getValue());
        Assert.assertEquals((Object)oldConfigCaptor.getValue(), (Object)originalCurrentConfigBytes);
        Assert.assertNotNull((Object)newConfigCaptor.getValue());
        Assert.assertEquals((long)1L, (long)((DruidCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().size());
        Assert.assertEquals((Object)activeDatasourceConfig, ((DruidCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().get(0));
        Assert.assertEquals((long)1L, (long)this.runStats.get(Stats.Kill.COMPACTION_CONFIGS));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager)).convertByteToConfig((byte[])ArgumentMatchers.eq((Object)originalCurrentConfigBytes), (Class)ArgumentMatchers.eq(DruidCompactionConfig.class), ArgumentMatchers.eq((Object)DruidCompactionConfig.empty()));
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockConnector)).lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager)).set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.any(DruidCompactionConfig.class), (AuditInfo)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockJacksonConfigManager});
        ((SqlSegmentsMetadataManager)Mockito.verify((Object)this.mockSqlSegmentsMetadataManager)).retrieveAllDataSourceNames();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSqlSegmentsMetadataManager});
    }

    @Test
    public void testRunRetryForRetryableException() {
        String inactiveDatasourceName = "inactive_datasource";
        DataSourceCompactionConfig inactiveDatasourceConfig = new DataSourceCompactionConfig(inactiveDatasourceName, null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        DruidCompactionConfig originalCurrentConfig = DruidCompactionConfig.empty().withDatasourceConfigs((List)ImmutableList.of((Object)inactiveDatasourceConfig));
        byte[] originalCurrentConfigBytes = new byte[]{1, 2, 3};
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn((Object)originalCurrentConfigBytes);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq((Object)originalCurrentConfigBytes), (Class)ArgumentMatchers.eq(DruidCompactionConfig.class), ArgumentMatchers.eq((Object)DruidCompactionConfig.empty()))).thenReturn((Object)originalCurrentConfig);
        Mockito.when((Object)this.mockSqlSegmentsMetadataManager.retrieveAllDataSourceNames()).thenReturn((Object)ImmutableSet.of());
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.any(DruidCompactionConfig.class), (AuditInfo)ArgumentMatchers.any())).thenReturn((Object)ConfigManager.SetResult.retryableFailure((Exception)new Exception()), (Object[])new ConfigManager.SetResult[]{ConfigManager.SetResult.retryableFailure((Exception)new Exception()), ConfigManager.SetResult.retryableFailure((Exception)new Exception()), ConfigManager.SetResult.ok()});
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(true), new Duration((Object)"PT6S"), null);
        this.killCompactionConfig = new KillCompactionConfig(config, (SegmentsMetadataManager)this.mockSqlSegmentsMetadataManager, this.coordinatorConfigManager);
        this.killCompactionConfig.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertEquals((long)1L, (long)this.runStats.get(Stats.Kill.COMPACTION_CONFIGS));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager, (VerificationMode)Mockito.times((int)4))).convertByteToConfig((byte[])ArgumentMatchers.eq((Object)originalCurrentConfigBytes), (Class)ArgumentMatchers.eq(DruidCompactionConfig.class), ArgumentMatchers.eq((Object)DruidCompactionConfig.empty()));
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockConnector, (VerificationMode)Mockito.times((int)4))).lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager, (VerificationMode)Mockito.times((int)4))).set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.any(DruidCompactionConfig.class), (AuditInfo)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockJacksonConfigManager});
        ((SqlSegmentsMetadataManager)Mockito.verify((Object)this.mockSqlSegmentsMetadataManager, (VerificationMode)Mockito.times((int)4))).retrieveAllDataSourceNames();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSqlSegmentsMetadataManager});
    }
}

