/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ForeverLoadRuleTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerde() throws Exception {
        ForeverLoadRule rule = new ForeverLoadRule(null, null);
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        Rule reread = (Rule)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule.getTieredReplicants(), (Object)((ForeverLoadRule)reread).getTieredReplicants());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)rule.getTieredReplicants());
    }

    @Test
    public void testCreatingNegativeTieredReplicants() {
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)-1), null)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Invalid number of replicas for tier [_default_tier]. Value [-1] must be positive."));
    }

    @Test
    public void testEmptyTieredReplicants() throws Exception {
        ForeverLoadRule rule = new ForeverLoadRule((Map)ImmutableMap.of(), Boolean.valueOf(false));
        LoadRule reread = (LoadRule)OBJECT_MAPPER.readValue(OBJECT_MAPPER.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)reread.getTieredReplicants());
    }

    @Test
    public void testNullReplicantValue() {
        HashMap<String, Object> tieredReplicants = new HashMap<String, Object>();
        tieredReplicants.put("tier", null);
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new ForeverLoadRule(tieredReplicants, Boolean.valueOf(true))), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Invalid number of replicas for tier [tier]. Value must not be null."));
    }

    @Test
    public void testShouldCreateDefaultTier() throws Exception {
        String inputJson = "    {\n     \"type\": \"loadForever\"\n  }";
        ForeverLoadRule inputForeverLoadRule = (ForeverLoadRule)OBJECT_MAPPER.readValue(inputJson, ForeverLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)inputForeverLoadRule.getTieredReplicants());
    }

    @Test
    public void testUseDefaultTierAsTrueShouldCreateDefaultTier() throws Exception {
        String inputJson = "    {\n     \"type\": \"loadForever\"\n,     \"useDefaultTierForNull\": \"true\"\n  }";
        ForeverLoadRule inputForeverLoadRule = (ForeverLoadRule)OBJECT_MAPPER.readValue(inputJson, ForeverLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)inputForeverLoadRule.getTieredReplicants());
    }

    @Test
    public void testUseDefaultTierAsFalseShouldCreateEmptyMap() throws Exception {
        String inputJson = "    {\n     \"type\": \"loadForever\"\n,     \"useDefaultTierForNull\": \"false\"\n  }";
        ForeverLoadRule inputForeverLoadRule = (ForeverLoadRule)OBJECT_MAPPER.readValue(inputJson, ForeverLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)inputForeverLoadRule.getTieredReplicants());
    }
}

