/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class IntervalLoadRuleTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerde() throws Exception {
        IntervalLoadRule rule = new IntervalLoadRule(Intervals.of((String)"0/3000"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2), null);
        Rule reread = (Rule)OBJECT_MAPPER.readValue(OBJECT_MAPPER.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule, (Object)reread);
    }

    @Test
    public void testSerdeNullTieredReplicants() throws Exception {
        IntervalLoadRule rule = new IntervalLoadRule(Intervals.of((String)"0/3000"), null, Boolean.valueOf(false));
        Rule reread = (Rule)OBJECT_MAPPER.readValue(OBJECT_MAPPER.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule, (Object)reread);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)rule.getTieredReplicants());
    }

    @Test
    public void testCreatingNegativeTieredReplicants() {
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new IntervalLoadRule(Intervals.of((String)"0/3000"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)-1), null)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Invalid number of replicas for tier [_default_tier]. Value [-1] must be positive."));
    }

    @Test
    public void testNullReplicantValue() {
        HashMap<String, Object> tieredReplicants = new HashMap<String, Object>();
        tieredReplicants.put("tier", null);
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new IntervalLoadRule(Intervals.of((String)"0/3000"), tieredReplicants, null)), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Invalid number of replicas for tier [tier]. Value must not be null."));
    }

    @Test
    public void testShouldCreateDefaultTier() throws Exception {
        String inputJson = "     {\n      \"interval\": \"0000-01-01T00:00:00.000-05:50:36/3000-01-01T00:00:00.000-06:00\",\n      \"type\": \"loadByInterval\"\n   }";
        IntervalLoadRule inputIntervalLoadRule = (IntervalLoadRule)OBJECT_MAPPER.readValue(inputJson, IntervalLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)inputIntervalLoadRule.getTieredReplicants());
    }

    @Test
    public void testUseDefaultTierAsTrueShouldCreateDefaultTier() throws Exception {
        String inputJson = "     {\n      \"interval\": \"0000-01-01T00:00:00.000-05:50:36/3000-01-01T00:00:00.000-06:00\",\n      \"type\": \"loadByInterval\",\n      \"useDefaultTierForNull\": \"true\"\n   }";
        IntervalLoadRule inputIntervalLoadRule = (IntervalLoadRule)OBJECT_MAPPER.readValue(inputJson, IntervalLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)inputIntervalLoadRule.getTieredReplicants());
    }

    @Test
    public void testUseDefaultTierAsFalseShouldCreateEmptyMap() throws Exception {
        String inputJson = "     {\n      \"interval\": \"0000-01-01T00:00:00.000-05:50:36/3000-01-01T00:00:00.000-06:00\",\n      \"type\": \"loadByInterval\",\n      \"useDefaultTierForNull\": \"false\"\n   }";
        IntervalLoadRule inputIntervalLoadRule = (IntervalLoadRule)OBJECT_MAPPER.readValue(inputJson, IntervalLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)inputIntervalLoadRule.getTieredReplicants());
    }
}

