/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordinator.rules.PeriodLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class PeriodLoadRuleTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private static final DataSegment.Builder BUILDER = DataSegment.builder().dataSource("test").version(DateTimes.nowUtc().toString()).shardSpec((ShardSpec)NoneShardSpec.instance()).size(0L);

    @Test
    public void testAppliesToAll() {
        DateTime now = DateTimes.of((String)"2013-01-01");
        PeriodLoadRule rule = new PeriodLoadRule(new Period((Object)"P5000Y"), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"", (Object)0), null);
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(Intervals.of((String)"2012-01-01/2012-12-31")).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(Intervals.of((String)"1000-01-01/2012-12-31")).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(Intervals.of((String)"0500-01-01/2100-12-31")).build(), now));
    }

    @Test
    public void testAppliesToPeriod() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodLoadRule rule = new PeriodLoadRule(new Period((Object)"P1M"), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"", (Object)0), null);
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusWeeks(1), (ReadableInstant)now)).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusDays(1), (ReadableInstant)now.plusDays(1))).build(), now));
        Assert.assertFalse((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.plusDays(1), (ReadableInstant)now.plusDays(2))).build(), now));
    }

    @Test
    public void testAppliesToPartialOverlap() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodLoadRule rule = new PeriodLoadRule(new Period((Object)"P1M"), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"", (Object)0), null);
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusWeeks(1), (ReadableInstant)now.plusWeeks(1))).build(), now));
        Assert.assertTrue((boolean)rule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.minusMonths(1).minusWeeks(1), (ReadableInstant)now.minusMonths(1).plusWeeks(1))).build(), now));
    }

    @Test
    public void testIncludeFuture() {
        DateTime now = DateTimes.of((String)"2012-12-31T01:00:00");
        PeriodLoadRule includeFutureRule = new PeriodLoadRule(new Period((Object)"P2D"), Boolean.valueOf(true), (Map)ImmutableMap.of((Object)"", (Object)0), null);
        PeriodLoadRule notIncludeFutureRule = new PeriodLoadRule(new Period((Object)"P2D"), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"", (Object)0), null);
        Assert.assertTrue((boolean)includeFutureRule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.plusDays(1), (ReadableInstant)now.plusDays(2))).build(), now));
        Assert.assertFalse((boolean)notIncludeFutureRule.appliesTo(BUILDER.interval(new Interval((ReadableInstant)now.plusDays(1), (ReadableInstant)now.plusDays(2))).build(), now));
    }

    @Test
    public void testSerdeNull() throws Exception {
        PeriodLoadRule rule = new PeriodLoadRule(new Period((Object)"P1D"), null, null, null);
        Rule reread = (Rule)OBJECT_MAPPER.readValue(OBJECT_MAPPER.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule.getPeriod(), (Object)((PeriodLoadRule)reread).getPeriod());
        Assert.assertEquals((Object)rule.isIncludeFuture(), (Object)((PeriodLoadRule)reread).isIncludeFuture());
        Assert.assertEquals((Object)true, (Object)rule.isIncludeFuture());
        Assert.assertEquals((Object)rule.getTieredReplicants(), (Object)((PeriodLoadRule)reread).getTieredReplicants());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)rule.getTieredReplicants());
    }

    @Test
    public void testMappingNull() throws Exception {
        String inputJson = "{\n      \"period\": \"P1D\",\n      \"type\": \"loadByPeriod\"\n    }";
        String expectedJson = "{\n      \"period\": \"P1D\",\n      \"includeFuture\": true,\n      \"type\": \"loadByPeriod\"\n    }";
        PeriodLoadRule inputPeriodLoadRule = (PeriodLoadRule)OBJECT_MAPPER.readValue(inputJson, PeriodLoadRule.class);
        PeriodLoadRule expectedPeriodLoadRule = (PeriodLoadRule)OBJECT_MAPPER.readValue(expectedJson, PeriodLoadRule.class);
        Assert.assertEquals((Object)expectedPeriodLoadRule.getTieredReplicants(), (Object)inputPeriodLoadRule.getTieredReplicants());
        Assert.assertEquals((Object)expectedPeriodLoadRule.getPeriod(), (Object)inputPeriodLoadRule.getPeriod());
        Assert.assertEquals((Object)expectedPeriodLoadRule.isIncludeFuture(), (Object)inputPeriodLoadRule.isIncludeFuture());
    }

    @Test
    public void testCreatingNegativeTieredReplicants() {
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new PeriodLoadRule(Period.days((int)1), Boolean.valueOf(true), (Map)ImmutableMap.of((Object)"_default_tier", (Object)-1), Boolean.valueOf(true))), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Invalid number of replicas for tier [_default_tier]. Value [-1] must be positive."));
    }

    @Test
    public void testNullReplicantValue() {
        HashMap<String, Object> tieredReplicants = new HashMap<String, Object>();
        tieredReplicants.put("tier", null);
        MatcherAssert.assertThat((Object)Assert.assertThrows(DruidException.class, () -> new PeriodLoadRule(Period.days((int)1), Boolean.valueOf(true), tieredReplicants, Boolean.valueOf(true))), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Invalid number of replicas for tier [tier]. Value must not be null."));
    }

    @Test
    public void testShouldCreateDefaultTier() throws Exception {
        String inputJson = "      {\n      \"period\": \"P1D\",\n      \"includeFuture\": true,\n      \"type\": \"loadByPeriod\"\n    }";
        PeriodLoadRule inputPeriodLoadRule = (PeriodLoadRule)OBJECT_MAPPER.readValue(inputJson, PeriodLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)inputPeriodLoadRule.getTieredReplicants());
    }

    @Test
    public void testUseDefaultTierAsTrueShouldCreateDefaultTier() throws Exception {
        String inputJson = "      {\n      \"period\": \"P1D\",\n      \"includeFuture\": true,\n      \"useDefaultTierForNull\": \"true\",\n      \"type\": \"loadByPeriod\"\n    }";
        PeriodLoadRule inputPeriodLoadRule = (PeriodLoadRule)OBJECT_MAPPER.readValue(inputJson, PeriodLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)inputPeriodLoadRule.getTieredReplicants());
    }

    @Test
    public void testUseDefaultTierAsFalseShouldCreateEmptyMap() throws Exception {
        String inputJson = "    {\n     \"period\": \"P1D\",\n     \"includeFuture\": true,\n     \"useDefaultTierForNull\": \"false\",\n     \"type\": \"loadByPeriod\"\n  }";
        PeriodLoadRule inputPeriodLoadRule = (PeriodLoadRule)OBJECT_MAPPER.readValue(inputJson, PeriodLoadRule.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)inputPeriodLoadRule.getTieredReplicants());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(PeriodLoadRule.class).withNonnullFields(new String[]{"tieredReplicants"}).withIgnoredFields(new String[]{"shouldSegmentBeLoaded"}).usingGetClass().verify();
    }
}

