/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.UUID;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.server.log.LoggingRequestLogger;
import org.apache.druid.server.log.NoopRequestLogger;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.RequestLoggerProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class LoggingRequestLoggerProviderTest {
    private final String propertyPrefix = UUID.randomUUID().toString().replace('-', '_');
    private final JsonConfigProvider<RequestLoggerProvider> provider = JsonConfigProvider.of((String)this.propertyPrefix, RequestLoggerProvider.class);
    private final Injector injector = this.makeInjector();

    @Test
    public void testDefaultConfigParsing() {
        Properties properties = new Properties();
        properties.put(this.propertyPrefix + ".type", "slf4j");
        this.provider.inject(properties, (JsonConfigurator)this.injector.getInstance(JsonConfigurator.class));
        LoggingRequestLogger requestLogger = (LoggingRequestLogger)((RequestLoggerProvider)this.provider.get()).get();
        Assert.assertFalse((boolean)requestLogger.isSetContextMDC());
        Assert.assertFalse((boolean)requestLogger.isSetMDC());
    }

    @Test
    public void testConfigParsingFull() {
        Properties properties = new Properties();
        properties.put(this.propertyPrefix + ".type", "slf4j");
        properties.put(this.propertyPrefix + ".setMDC", "true");
        properties.put(this.propertyPrefix + ".setContextMDC", "true");
        this.provider.inject(properties, (JsonConfigurator)this.injector.getInstance(JsonConfigurator.class));
        LoggingRequestLogger requestLogger = (LoggingRequestLogger)((RequestLoggerProvider)this.provider.get()).get();
        Assert.assertTrue((boolean)requestLogger.isSetContextMDC());
        Assert.assertTrue((boolean)requestLogger.isSetMDC());
    }

    @Test
    public void testNoopConfigParsing() {
        Properties properties = new Properties();
        properties.put(this.propertyPrefix + ".type", "noop");
        this.provider.inject(properties, (JsonConfigurator)this.injector.getInstance(JsonConfigurator.class));
        Assert.assertThat((Object)((RequestLoggerProvider)this.provider.get()).get(), (Matcher)Matchers.instanceOf(NoopRequestLogger.class));
    }

    private Injector makeInjector() {
        return Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new QueryableModule(){

            public void configure(Binder binder) {
                binder.bind(RequestLogger.class).toProvider(RequestLoggerProvider.class).in(ManageLifecycle.class);
                binder.bind(Key.get(String.class, (Annotation)Names.named((String)"serviceName"))).toInstance((Object)"some service");
                binder.bind(Key.get(Integer.class, (Annotation)Names.named((String)"servicePort"))).toInstance((Object)0);
                binder.bind(Key.get(Integer.class, (Annotation)Names.named((String)"tlsServicePort"))).toInstance((Object)-1);
                JsonConfigProvider.bind((Binder)binder, (String)LoggingRequestLoggerProviderTest.this.propertyPrefix, RequestLoggerProvider.class);
            }
        }));
    }
}

