/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.utils.JvmUtils;

@LazySingleton
public class DirectDruidClientFactory {
    private final ServiceEmitter emitter;
    private final QueryToolChestWarehouse warehouse;
    private final QueryWatcher queryWatcher;
    private final ObjectMapper smileMapper;
    private final HttpClient httpClient;
    private final ScheduledExecutorService queryCancellationExecutor;

    @Inject
    public DirectDruidClientFactory(ServiceEmitter emitter, QueryToolChestWarehouse warehouse, QueryWatcher queryWatcher, @Smile ObjectMapper smileMapper, @EscalatedClient HttpClient httpClient) {
        this.emitter = emitter;
        this.warehouse = warehouse;
        this.queryWatcher = queryWatcher;
        this.smileMapper = smileMapper;
        this.httpClient = httpClient;
        int threadCount = Math.max(1, JvmUtils.getRuntimeInfo().getAvailableProcessors() / 2);
        this.queryCancellationExecutor = ScheduledExecutors.fixed((int)threadCount, (String)"query-cancellation-executor");
    }

    public DirectDruidClient makeDirectClient(DruidServer server) {
        return new DirectDruidClient(this.warehouse, this.queryWatcher, this.smileMapper, this.httpClient, server.getScheme(), server.getHost(), this.emitter, this.queryCancellationExecutor);
    }
}

