/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.nio.ByteBuffer;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DummyBlockingPool;
import org.apache.druid.collections.DummyNonBlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.query.ForwardingQueryProcessingPool;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.server.metrics.MetricsModule;

public class RouterProcessingModule
implements Module {
    private static final Logger log = new Logger(RouterProcessingModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.processing", DruidProcessingConfig.class);
        MetricsModule.register(binder, ExecutorServiceMonitor.class);
    }

    @Provides
    @ManageLifecycle
    public QueryProcessingPool getProcessingExecutorPool(DruidProcessingConfig config) {
        if (config.isNumThreadsConfigured()) {
            log.warn("numThreads[%d] configured, that is ignored on Router", new Object[]{config.getNumThreads()});
        }
        return new ForwardingQueryProcessingPool(Execs.dummy());
    }

    @Provides
    @LazySingleton
    @Global
    public NonBlockingPool<ByteBuffer> getIntermediateResultsPool() {
        return DummyNonBlockingPool.instance();
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(DruidProcessingConfig config) {
        if (config.isNumMergeBuffersConfigured()) {
            log.warn("numMergeBuffers[%d] configured, that is ignored on Router", new Object[]{config.getNumMergeBuffers()});
        }
        return DummyBlockingPool.instance();
    }

    @Provides
    @LazySingleton
    @Merging
    public GroupByResourcesReservationPool getGroupByResourcesReservationPool(@Merging BlockingPool<ByteBuffer> mergeBufferPool, GroupByQueryConfig groupByQueryConfig) {
        return new GroupByResourcesReservationPool(mergeBufferPool, groupByQueryConfig);
    }
}

