/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.server;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.messages.server.Outbox;

public class MessageRelayMonitor {
    private final DruidNodeDiscoveryProvider discoveryProvider;
    private final Outbox<?> outbox;
    private final NodeRole clientRole;

    public MessageRelayMonitor(DruidNodeDiscoveryProvider discoveryProvider, Outbox<?> outbox, NodeRole clientRole) {
        this.discoveryProvider = discoveryProvider;
        this.outbox = outbox;
        this.clientRole = clientRole;
    }

    @LifecycleStart
    public void start() {
        this.discoveryProvider.getForNodeRole(this.clientRole).registerListener(new ClientListener());
    }

    private class ClientListener
    implements DruidNodeDiscovery.Listener {
        private ClientListener() {
        }

        @Override
        public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
        }

        @Override
        public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
            Set hostsRemoved = nodes.stream().map(node -> node.getDruidNode().getHostAndPortToUse()).collect(Collectors.toSet());
            for (String clientHost : hostsRemoved) {
                MessageRelayMonitor.this.outbox.resetOutbox(clientHost);
            }
        }
    }
}

