/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.IndexingWorkerInfo;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionProgressResponse;
import org.apache.druid.server.compaction.CompactionSimulateResult;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.compaction.Table;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.timeline.SegmentTimeline;
import org.joda.time.Interval;

public class CompactionRunSimulator {
    private final CompactionStatusTracker statusTracker;
    private final OverlordClient readOnlyOverlordClient;

    public CompactionRunSimulator(CompactionStatusTracker statusTracker, OverlordClient overlordClient) {
        this.statusTracker = statusTracker;
        this.readOnlyOverlordClient = new ReadOnlyOverlordClient(overlordClient);
    }

    public CompactionSimulateResult simulateRunWithConfig(DruidCompactionConfig compactionConfig, Map<String, SegmentTimeline> datasourceTimelines, CompactionEngine defaultEngine) {
        final Table compactedIntervals = Table.withColumnNames("dataSource", "interval", "numSegments", "bytes");
        final Table runningIntervals = Table.withColumnNames("dataSource", "interval", "numSegments", "bytes", "maxTaskSlots", "reasonToCompact");
        final Table queuedIntervals = Table.withColumnNames("dataSource", "interval", "numSegments", "bytes", "maxTaskSlots", "reasonToCompact");
        final Table skippedIntervals = Table.withColumnNames("dataSource", "interval", "numSegments", "bytes", "reasonToSkip");
        CompactionStatusTracker simulationStatusTracker = new CompactionStatusTracker(null){

            @Override
            public CompactionStatus computeCompactionStatus(CompactionCandidate candidate, DataSourceCompactionConfig config, CompactionCandidateSearchPolicy searchPolicy) {
                return CompactionRunSimulator.this.statusTracker.computeCompactionStatus(candidate, config, searchPolicy);
            }

            @Override
            public void onCompactionStatusComputed(CompactionCandidate candidateSegments, DataSourceCompactionConfig config) {
                CompactionStatus status = candidateSegments.getCurrentStatus();
                if (status != null) {
                    if (status.getState() == CompactionStatus.State.COMPLETE) {
                        compactedIntervals.addRow(CompactionRunSimulator.this.createRow(candidateSegments, null, null));
                    } else if (status.getState() == CompactionStatus.State.RUNNING) {
                        runningIntervals.addRow(CompactionRunSimulator.this.createRow(candidateSegments, ClientCompactionTaskQueryTuningConfig.from(config), status.getReason()));
                    } else if (status.getState() == CompactionStatus.State.SKIPPED) {
                        skippedIntervals.addRow(CompactionRunSimulator.this.createRow(candidateSegments, null, status.getReason()));
                    }
                }
            }

            @Override
            public void onTaskSubmitted(ClientCompactionTaskQuery taskPayload, CompactionCandidate candidateSegments) {
                CompactionStatus status = candidateSegments.getCurrentStatus();
                queuedIntervals.addRow(CompactionRunSimulator.this.createRow(candidateSegments, taskPayload.getTuningConfig(), status == null ? "" : status.getReason()));
            }
        };
        DruidCompactionConfig configWithUnlimitedTaskSlots = compactionConfig.withClusterConfig(new ClusterCompactionConfig(1.0, Integer.MAX_VALUE, null, null));
        CoordinatorRunStats stats = new CoordinatorRunStats();
        new CompactSegments(simulationStatusTracker, this.readOnlyOverlordClient).run(configWithUnlimitedTaskSlots, datasourceTimelines, defaultEngine, stats);
        HashMap<CompactionStatus.State, Table> compactionStates = new HashMap<CompactionStatus.State, Table>();
        if (!compactedIntervals.isEmpty()) {
            compactionStates.put(CompactionStatus.State.COMPLETE, compactedIntervals);
        }
        if (!runningIntervals.isEmpty()) {
            compactionStates.put(CompactionStatus.State.RUNNING, runningIntervals);
        }
        if (!queuedIntervals.isEmpty()) {
            compactionStates.put(CompactionStatus.State.PENDING, queuedIntervals);
        }
        if (!skippedIntervals.isEmpty()) {
            compactionStates.put(CompactionStatus.State.SKIPPED, skippedIntervals);
        }
        return new CompactionSimulateResult(compactionStates);
    }

    private Object[] createRow(CompactionCandidate candidate, ClientCompactionTaskQueryTuningConfig tuningConfig, String reason) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(candidate.getDataSource());
        row.add(candidate.getUmbrellaInterval());
        row.add(candidate.numSegments());
        row.add(candidate.getTotalBytes());
        if (tuningConfig != null) {
            row.add(CompactSegments.findMaxNumTaskSlotsUsedByOneNativeCompactionTask(tuningConfig));
        }
        if (reason != null) {
            row.add(reason);
        }
        return row.toArray(new Object[0]);
    }

    private static class ReadOnlyOverlordClient
    implements OverlordClient {
        final OverlordClient delegate;

        ReadOnlyOverlordClient(OverlordClient delegate) {
            this.delegate = delegate;
        }

        @Override
        public ListenableFuture<CloseableIterator<TaskStatusPlus>> taskStatuses(@Nullable String state, @Nullable String dataSource, @Nullable Integer maxCompletedTasks) {
            return this.delegate.taskStatuses(state, dataSource, maxCompletedTasks);
        }

        @Override
        public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
            return this.delegate.taskStatuses(taskIds);
        }

        @Override
        public ListenableFuture<TaskPayloadResponse> taskPayload(String taskId) {
            return this.delegate.taskPayload(taskId);
        }

        @Override
        public ListenableFuture<Map<String, List<Interval>>> findLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
            return this.delegate.findLockedIntervals(lockFilterPolicies);
        }

        @Override
        public ListenableFuture<IndexingTotalWorkerCapacityInfo> getTotalWorkerCapacity() {
            return Futures.immediateFuture((Object)new IndexingTotalWorkerCapacityInfo(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }

        @Override
        public ListenableFuture<Void> runTask(String taskId, Object taskObject) {
            return Futures.immediateVoidFuture();
        }

        @Override
        public ListenableFuture<Void> cancelTask(String taskId) {
            return Futures.immediateVoidFuture();
        }

        @Override
        public ListenableFuture<URI> findCurrentLeader() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<TaskStatusResponse> taskStatus(String taskId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<TaskReport.ReportMap> taskReportAsMap(String taskId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<CloseableIterator<SupervisorStatus>> supervisorStatuses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<Integer> killPendingSegments(String dataSource, Interval interval) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<List<IndexingWorkerInfo>> getWorkers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<CompactionStatusResponse> getCompactionSnapshots(@Nullable String dataSource) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<CompactionProgressResponse> getBytesAwaitingCompaction(String dataSource) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListenableFuture<Boolean> isCompactionSupervisorEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OverlordClient withRetryPolicy(ServiceRetryPolicy retryPolicy) {
            return this;
        }
    }
}

