/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;

public class BroadcastDatasourceLoadingSpec {
    public static final String CTX_BROADCAST_DATASOURCE_LOADING_MODE = "broadcastDatasourceLoadingMode";
    public static final String CTX_BROADCAST_DATASOURCES_TO_LOAD = "broadcastDatasourcesToLoad";
    private final Mode mode;
    @Nullable
    private final ImmutableSet<String> broadcastDatasourcesToLoad;
    public static final BroadcastDatasourceLoadingSpec ALL = new BroadcastDatasourceLoadingSpec(Mode.ALL, null);
    public static final BroadcastDatasourceLoadingSpec NONE = new BroadcastDatasourceLoadingSpec(Mode.NONE, null);

    private BroadcastDatasourceLoadingSpec(Mode mode, @Nullable Set<String> broadcastDatasourcesToLoad) {
        this.mode = mode;
        this.broadcastDatasourcesToLoad = broadcastDatasourcesToLoad == null ? null : ImmutableSet.copyOf(broadcastDatasourcesToLoad);
    }

    public static BroadcastDatasourceLoadingSpec loadOnly(Set<String> broadcastDatasourcesToLoad) {
        if (broadcastDatasourcesToLoad == null) {
            throw InvalidInput.exception((String)"Expected non-null set of broadcast datasources to load.", (Object[])new Object[0]);
        }
        return new BroadcastDatasourceLoadingSpec(Mode.ONLY_REQUIRED, broadcastDatasourcesToLoad);
    }

    public Mode getMode() {
        return this.mode;
    }

    public ImmutableSet<String> getBroadcastDatasourcesToLoad() {
        return this.broadcastDatasourcesToLoad;
    }

    public static BroadcastDatasourceLoadingSpec createFromContext(Map<String, Object> context, BroadcastDatasourceLoadingSpec defaultSpec) {
        Mode broadcastDatasourceLoadingMode;
        if (context == null) {
            return defaultSpec;
        }
        Object broadcastDatasourceModeValue = context.get(CTX_BROADCAST_DATASOURCE_LOADING_MODE);
        if (broadcastDatasourceModeValue == null) {
            return defaultSpec;
        }
        try {
            broadcastDatasourceLoadingMode = Mode.valueOf(broadcastDatasourceModeValue.toString());
        }
        catch (IllegalArgumentException e) {
            throw InvalidInput.exception((String)"Invalid value of %s[%s]. Allowed values are %s", (Object[])new Object[]{CTX_BROADCAST_DATASOURCE_LOADING_MODE, broadcastDatasourceModeValue.toString(), Arrays.asList(Mode.values())});
        }
        if (broadcastDatasourceLoadingMode == Mode.NONE) {
            return NONE;
        }
        if (broadcastDatasourceLoadingMode == Mode.ALL) {
            return ALL;
        }
        if (broadcastDatasourceLoadingMode == Mode.ONLY_REQUIRED) {
            Collection broadcastDatasourcesToLoad;
            try {
                broadcastDatasourcesToLoad = (Collection)context.get(CTX_BROADCAST_DATASOURCES_TO_LOAD);
            }
            catch (ClassCastException e) {
                throw InvalidInput.exception((String)"Invalid value of %s[%s]. Please provide a comma-separated list of broadcast datasource names. For example: [\"datasourceName1\", \"datasourceName2\"]", (Object[])new Object[]{CTX_BROADCAST_DATASOURCES_TO_LOAD, context.get(CTX_BROADCAST_DATASOURCES_TO_LOAD)});
            }
            if (broadcastDatasourcesToLoad == null || broadcastDatasourcesToLoad.isEmpty()) {
                throw InvalidInput.exception((String)"Set of broadcast datasources to load cannot be %s for mode[ONLY_REQUIRED].", (Object[])new Object[]{broadcastDatasourcesToLoad});
            }
            return BroadcastDatasourceLoadingSpec.loadOnly(new HashSet<String>(broadcastDatasourcesToLoad));
        }
        return defaultSpec;
    }

    public String toString() {
        return "BroadcastDatasourceLoadingSpec{mode=" + (Object)((Object)this.mode) + ", broadcastDatasourcesToLoad=" + this.broadcastDatasourcesToLoad + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastDatasourceLoadingSpec that = (BroadcastDatasourceLoadingSpec)o;
        return this.mode == that.mode && Objects.equals(this.broadcastDatasourcesToLoad, that.broadcastDatasourcesToLoad);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.broadcastDatasourcesToLoad});
    }

    public static enum Mode {
        ALL,
        NONE,
        ONLY_REQUIRED;

    }
}

