/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.server.metrics.QueryCountStatsProvider;

public class QueryCountStatsMonitor
extends AbstractMonitor {
    private final KeyedDiff keyedDiff = new KeyedDiff();
    private final QueryCountStatsProvider statsProvider;
    private final BlockingPool<ByteBuffer> mergeBufferPool;

    @Inject
    public QueryCountStatsMonitor(QueryCountStatsProvider statsProvider, @Merging BlockingPool<ByteBuffer> mergeBufferPool) {
        this.statsProvider = statsProvider;
        this.mergeBufferPool = mergeBufferPool;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        long timedOutQueryCount;
        long interruptedQueryCount;
        long failedQueryCount;
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        long successfulQueryCount = this.statsProvider.getSuccessfulQueryCount();
        Map diff = this.keyedDiff.to("queryCountStats", (Map)ImmutableMap.of((Object)"query/count", (Object)(successfulQueryCount + (failedQueryCount = this.statsProvider.getFailedQueryCount()) + (interruptedQueryCount = this.statsProvider.getInterruptedQueryCount()) + (timedOutQueryCount = this.statsProvider.getTimedOutQueryCount())), (Object)"query/success/count", (Object)successfulQueryCount, (Object)"query/failed/count", (Object)failedQueryCount, (Object)"query/interrupted/count", (Object)interruptedQueryCount, (Object)"query/timeout/count", (Object)timedOutQueryCount));
        if (diff != null) {
            for (Map.Entry diffEntry : diff.entrySet()) {
                emitter.emit((ServiceEventBuilder)builder.setMetric((String)diffEntry.getKey(), (Number)diffEntry.getValue()));
            }
        }
        long pendingQueries = this.mergeBufferPool.getPendingRequests();
        emitter.emit((ServiceEventBuilder)builder.setMetric("mergeBuffer/pendingRequests", (Number)pendingQueries));
        return true;
    }
}

