/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.Duration;

public class TestChangeRequestHttpClient<R>
implements HttpClient {
    private final ObjectMapper mapper;
    private final TypeReference<R> typeReference;
    private final BlockingQueue<ResultHolder<?>> results = new LinkedBlockingQueue();
    private final AtomicInteger requestCount = new AtomicInteger(0);

    public TestChangeRequestHttpClient(TypeReference<R> typeReference, ObjectMapper mapper) {
        this.mapper = mapper;
        this.typeReference = typeReference;
    }

    public void failToSendNextRequestWith(RuntimeException error) {
        this.results.add(new ResultHolder(null, error, null));
    }

    public void completeNextRequestWith(DruidException druidException) {
        this.results.add(new ResultHolder(null, null, druidException));
    }

    public void completeNextRequestWith(R result) {
        this.results.add(new ResultHolder<Object>(() -> result, null, null));
    }

    public boolean hasPendingResults() {
        return !this.results.isEmpty();
    }

    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
        throw new UnsupportedOperationException("Not Implemented.");
    }

    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler, Duration duration) {
        int currentRequest = this.requestCount.getAndIncrement();
        ResultHolder nextResult = (ResultHolder)this.results.poll();
        if (nextResult == null) {
            throw new ISE("No known response for request [%d]", new Object[]{currentRequest});
        }
        if (nextResult.clientError != null) {
            throw nextResult.clientError;
        }
        if (nextResult.serverError != null) {
            HttpResponse errorResponse = this.buildErrorResponse(nextResult.serverError);
            httpResponseHandler.handleResponse(errorResponse, null);
            return Futures.immediateFuture((Object)new ByteArrayInputStream(new byte[0]));
        }
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        httpResponse.setContent(ChannelBuffers.buffer((int)0));
        httpResponseHandler.handleResponse((HttpResponse)httpResponse, null);
        try {
            ByteArrayInputStream resultBytes = new ByteArrayInputStream(this.mapper.writerFor(this.typeReference).writeValueAsBytes(nextResult.supplier.get()));
            return Futures.immediateFuture((Object)resultBytes);
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Error while sending HTTP response: %s", new Object[]{e.getMessage()});
        }
    }

    private HttpResponse buildErrorResponse(DruidException druidException) {
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)druidException.getStatusCode()));
        httpResponse.setContent(ChannelBuffers.buffer((int)0));
        ErrorResponse errorResponse = druidException.toErrorResponse();
        try {
            httpResponse.setContent(ChannelBuffers.copiedBuffer((byte[])this.mapper.writeValueAsBytes((Object)errorResponse)));
            return httpResponse;
        }
        catch (JsonProcessingException e) {
            throw new ISE("Error while serializing given response", new Object[0]);
        }
    }

    private static class ResultHolder<R> {
        final Supplier<R> supplier;
        final RuntimeException clientError;
        final DruidException serverError;

        ResultHolder(Supplier<R> supplier, RuntimeException clientError, DruidException serverError) {
            this.supplier = supplier;
            this.clientError = clientError;
            this.serverError = serverError;
        }
    }
}

