/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.discovery.DataServerClient;
import org.apache.druid.discovery.DruidServiceTestUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.DefaultResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.rpc.MockServiceClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DataServerClientTest {
    private static final SegmentDescriptor SEGMENT_1 = new SegmentDescriptor(Intervals.of((String)"2003/2004"), "v0", 1);
    private MockServiceClient serviceClient;
    private ObjectMapper jsonMapper;
    private ScanQuery query;
    private DataServerClient target;

    @Before
    public void setUp() {
        this.jsonMapper = DruidServiceTestUtils.newJsonMapper();
        this.serviceClient = new MockServiceClient();
        ServiceClientFactory serviceClientFactory = (serviceName, serviceLocator, retryPolicy) -> this.serviceClient;
        this.query = Druids.newScanQueryBuilder().dataSource("dataSource1").intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec((List)ImmutableList.of((Object)SEGMENT_1))).columns(new String[]{"__time", "cnt", "dim1", "dim2", "m1", "m2", "unique_dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context((Map)ImmutableMap.of((Object)"defaultTimeout", (Object)5000L)).build();
        this.target = new DataServerClient(serviceClientFactory, (ServiceLocation)Mockito.mock(ServiceLocation.class), this.jsonMapper, Execs.scheduledSingleThreaded((String)"query-cancellation-executor"));
    }

    @Test
    public void testFetchSegmentFromDataServer() throws JsonProcessingException {
        ScanResultValue scanResultValue = new ScanResultValue(null, (List)ImmutableList.of((Object)"id", (Object)"name"), (Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"abc"), (Object)ImmutableList.of((Object)5, (Object)"efg")));
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.POST, "/druid/v2/").jsonContent(this.jsonMapper, (Object)this.query);
        this.serviceClient.expectAndRespond(requestBuilder, HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(scanResultValue)));
        DefaultResponseContext responseContext = DefaultResponseContext.createEmpty();
        Sequence result = this.target.run((Query)this.query, (ResponseContext)responseContext, this.jsonMapper.getTypeFactory().constructType(ScanResultValue.class), Closer.create());
        Assert.assertEquals((Object)ImmutableList.of((Object)scanResultValue), (Object)result.toList());
    }

    @Test
    public void testMissingSegmentsHeaderShouldAccumulate() throws JsonProcessingException {
        DataServerResponse dataServerResponse = new DataServerResponse((List<SegmentDescriptor>)ImmutableList.of((Object)SEGMENT_1));
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.POST, "/druid/v2/").jsonContent(this.jsonMapper, (Object)this.query);
        this.serviceClient.expectAndRespond(requestBuilder, HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json", (Object)"X-Druid-Response-Context", (Object)this.jsonMapper.writeValueAsString((Object)dataServerResponse)), this.jsonMapper.writeValueAsBytes(null));
        DefaultResponseContext responseContext = new DefaultResponseContext();
        this.target.run((Query)this.query, (ResponseContext)responseContext, this.jsonMapper.getTypeFactory().constructType(ScanResultValue.class), Closer.create());
        Assert.assertEquals((long)1L, (long)responseContext.getMissingSegments().size());
    }

    @Test
    public void testQueryFailure() throws JsonProcessingException {
        ScanQuery scanQueryWithTimeout = this.query.withOverriddenContext((Map)ImmutableMap.of((Object)"maxQueuedBytes", (Object)1, (Object)"timeout", (Object)0));
        ScanResultValue scanResultValue = new ScanResultValue(null, (List)ImmutableList.of((Object)"id", (Object)"name"), (Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"abc"), (Object)ImmutableList.of((Object)5, (Object)"efg")));
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.POST, "/druid/v2/").jsonContent(this.jsonMapper, (Object)scanQueryWithTimeout);
        this.serviceClient.expectAndRespond(requestBuilder, HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json"), this.jsonMapper.writeValueAsBytes(Collections.singletonList(scanResultValue)));
        DefaultResponseContext responseContext = new DefaultResponseContext();
        Assert.assertThrows(QueryTimeoutException.class, () -> this.lambda$testQueryFailure$1(scanQueryWithTimeout, (ResponseContext)responseContext));
    }

    private /* synthetic */ void lambda$testQueryFailure$1(ScanQuery scanQueryWithTimeout, ResponseContext responseContext) throws Throwable {
        this.target.run((Query)scanQueryWithTimeout, responseContext, this.jsonMapper.getTypeFactory().constructType(ScanResultValue.class), Closer.create()).toList();
    }

    private static class DataServerResponse {
        List<SegmentDescriptor> missingSegments;

        @JsonCreator
        public DataServerResponse(@JsonProperty(value="missingSegments") List<SegmentDescriptor> missingSegments) {
            this.missingSegments = missingSegments;
        }

        @JsonProperty(value="missingSegments")
        public List<SegmentDescriptor> getMissingSegments() {
            return this.missingSegments;
        }
    }
}

