/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.StringUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class JsonConfigTesterBase<T> {
    protected static final String CONFIG_PREFIX = "druid.test.prefix";
    protected Injector injector;
    protected final Class<T> clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    protected Map<String, String> propertyValues = new HashMap<String, String>();
    protected int assertions = 0;
    protected Properties testProperties = new Properties();
    private final Module simpleJsonConfigModule = new Module(){

        public void configure(Binder binder) {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            JsonConfigProvider.bind((Binder)binder, (String)JsonConfigTesterBase.CONFIG_PREFIX, JsonConfigTesterBase.this.clazz);
        }
    };
    protected JsonConfigurator configurator;
    protected JsonConfigProvider<T> configProvider;

    protected static String getPropertyKey(String fieldName) {
        return StringUtils.format((String)"%s.%s", (Object[])new Object[]{CONFIG_PREFIX, fieldName});
    }

    protected static String getPropertyKey(Field field) {
        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
        if (null != jsonProperty) {
            return JsonConfigTesterBase.getPropertyKey(jsonProperty.value() == null || jsonProperty.value().isEmpty() ? field.getName() : jsonProperty.value());
        }
        return null;
    }

    protected final void validateEntries(T config) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        for (Field field : this.clazz.getDeclaredFields()) {
            String propertyKey = JsonConfigTesterBase.getPropertyKey(field);
            if (null == propertyKey) continue;
            field.setAccessible(true);
            String getter = StringUtils.format((String)"get%s%s", (Object[])new Object[]{StringUtils.toUpperCase((String)field.getName().substring(0, 1)), field.getName().substring(1)});
            Method method = this.clazz.getDeclaredMethod(getter, new Class[0]);
            String value = null != method ? method.invoke(config, new Object[0]).toString() : field.get(config).toString();
            Assert.assertEquals((Object)this.propertyValues.get(propertyKey), (Object)value);
            ++this.assertions;
        }
    }

    @Before
    public void setup() throws IllegalAccessException {
        this.assertions = 0;
        Object fakeValues = EasyMock.createNiceMock(this.clazz);
        this.propertyValues.clear();
        this.testProperties.clear();
        for (Field field : this.clazz.getDeclaredFields()) {
            String propertyKey = JsonConfigTesterBase.getPropertyKey(field);
            if (null == propertyKey) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (String.class.isAssignableFrom(fieldType)) {
                this.propertyValues.put(propertyKey, UUID.randomUUID().toString());
                continue;
            }
            if (Collection.class.isAssignableFrom(fieldType)) {
                this.propertyValues.put(propertyKey, "[]");
                continue;
            }
            if (Map.class.isAssignableFrom(fieldType)) {
                this.propertyValues.put(propertyKey, "{}");
                continue;
            }
            this.propertyValues.put(propertyKey, String.valueOf(field.get(fakeValues)));
        }
        this.testProperties.putAll((Map<?, ?>)System.getProperties());
        this.testProperties.putAll(this.propertyValues);
        this.injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)this.simpleJsonConfigModule));
        this.configurator = (JsonConfigurator)this.injector.getBinding(JsonConfigurator.class).getProvider().get();
        this.configProvider = JsonConfigProvider.of((String)CONFIG_PREFIX, this.clazz);
    }

    @Test
    public final void simpleInjectionTest() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        this.configProvider.inject(this.testProperties, this.configurator);
        this.validateEntries(this.configProvider.get());
        Assert.assertEquals((long)this.propertyValues.size(), (long)this.assertions);
    }
}

