/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.google.common.collect.ImmutableMap;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManagerConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class SupervisorStateManagerTest {
    SupervisorStateManagerConfig stateManagerConfig;

    @Test
    public void testMarkRunFinishedIfSupervisorIsIdle() {
        this.stateManagerConfig = new SupervisorStateManagerConfig();
        SupervisorStateManager supervisorStateManager = new SupervisorStateManager(this.stateManagerConfig, false);
        Assert.assertFalse((boolean)this.stateManagerConfig.isIdleConfigEnabled());
        Assert.assertEquals((long)600000L, (long)this.stateManagerConfig.getInactiveAfterMillis());
        supervisorStateManager.markRunFinished();
        Assert.assertEquals((Object)SupervisorStateManager.BasicState.RUNNING, (Object)supervisorStateManager.getSupervisorState());
        supervisorStateManager.maybeSetState((SupervisorStateManager.State)SupervisorStateManager.BasicState.IDLE);
        supervisorStateManager.markRunFinished();
        Assert.assertEquals((Object)SupervisorStateManager.BasicState.IDLE, (Object)supervisorStateManager.getSupervisorState());
    }

    @Test
    public void testIdleConfigSerde() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        ImmutableMap config = ImmutableMap.of((Object)"idleConfig.enabled", (Object)"true", (Object)"idleConfig.inactiveAfterMillis", (Object)"60000");
        this.stateManagerConfig = (SupervisorStateManagerConfig)mapper.convertValue((Object)config, SupervisorStateManagerConfig.class);
        Assert.assertTrue((boolean)this.stateManagerConfig.isIdleConfigEnabled());
        Assert.assertEquals((long)60000L, (long)this.stateManagerConfig.getInactiveAfterMillis());
    }
}

